/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.syntheticaaddons.table;

import java.awt.Component;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.util.Date;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class ObjectTableCellRenderer
implements TableCellRenderer {
    protected TableCellRenderer delegate;
    protected HashMap<String, TableCellRenderer> renderers = new HashMap();
    private Object numberFormat = NumberFormat.getInstance();
    private Object dateFormat = DateFormat.getInstance();

    public ObjectTableCellRenderer(TableCellRenderer defaultRenderer) {
        this.delegate = defaultRenderer;
    }

    public void addRenderer(Class<?> dataClass, TableCellRenderer renderer) {
        this.renderers.put(this.getRendererKey(dataClass), renderer);
    }

    public void removeRenderer(Class<?> dataClass) {
        this.renderers.remove(this.getRendererKey(dataClass));
    }

    public TableCellRenderer getRenderer(Class<?> dataClass) {
        return this.renderers.get(this.getRendererKey(dataClass));
    }

    public void addRenderer(int row, int column, TableCellRenderer renderer) {
        this.renderers.put(this.getRendererKey(row, column), renderer);
    }

    public void removeRenderer(int row, int column) {
        this.renderers.remove(this.getRendererKey(row, column));
    }

    public TableCellRenderer getRenderer(int row, int column) {
        return this.renderers.get(this.getRendererKey(row, column));
    }

    private String getRendererKey(Class<?> dataClass) {
        return this.getRendererKey(dataClass, -1, -1);
    }

    private String getRendererKey(int row, int column) {
        return this.getRendererKey(null, row, column);
    }

    private String getRendererKey(Class<?> dataClass, int row, int column) {
        return dataClass + "/" + row + "/" + column;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        TableCellRenderer r = this.getRenderer(table.convertRowIndexToModel(row), table.convertColumnIndexToModel(column));
        if (r == null) {
            r = this.getRenderer(value == null ? Object.class : value.getClass());
        }
        if (r == null) {
            TableCellRenderer tableCellRenderer = r = value == null ? null : this.getRenderer(value.getClass().getSuperclass());
        }
        if (r != null) {
            return r.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
        Component c = this.delegate.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (c instanceof JLabel) {
            this.configureValue((JLabel)c, value);
        }
        return c;
    }

    private void configureValue(JLabel l, Object value) {
        if (value instanceof Number) {
            l.setHorizontalAlignment(11);
            if (value instanceof Float || value instanceof Double) {
                l.setText(value == null ? "" : ((NumberFormat)this.numberFormat).format(value));
            }
        } else if (value instanceof Icon) {
            l.setHorizontalAlignment(0);
            l.setIcon((Icon)value);
            l.setText("");
        } else if (value instanceof Date) {
            if (this.dateFormat == null) {
                this.dateFormat = DateFormat.getDateInstance();
            }
            l.setHorizontalAlignment(10);
            l.setText(value == null ? "" : ((Format)this.dateFormat).format(value));
        }
    }
}

