/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.syntheticaaddons.ui;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.syntheticaaddons.ui.painter.HyperlinkPainter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.text.View;
import org.jdesktop.swingx.JXHyperlink;
import org.jdesktop.swingx.plaf.basic.BasicHyperlinkUI;

public class HyperlinkUI
extends BasicHyperlinkUI {
    public static ComponentUI createUI(JComponent c) {
        return new HyperlinkUI();
    }

    protected void installDefaults(AbstractButton b) {
        Color clickedForeground;
        JXHyperlink hl;
        Color unclickedForeground;
        super.installDefaults(b);
        b.setFocusable(true);
        Font font = b.getFont();
        if (font instanceof FontUIResource) {
            float fontSize = font.getSize2D();
            b.setFont(new FontUIResource(font.deriveFont(0, fontSize)));
        }
        if ((unclickedForeground = (hl = (JXHyperlink)b).getUnclickedColor()) == null || unclickedForeground instanceof UIResource) {
            Color color = SyntheticaLookAndFeel.getColor((String)"JXHyperlink.unclickedColor", (Component)b, (Color)new ColorUIResource(13311));
            hl.setUnclickedColor(color);
        }
        if ((clickedForeground = hl.getClickedColor()) == null || clickedForeground instanceof UIResource) {
            Color color = SyntheticaLookAndFeel.getColor((String)"JXHyperlink.clickedColor", (Component)b, (Color)new ColorUIResource(0x990099));
            hl.setClickedColor(color);
        }
    }

    public void paint(Graphics g, JComponent c) {
        Rectangle viewRect = new Rectangle(0, 0, 0, 0);
        Rectangle textRect = new Rectangle(0, 0, 0, 0);
        Rectangle iconRect = new Rectangle(0, 0, 0, 0);
        int state = c.isEnabled() ? 0 : 8;
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        boolean hover = model.isRollover();
        Insets i = c.getInsets();
        viewRect.x = i.left;
        viewRect.y = i.top;
        viewRect.width = b.getWidth() - (i.right + viewRect.x);
        viewRect.height = b.getHeight() - (i.bottom + viewRect.y);
        int textGap = b.getText() == null ? 0 : b.getIconTextGap();
        SynthStyle ss = SynthLookAndFeel.getStyle(b, Region.BUTTON);
        SynthContext sc = new SynthContext(b, Region.BUTTON, ss, state);
        String text = ss.getGraphicsUtils(sc).layoutText(sc, g.getFontMetrics(), b.getText(), b.getIcon(), b.getHorizontalAlignment(), b.getVerticalAlignment(), b.getHorizontalTextPosition(), b.getVerticalTextPosition(), viewRect, iconRect, textRect, textGap);
        this.clearTextShiftOffset();
        if (b.getIcon() != null) {
            this.paintIcon(g, c, iconRect);
        }
        if (text != null && text.trim().length() > 0) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                this.paintHTMLText(g, b, textRect, text, v);
            } else {
                if (state == 8) {
                    g.setColor(ss.getColor(sc, ColorType.TEXT_FOREGROUND));
                } else {
                    g.setColor(b.getForeground());
                }
                ss.getGraphicsUtils(sc).paintText(sc, g, text, textRect, b.getDisplayedMnemonicIndex());
                if (hover) {
                    this.paintUnderline(g, text, textRect);
                }
            }
        }
        if (b.isFocusPainted() && b.hasFocus()) {
            this.paintFocus(g, b, viewRect, textRect, iconRect);
        }
    }

    private void paintUnderline(Graphics g, String text, Rectangle textRect) {
        FontMetrics fm = g.getFontMetrics();
        int x1 = textRect.x + this.getTextShiftOffset();
        int x2 = textRect.x + textRect.width + this.getTextShiftOffset();
        int y = textRect.y + textRect.height - fm.getDescent() + this.getTextShiftOffset() + 1;
        g.drawLine(x1, y, x2, y);
    }

    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        int width = b.getWidth();
        int height = b.getHeight();
        HyperlinkPainter.getInstance().paintHyperlinkFocus(b, new SyntheticaState(), g, 0, 0, width, height);
    }
}

