/*
 * Decompiled with CFR 0.152.
 */
package org.opendatafoundation.data.spss;

import java.io.IOException;
import java.util.List;
import org.opendatafoundation.data.spss.SPSSAbstractRecordType;
import org.opendatafoundation.data.spss.SPSSFile;
import org.opendatafoundation.data.spss.SPSSFileException;

public class SPSSRecordType7Subtype3
extends SPSSAbstractRecordType {
    int recordTypeCode;
    int recordSubtypeCode;
    int dataElementLength;
    int numberOfDataElements;
    int releaseMajor;
    int releaseMinor;
    int releaseSpecial;
    int machineCode;
    int floatRepresentation;
    int compressionScheme;
    int endianness;
    int characterRepresentation;
    List<byte[]> dataElement;

    @Override
    public void read(SPSSFile sPSSFile) throws IOException, SPSSFileException {
        this.fileLocation = sPSSFile.getFilePointer();
        this.recordTypeCode = sPSSFile.readSPSSInt();
        if (this.recordTypeCode != 7) {
            throw new SPSSFileException("Error reading record type 7 subtype 3: bad record type [" + this.recordTypeCode + "]. Expecting Record Type 7.");
        }
        this.recordSubtypeCode = sPSSFile.readSPSSInt();
        if (this.recordSubtypeCode != 3) {
            throw new SPSSFileException("Error reading record type 7 subtype 3: bad subrecord type [" + this.recordSubtypeCode + "]. Expecting Record Subtype 3.");
        }
        this.dataElementLength = sPSSFile.readSPSSInt();
        if (this.dataElementLength != 4) {
            throw new SPSSFileException("Error reading record type 7 subtype 3: bad data element length [" + this.dataElementLength + "]. Expecting 4.");
        }
        this.numberOfDataElements = sPSSFile.readSPSSInt();
        if (this.numberOfDataElements != 8) {
            throw new SPSSFileException("Error reading record type 7 subtype 3: bad number of data elements [" + this.dataElementLength + "]. Expecting 8.");
        }
        this.releaseMajor = sPSSFile.readSPSSInt();
        this.releaseMinor = sPSSFile.readSPSSInt();
        this.releaseSpecial = sPSSFile.readSPSSInt();
        this.machineCode = sPSSFile.readSPSSInt();
        this.floatRepresentation = sPSSFile.readSPSSInt();
        this.compressionScheme = sPSSFile.readSPSSInt();
        this.endianness = sPSSFile.readSPSSInt();
        this.characterRepresentation = sPSSFile.readSPSSInt();
    }

    @Override
    public String toString() {
        String string = "";
        string = string + "\nRECORD TYPE 7 SUBTYPE 3 - RELEASE AND MACHINE SPECIFIC INTEGER INFORMATION";
        string = string + "\nLocation        : " + this.fileLocation;
        string = string + "\nRecord Type     : " + this.recordTypeCode;
        string = string + "\nRecord Subtype  : " + this.recordSubtypeCode;
        string = string + "\nData elements   : " + this.numberOfDataElements;
        string = string + "\nElement length  : " + this.dataElementLength;
        string = string + "\nRelease major   : " + this.releaseMajor;
        string = string + "\nRelease minor   : " + this.releaseMinor;
        string = string + "\nRelease special : " + this.releaseSpecial;
        string = string + "\nMachine code    : " + this.machineCode;
        string = string + "\nFloating point  : " + this.floatRepresentation + " [" + this.getFloatRepresentationLabel() + "]";
        string = string + "\nEndianness      : " + this.endianness + " [" + this.getEndiannessLabel() + "]";
        string = string + "\nCharacter set   : " + this.characterRepresentation + " [" + this.getCharacterRepresentationLabel() + "]";
        return string;
    }

    public String getFloatRepresentationLabel() {
        String string = "Unknown";
        switch (this.floatRepresentation) {
            case 1: {
                string = "IEEE";
                break;
            }
            case 2: {
                string = "IBM 370";
                break;
            }
            case 3: {
                string = "DEX VAX E";
            }
        }
        return string;
    }

    public String getEndiannessLabel() {
        String string = "Unknown";
        switch (this.floatRepresentation) {
            case 1: {
                string = "Big endian";
                break;
            }
            case 2: {
                string = "Little endian";
            }
        }
        return string;
    }

    public String getCharacterRepresentationLabel() {
        String string = "Unknown";
        switch (this.characterRepresentation) {
            case 1: {
                string = "EBCDIC";
                break;
            }
            case 2: {
                string = "7-bit ASCII";
                break;
            }
            case 3: {
                string = "8-bit ASCII";
                break;
            }
            case 4: {
                string = "DEC Kanji";
            }
        }
        return string;
    }
}

