/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.geom;

import com.macrofocus.geom.Curve;
import com.macrofocus.geom.PathIterator;
import java.util.Enumeration;
import java.util.Vector;

public abstract class Crossings {
    public static final boolean debug = false;
    private double c;
    private double d;
    private double e;
    private double f;
    private final Vector<Curve> g = new Vector();
    int a = 0;
    double[] b = new double[10];

    /*
     * WARNING - void declaration
     */
    public Crossings(double xlo, double ylo, double xhi, double yhi) {
        void var3_2;
        void var1_1;
        this.c = var1_1;
        this.d = var3_2;
        this.e = xhi;
        this.f = yhi;
    }

    /*
     * WARNING - void declaration
     */
    public static Crossings findCrossings(Vector<? extends Curve> curves, double xlo, double ylo, double xhi, double yhi) {
        Enumeration<? extends Curve> enumeration;
        void var3_3;
        void var1_1;
        EvenOdd evenOdd = new EvenOdd((double)var1_1, (double)var3_3, xhi, yhi);
        enumeration = ((Vector)((Object)enumeration)).elements();
        while (enumeration.hasMoreElements()) {
            Curve curve = (Curve)enumeration.nextElement();
            if (!curve.accumulateCrossings(evenOdd)) continue;
            return null;
        }
        return evenOdd;
    }

    public void print() {
        System.out.println("Crossings [");
        System.out.println("  bounds = [" + this.d + ", " + this.f + "]");
        for (int i = 0; i < this.a; i += 2) {
            System.out.println("  [" + this.b[i] + ", " + this.b[i + 1] + "]");
        }
        System.out.println("]");
    }

    /*
     * WARNING - void declaration
     */
    public static Crossings findCrossings(PathIterator pi, double xlo, double ylo, double xhi, double yhi) {
        void var3_3;
        void var1_1;
        Crossings crossings = pi.getWindingRule() == 0 ? new EvenOdd(xlo, ylo, xhi, yhi) : new NonZero((double)var1_1, (double)var3_3, xhi, yhi);
        double[] dArray = new double[23];
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        while (!pi.isDone()) {
            int n = pi.currentSegment(dArray);
            switch (n) {
                case 0: {
                    if (d3 != d5 && crossings.accumulateLine(d4, d5, d2, d3)) {
                        return null;
                    }
                    d2 = d4 = dArray[0];
                    d3 = d5 = dArray[1];
                    break;
                }
                case 1: {
                    double d6 = dArray[0];
                    double d7 = dArray[1];
                    if (crossings.accumulateLine(d4, d5, d6, d7)) {
                        return null;
                    }
                    d4 = d6;
                    d5 = d7;
                    break;
                }
                case 2: {
                    double d6 = dArray[2];
                    double d7 = dArray[3];
                    if (crossings.accumulateQuad(d4, d5, dArray)) {
                        return null;
                    }
                    d4 = d6;
                    d5 = d7;
                    break;
                }
                case 3: {
                    double d6 = dArray[4];
                    double d7 = dArray[5];
                    if (crossings.accumulateCubic(d4, d5, dArray)) {
                        return null;
                    }
                    d4 = d6;
                    d5 = d7;
                    break;
                }
                case 4: {
                    if (d3 != d5 && crossings.accumulateLine(d4, d5, d2, d3)) {
                        return null;
                    }
                    d4 = d2;
                    d5 = d3;
                }
            }
            pi.next();
        }
        if (d3 != d5 && crossings.accumulateLine(d4, d5, d2, d3)) {
            return null;
        }
        return crossings;
    }

    /*
     * WARNING - void declaration
     */
    public boolean accumulateLine(double x0, double y0, double x1, double y1) {
        void var3_2;
        void var1_1;
        if (y0 <= y1) {
            return this.accumulateLine(x0, y0, x1, y1, 1);
        }
        return this.accumulateLine(x1, y1, (double)var1_1, (double)var3_2, -1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean accumulateLine(double x0, double y0, double x1, double y1, int direction) {
        double d2;
        double d3;
        double d4;
        double d5;
        if (this.f <= y0 || this.d >= y1) {
            return false;
        }
        if (x0 >= this.e && x1 >= this.e) {
            return false;
        }
        if (y0 == y1) {
            return x0 >= this.c || x1 >= this.c;
        }
        double d6 = x1 - x0;
        double d7 = y1 - y0;
        if (y0 < this.d) {
            d5 = x0 + (this.d - y0) * d6 / d7;
            d4 = this.d;
        } else {
            d5 = x0;
            d4 = y0;
        }
        if (this.f < y1) {
            void var3_3;
            void var1_1;
            d3 = var1_1 + (this.f - var3_3) * d6 / d7;
            d2 = this.f;
        } else {
            d3 = x1;
            d2 = y1;
        }
        if (d5 >= this.e && d3 >= this.e) {
            return false;
        }
        if (d5 > this.c || d3 > this.c) {
            return true;
        }
        this.record(d4, d2, direction);
        return false;
    }

    public abstract void record(double var1, double var3, int var5);

    /*
     * WARNING - void declaration
     */
    public boolean accumulateQuad(double x0, double y0, double[] coords) {
        void var3_3;
        void var1_1;
        if (y0 < this.d && coords[1] < this.d && coords[3] < this.d) {
            return false;
        }
        if (y0 > this.f && coords[1] > this.f && coords[3] > this.f) {
            return false;
        }
        if (x0 > this.e && coords[0] > this.e && coords[2] > this.e) {
            return false;
        }
        if (x0 < this.c && coords[0] < this.c && coords[2] < this.c) {
            if (y0 < coords[3]) {
                this.record(Math.max(y0, this.d), Math.min(coords[3], this.f), 1);
            } else if (y0 > coords[3]) {
                this.record(Math.max(coords[3], this.d), Math.min(y0, this.f), -1);
            }
            return false;
        }
        Curve.insertQuad(this.g, (double)var1_1, (double)var3_3, coords);
        Enumeration<Curve> enumeration = this.g.elements();
        while (enumeration.hasMoreElements()) {
            Curve curve = enumeration.nextElement();
            if (!curve.accumulateCrossings(this)) continue;
            return true;
        }
        this.g.clear();
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean accumulateCubic(double x0, double y0, double[] coords) {
        void var3_3;
        void var1_1;
        if (y0 < this.d && coords[1] < this.d && coords[3] < this.d && coords[5] < this.d) {
            return false;
        }
        if (y0 > this.f && coords[1] > this.f && coords[3] > this.f && coords[5] > this.f) {
            return false;
        }
        if (x0 > this.e && coords[0] > this.e && coords[2] > this.e && coords[4] > this.e) {
            return false;
        }
        if (x0 < this.c && coords[0] < this.c && coords[2] < this.c && coords[4] < this.c) {
            if (y0 <= coords[5]) {
                this.record(Math.max(y0, this.d), Math.min(coords[5], this.f), 1);
            } else {
                this.record(Math.max(coords[5], this.d), Math.min(y0, this.f), -1);
            }
            return false;
        }
        Curve.insertCubic(this.g, (double)var1_1, (double)var3_3, coords);
        Enumeration<Curve> enumeration = this.g.elements();
        while (enumeration.hasMoreElements()) {
            Curve curve = enumeration.nextElement();
            if (!curve.accumulateCrossings(this)) continue;
            return true;
        }
        this.g.clear();
        return false;
    }

    public final double getXLo() {
        return this.c;
    }

    public final double getYLo() {
        return this.d;
    }

    public final double getXHi() {
        return this.e;
    }

    public final double getYHi() {
        return this.f;
    }

    public final boolean isEmpty() {
        return this.a == 0;
    }

    public abstract boolean covers(double var1, double var3);

    public static final class EvenOdd
    extends Crossings {
        /*
         * WARNING - void declaration
         */
        public EvenOdd(double xlo, double ylo, double xhi, double yhi) {
            super((double)var1_1, (double)var3_2, xhi, yhi);
            void var3_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void record(double ystart, double yend, int direction) {
            int n;
            if (ystart >= yend) {
                return;
            }
            for (n = 0; n < this.a && ystart > this.b[n + 1]; n += 2) {
            }
            int n2 = n;
            while (n < this.a) {
                double d2;
                double d3;
                double d4;
                double d5;
                double d6 = this.b[n++];
                double d7 = this.b[n++];
                if (yend < d6) {
                    this.b[n2++] = ystart;
                    this.b[n2++] = yend;
                    ystart = d6;
                    yend = d7;
                    continue;
                }
                if (ystart < d6) {
                    d5 = ystart;
                    d4 = d6;
                } else {
                    d5 = d6;
                    d4 = ystart;
                }
                if (yend < d7) {
                    d3 = yend;
                    d2 = d7;
                } else {
                    d3 = d7;
                    d2 = yend;
                }
                if (d4 == d3) {
                    ystart = d5;
                    yend = d2;
                } else {
                    if (d4 > d3) {
                        ystart = d3;
                        d3 = d4;
                        d4 = ystart;
                    }
                    if (d5 != d4) {
                        this.b[n2++] = d5;
                        this.b[n2++] = d4;
                    }
                    ystart = d3;
                    yend = d2;
                }
                if (!(ystart >= yend)) continue;
            }
            if (n2 < n && n < this.a) {
                System.arraycopy(this.b, n, this.b, n2, this.a - n);
            }
            n2 += this.a - n;
            if (ystart < yend) {
                void var3_2;
                void var1_1;
                if (n2 >= this.b.length) {
                    double[] dArray = new double[n2 + 10];
                    System.arraycopy(this.b, 0, dArray, 0, n2);
                    this.b = dArray;
                }
                this.b[n2++] = var1_1;
                this.b[n2++] = var3_2;
            }
            this.a = n2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean covers(double ystart, double yend) {
            void var3_2;
            void var1_1;
            return this.a == 2 && this.b[0] <= var1_1 && this.b[1] >= var3_2;
        }
    }

    public static final class NonZero
    extends Crossings {
        private int[] c;

        /*
         * WARNING - void declaration
         */
        public NonZero(double xlo, double ylo, double xhi, double yhi) {
            super((double)var1_1, (double)var3_2, xhi, yhi);
            void var3_2;
            void var1_1;
            this.c = new int[this.b.length / 2];
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void record(double ystart, double yend, int direction) {
            int n;
            if (ystart >= yend) {
                return;
            }
            for (n = 0; n < this.a && ystart > this.b[n + 1]; n += 2) {
            }
            if (n < this.a) {
                double d2;
                int n2 = this.c[n / 2];
                double d3 = this.b[n];
                double d4 = this.b[n + 1];
                if (d4 == ystart && n2 == direction) {
                    if (n + 2 == this.a) {
                        this.b[n + 1] = yend;
                        return;
                    }
                    this.remove(n);
                    ystart = d3;
                    n2 = this.c[n / 2];
                    d3 = this.b[n];
                    d4 = this.b[n + 1];
                }
                if (yend < d3) {
                    this.insert(n, ystart, yend, direction);
                    return;
                }
                if (yend == d3 && n2 == direction) {
                    this.b[n] = ystart;
                    return;
                }
                if (ystart < d3) {
                    this.insert(n, ystart, d3, direction);
                    n += 2;
                    ystart = d3;
                } else if (d3 < ystart) {
                    this.insert(n, d3, ystart, n2);
                    n += 2;
                }
                int n3 = n2 + direction;
                double d5 = Math.min(yend, d4);
                if (n3 == 0) {
                    this.remove(n);
                } else {
                    this.c[n / 2] = n3;
                    this.b[n++] = ystart;
                    this.b[n++] = d5;
                }
                ystart = d2 = d5;
                if (d2 < d4) {
                    this.insert(n, d2, d4, n2);
                }
            }
            if (ystart < yend) {
                void var3_2;
                void var1_1;
                this.insert(n, (double)var1_1, (double)var3_2, direction);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean covers(double ystart, double yend) {
            void var3_2;
            void var1_1;
            int n = 0;
            while (n < this.a) {
                double d2;
                double d3 = this.b[n++];
                if (ystart >= (d2 = this.b[n++])) continue;
                if (ystart < d3) {
                    return false;
                }
                if (yend <= d2) {
                    return true;
                }
                ystart = d2;
            }
            return var1_1 >= var3_2;
        }

        /*
         * WARNING - void declaration
         */
        public final void remove(int cur) {
            this.a -= 2;
            int n = this.a - cur;
            if (n > 0) {
                void var1_1;
                System.arraycopy(this.b, cur + 2, this.b, cur, n);
                System.arraycopy(this.c, cur / 2 + 1, this.c, (int)(var1_1 / 2), n / 2);
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void insert(int cur, double lo, double hi, int dir) {
            void var2_2;
            int n = this.a - cur;
            double[] dArray = this.b;
            int[] nArray = this.c;
            if (this.a >= this.b.length) {
                this.b = new double[this.a + 10];
                System.arraycopy(dArray, 0, this.b, 0, cur);
                this.c = new int[(this.a + 10) / 2];
                System.arraycopy(nArray, 0, this.c, 0, cur / 2);
            }
            if (n > 0) {
                System.arraycopy(dArray, cur, this.b, cur + 2, n);
                System.arraycopy(nArray, cur / 2, this.c, cur / 2 + 1, n / 2);
            }
            this.b[cur] = var2_2;
            this.b[cur + 1] = hi;
            this.c[var1_1 / 2] = dir;
            this.a += 2;
        }
    }
}

