/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.geom.curve;

import com.macrofocus.geom.curve.ControlPath;
import com.macrofocus.geom.curve.GroupIterator;
import com.macrofocus.geom.curve.MultiPath;
import com.macrofocus.geom.curve.b;
import com.macrofocus.geom.curve.c;
import com.macrofocus.geom.curve.d;

public class BezierCurve
extends c {
    private static double[] d = new double[0];
    private double e;
    private double f = 1.0;
    private int g = 1;

    /*
     * WARNING - void declaration
     */
    public BezierCurve(ControlPath cp, GroupIterator gi) {
        super((ControlPath)var1_1, (GroupIterator)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setInterval(double t_min, double t_max) {
        void var3_2;
        void var1_1;
        assert (t_min <= t_max) : "t_min <= t_max required.";
        this.e = var1_1;
        this.f = var3_2;
    }

    public double t_min() {
        return this.e;
    }

    public double t_max() {
        return this.f;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void appendTo(MultiPath mp) {
        void var1_1;
        if (!this.b.isInRange(0, this.a.numPoints())) {
            return;
        }
        int n = mp.getDimension();
        double[] dArray = new double[n + 1];
        double[] dArray2 = dArray;
        dArray[n] = this.e;
        this.eval(dArray2);
        if (this.c) {
            mp.lineTo(dArray2);
        } else {
            mp.moveTo(dArray2);
        }
        BezierCurve bezierCurve = this;
        com.macrofocus.geom.curve.b.a(bezierCurve, bezierCurve.e, this.f, (MultiPath)var1_1);
    }

    @Override
    protected void eval(double[] p) {
        int n;
        double d2 = p[p.length - 1];
        int n2 = this.b.getGroupSize();
        if (n2 > d.length) {
            d = new double[2 * n2];
        }
        BezierCurve.d[n2 - 1] = 1.0;
        double d3 = 1.0 - d2;
        for (n = n2 - 2; n >= 0; --n) {
            d[n] = d[n + 1] * d3;
        }
        this.b.set(0, 0);
        double d4 = 1.0;
        for (n = 0; n < n2; ++n) {
            double d5 = com.macrofocus.geom.curve.d.a(n2 - 1, n);
            if (!Double.isInfinite(d5) && !Double.isNaN(d5)) {
                double d6 = d[n] * d4 * d5;
                double[] dArray = this.a.getPoint(this.b.next()).getLocation();
                for (int i = 0; i < p.length - 1; ++i) {
                    int n3 = i;
                    p[n3] = p[n3] + dArray[i] * d6;
                }
            }
            d4 *= d2;
        }
    }

    @Override
    public int getSampleLimit() {
        return this.g;
    }

    /*
     * WARNING - void declaration
     */
    public void setSampleLimit(int limit) {
        void var1_1;
        assert (limit >= 0) : "Sample-limit >= 0 required.";
        this.g = var1_1;
    }

    @Override
    public void resetMemory() {
        if (d.length > 0) {
            d = new double[0];
        }
    }
}

