/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.cartogram;

import com.macrofocus.cartogram.Engine;
import com.macrofocus.cartogram.InputLayerModel;
import com.macrofocus.color.ColormapModel;
import com.macrofocus.colormap.ColorMap;
import com.macrofocus.common.selection.MutableSelection;
import com.macrofocus.common.selection.MutableSingleSelection;
import com.macrofocus.data.table.Column;
import com.macrofocus.data.table.Row;
import com.macrofocus.filter.MutableFilter;
import com.macrofocus.geo.model.GeoListener;
import com.macrofocus.geo.model.GeoModel;
import com.macrofocus.util.range.MBoundedRangeModel;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.util.LinkedList;
import javax.swing.table.TableModel;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;

public class OutputLayerModel
implements GeoModel {
    private final LinkedList<Geometry> polygons;
    private Rectangle2D.Double bounds;
    private GeoModel layer;
    private InputLayerModel inputMap;

    public OutputLayerModel(GeoModel layer, InputLayerModel inputMap, Engine engine) {
        this.layer = layer;
        this.polygons = new LinkedList();
        this.bounds = null;
        CoordinateFilter filter = engine.transf();
        for (int row = 0; row < inputMap.getRowCount(); ++row) {
            Geometry po = layer.getGeometry(row);
            if (po != null) {
                Geometry copy = (Geometry)po.clone();
                copy.apply(filter);
                copy.geometryChanged();
                if (copy instanceof Polygon) {
                    this.addPolygon((Polygon)copy);
                    continue;
                }
                this.addPolygon((MultiPolygon)copy);
                continue;
            }
            this.addPolygon((Polygon)null);
        }
        this.updateBounds();
    }

    public String getName() {
        return "Output";
    }

    public InputLayerModel getInputMap() {
        return this.inputMap;
    }

    public void addPolygon(Polygon polygon) {
        if (polygon != null) {
            Envelope e = polygon.getEnvelopeInternal();
            if (this.bounds != null) {
                this.bounds.add(e.getMinX(), e.getMinY());
                this.bounds.add(e.getMaxX(), e.getMaxY());
            } else {
                this.bounds = new Rectangle2D.Double(e.getMinX(), e.getMinY(), e.getWidth(), e.getHeight());
            }
        }
        this.polygons.add((Geometry)polygon);
    }

    public void addPolygon(MultiPolygon polygon) {
        if (polygon != null) {
            Envelope e = polygon.getEnvelopeInternal();
            if (this.bounds != null) {
                this.bounds.add(e.getMinX(), e.getMinY());
                this.bounds.add(e.getMaxX(), e.getMaxY());
            } else {
                this.bounds = new Rectangle2D.Double(e.getMinX(), e.getMinY(), e.getWidth(), e.getHeight());
            }
        }
        this.polygons.add((Geometry)polygon);
    }

    public Image getImage(int row) {
        return null;
    }

    public MutableSingleSelection<Column> getImageColumn() {
        return null;
    }

    private void updateBounds() {
        this.bounds = null;
        for (int r = 0; r < this.getRowCount(); ++r) {
            Geometry g = this.getGeometry(r);
            if (g == null) continue;
            Envelope e = g.getEnvelopeInternal();
            if (this.bounds != null) {
                this.bounds.add(e.getMinX(), e.getMinY());
                this.bounds.add(e.getMaxX(), e.getMaxY());
                continue;
            }
            this.bounds = new Rectangle2D.Double(e.getMinX(), e.getMinY(), e.getWidth(), e.getHeight());
        }
    }

    public Rectangle2D.Double getBounds() {
        return this.bounds;
    }

    public Geometry getGeometry(int index) {
        return this.polygons.get(index);
    }

    public int getGeometryCount() {
        return this.polygons.size();
    }

    public TableModel getTableModel() {
        return this.layer.getTableModel();
    }

    public void setGeometryColumn(int geometryColumn) {
    }

    public int getColumnCount() {
        return this.layer.getColumnCount();
    }

    public int getRowCount() {
        return this.layer.getRowCount();
    }

    public Row getRow(int row) {
        return this.layer.getRow(row);
    }

    public Column findColumn(String name) {
        throw new UnsupportedOperationException();
    }

    public Column getColumn(int column) {
        return this.layer.getColumn(column);
    }

    public MutableSingleSelection<Column> getColorColumn() {
        return this.layer.getColorColumn();
    }

    public MutableSingleSelection<Column> getSizeColumn() {
        return this.layer.getColorColumn();
    }

    public MutableSingleSelection<Column> getLabelColumn() {
        return null;
    }

    public MBoundedRangeModel getColorRangeModel(Column column) {
        return this.layer.getColorRangeModel(column);
    }

    public ColorMap getColormap(Column column) {
        return null;
    }

    public void setColormap(Column column, ColorMap colormap) {
    }

    public MutableSingleSelection<ColormapModel> getColormap() {
        return this.layer.getColormap();
    }

    public MutableSingleSelection<Row> getProbing() {
        return this.layer.getProbing();
    }

    public MutableSelection<Row> getSelection() {
        return this.layer.getSelection();
    }

    public MutableFilter<Row> getFilter() {
        return this.layer.getFilter();
    }

    public void apply(int column, CoordinateFilter coordinateFilter) {
        for (int row = 0; row < this.getRowCount(); ++row) {
            ((Geometry)this.getTableModel().getValueAt(row, column)).apply(coordinateFilter);
        }
        this.updateBounds();
    }

    public void apply(CoordinateFilter coordinateFilter) {
        for (int row = 0; row < this.getRowCount(); ++row) {
            this.getGeometry(row).apply(coordinateFilter);
        }
        this.updateBounds();
    }

    public void addListener(GeoListener treeMapListener) {
    }

    public void removeListener(GeoListener treeMapListener) {
    }
}

