/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.crossplatform.swing;

import com.macrofocus.common.command.Command;
import com.macrofocus.common.interval.MutableBoundedInterval;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.Property;
import com.macrofocus.common.selection.MutableSelection;
import com.macrofocus.common.selection.MutableSingleSelection;
import com.macrofocus.crossplatform.AbsoluteCPContainer;
import com.macrofocus.crossplatform.AbstractCPFactory;
import com.macrofocus.crossplatform.CPBorderPanel;
import com.macrofocus.crossplatform.CPButton;
import com.macrofocus.crossplatform.CPCheckBox;
import com.macrofocus.crossplatform.CPCheckBoxList;
import com.macrofocus.crossplatform.CPCollapsibleHeader;
import com.macrofocus.crossplatform.CPColorButton;
import com.macrofocus.crossplatform.CPColorPicker;
import com.macrofocus.crossplatform.CPComboBox;
import com.macrofocus.crossplatform.CPComponent;
import com.macrofocus.crossplatform.CPExpandablePanel;
import com.macrofocus.crossplatform.CPFillMiddlePanel;
import com.macrofocus.crossplatform.CPFontPicker;
import com.macrofocus.crossplatform.CPFormPanel;
import com.macrofocus.crossplatform.CPGridPanel;
import com.macrofocus.crossplatform.CPHeader;
import com.macrofocus.crossplatform.CPHeaderPanel;
import com.macrofocus.crossplatform.CPHorizontalFlowPanel;
import com.macrofocus.crossplatform.CPHorizontalPanel;
import com.macrofocus.crossplatform.CPLabel;
import com.macrofocus.crossplatform.CPMenuButton;
import com.macrofocus.crossplatform.CPOverlayPanel;
import com.macrofocus.crossplatform.CPPopupMenu;
import com.macrofocus.crossplatform.CPRadioButton;
import com.macrofocus.crossplatform.CPRadioButtons;
import com.macrofocus.crossplatform.CPRectangle;
import com.macrofocus.crossplatform.CPSlider;
import com.macrofocus.crossplatform.CPSpinner;
import com.macrofocus.crossplatform.CPSplitMenuButton;
import com.macrofocus.crossplatform.CPSplitPanel;
import com.macrofocus.crossplatform.CPSwitch;
import com.macrofocus.crossplatform.CPTabPanel;
import com.macrofocus.crossplatform.CPTree;
import com.macrofocus.crossplatform.CPTreeModel;
import com.macrofocus.crossplatform.CPVerticalFillMiddlePanel;
import com.macrofocus.crossplatform.CPVerticalFlowPanel;
import com.macrofocus.crossplatform.CPVerticalPanel;
import com.macrofocus.crossplatform.Layout;
import com.macrofocus.crossplatform.swing.AbstractSwingComponent;
import com.macrofocus.crossplatform.swing.SwingAbsoluteContainer;
import com.macrofocus.crossplatform.swing.SwingButton;
import com.macrofocus.crossplatform.swing.SwingCanvas;
import com.macrofocus.crossplatform.swing.SwingCheckBox;
import com.macrofocus.crossplatform.swing.SwingCheckBoxList;
import com.macrofocus.crossplatform.swing.SwingCollapsibleHeader;
import com.macrofocus.crossplatform.swing.SwingColorButton;
import com.macrofocus.crossplatform.swing.SwingColorPicker;
import com.macrofocus.crossplatform.swing.SwingComboBox;
import com.macrofocus.crossplatform.swing.SwingExpandablePanel;
import com.macrofocus.crossplatform.swing.SwingFillMiddlePanel;
import com.macrofocus.crossplatform.swing.SwingFontPicker;
import com.macrofocus.crossplatform.swing.SwingFormPanel;
import com.macrofocus.crossplatform.swing.SwingGridPanel;
import com.macrofocus.crossplatform.swing.SwingHeader;
import com.macrofocus.crossplatform.swing.SwingHeaderPanel;
import com.macrofocus.crossplatform.swing.SwingHoritzonalSplitPanel;
import com.macrofocus.crossplatform.swing.SwingHorizontalFlowPanel;
import com.macrofocus.crossplatform.swing.SwingHorizontalPanel;
import com.macrofocus.crossplatform.swing.SwingLabel;
import com.macrofocus.crossplatform.swing.SwingMenuButton;
import com.macrofocus.crossplatform.swing.SwingOverlayPanel;
import com.macrofocus.crossplatform.swing.SwingPopupMenu;
import com.macrofocus.crossplatform.swing.SwingRectangle;
import com.macrofocus.crossplatform.swing.SwingSlider;
import com.macrofocus.crossplatform.swing.SwingSpinner;
import com.macrofocus.crossplatform.swing.SwingSplitMenuButton;
import com.macrofocus.crossplatform.swing.SwingSwitch;
import com.macrofocus.crossplatform.swing.SwingTabPanel;
import com.macrofocus.crossplatform.swing.SwingTimer;
import com.macrofocus.crossplatform.swing.SwingTree;
import com.macrofocus.crossplatform.swing.SwingVerticalFillMiddlePanel;
import com.macrofocus.crossplatform.swing.SwingVerticalFlowPanel;
import com.macrofocus.crossplatform.swing.SwingVerticalPanel;
import com.macrofocus.crossplatform.swing.SwingVerticalSplitPanel;
import com.macrofocus.format.FormatFactory;
import com.macrofocus.format.swing.SwingFormatFactory;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.igraphics.CPFont;
import com.macrofocus.igraphics.CPIcon;
import com.macrofocus.igraphics.swing.SwingColor;
import com.macrofocus.igraphics.swing.SwingFont;
import com.macrofocus.timer.CPTimer;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;

public class SwingFactory
extends AbstractCPFactory<JComponent, Font, Rectangle, Color> {
    private static SwingFactory ourInstance = new SwingFactory();

    public static SwingFactory getInstance() {
        return ourInstance;
    }

    protected SwingFactory() {
    }

    public <C extends JComponent> CPOverlayPanel<JComponent, C> createOverlayPanel(CPComponent<C> component) {
        return new SwingOverlayPanel<C>(component);
    }

    public <C extends JComponent> CPOverlayPanel<JComponent, C> createOverlayPanel() {
        return new SwingOverlayPanel();
    }

    public AbsoluteCPContainer<JComponent, Rectangle> createAbsoluteContainer(Layout layout) {
        return new SwingAbsoluteContainer();
    }

    public CPFillMiddlePanel<JComponent> createFillMiddlePanel() {
        return new SwingFillMiddlePanel();
    }

    public CPVerticalFillMiddlePanel<JComponent> createVerticalFillMiddlePanel() {
        return new SwingVerticalFillMiddlePanel();
    }

    public CPHorizontalPanel<JComponent> createHorizontalPanel() {
        return new SwingHorizontalPanel();
    }

    public CPVerticalPanel<JComponent> createVerticalPanel() {
        return new SwingVerticalPanel();
    }

    public CPHorizontalFlowPanel<JComponent> createHorizontalFlowPanel(CPComponent<JComponent> ... components) {
        return new SwingHorizontalFlowPanel(components);
    }

    public CPVerticalFlowPanel<JComponent> createVerticalFlowPanel(CPComponent<JComponent> ... components) {
        return new SwingVerticalFlowPanel(components);
    }

    public CPHeaderPanel<JComponent> createHeaderPanel() {
        return new SwingHeaderPanel();
    }

    public CPBorderPanel<JComponent> createBorderPanel() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public CPFormPanel<JComponent> createFormPanel() {
        return new SwingFormPanel();
    }

    public CPGridPanel<JComponent> createGridPanel(int rows, int columns, CPComponent<JComponent>[] components) {
        return new SwingGridPanel(rows, columns, components);
    }

    public CPExpandablePanel<JComponent> createExpandablePanel(CPComponent<JComponent> header, CPComponent<JComponent> content) {
        return new SwingExpandablePanel(header, content);
    }

    public CPSplitPanel<JComponent> createHorizontalSplitPanel() {
        return new SwingHoritzonalSplitPanel();
    }

    public CPSplitPanel<JComponent> createVerticalSplitPanel() {
        return new SwingVerticalSplitPanel();
    }

    public CPTabPanel<JComponent> createTabPanel() {
        return new SwingTabPanel();
    }

    public <C extends JComponent> CPComponent<C> createComponent(final C c) {
        return new AbstractSwingComponent<C>(){

            public C getNativeComponent() {
                return c;
            }
        };
    }

    public CPLabel<JComponent, Font> createLabel(String text) {
        return new SwingLabel(text);
    }

    public CPHeader<JComponent> createHeader(String text) {
        return new SwingHeader(text);
    }

    public CPCollapsibleHeader<JComponent> createCollapsibleHeader(String text, MutableProperty<Boolean> collapsedProperty) {
        return new SwingCollapsibleHeader(text, collapsedProperty);
    }

    public CPButton<JComponent> createButton(String text) {
        return new SwingButton(text);
    }

    public CPButton<JComponent> createButton(Property<String> text) {
        return new SwingButton(text);
    }

    public CPMenuButton<JComponent> createMenuButton() {
        return new SwingMenuButton();
    }

    public CPSplitMenuButton<JComponent> createSplitMenuButton() {
        return new SwingSplitMenuButton();
    }

    public CPColorButton<JComponent, Color> createColorButton(CPColor<Color> color, Command command) {
        return new SwingColorButton(color, command);
    }

    public <E> CPComboBox<JComponent, E> createComboBox() {
        return new SwingComboBox();
    }

    public <E> CPComboBox<JComponent, E> createComboBox(MutableSingleSelection<E> selection, Iterable<E> values) {
        return new SwingComboBox<E>(selection, values);
    }

    public <E> CPRadioButtons<JComponent, E> createRadioButtons(Iterable<E> values) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public <E> CPRadioButtons<JComponent, E> createRadioButtons(MutableSingleSelection<E> selection, Iterable<E> values) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public <E> CPCheckBoxList<JComponent, E> createCheckBoxList(MutableSingleSelection<E> selection, MutableSelection<E> checks, Iterable<E> values) {
        return new SwingCheckBoxList<E>(selection, values);
    }

    public CPCheckBox<JComponent> createCheckBox(String label, MutableProperty<Boolean> on) {
        return new SwingCheckBox(label, on);
    }

    public CPCheckBox<JComponent> createCheckBox(MutableProperty<Boolean> on) {
        return new SwingCheckBox(on);
    }

    public CPRadioButton<JComponent> createRadioButton(MutableProperty<Boolean> on) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public CPSwitch<JComponent> createSwitch() {
        return new SwingSwitch();
    }

    public CPSwitch<JComponent> createSwitch(MutableProperty<Boolean> on) {
        return new SwingSwitch(on);
    }

    public CPSpinner<JComponent, Integer> createIntegerSpinner() {
        return new SwingSpinner<Integer>();
    }

    public CPSpinner<JComponent, Integer> createIntegerSpinner(MutableProperty<Integer> value) {
        return new SwingSpinner<Integer>(value);
    }

    public CPSpinner<JComponent, Double> createDoubleSpinner() {
        return new SwingSpinner<Double>();
    }

    public CPSpinner<JComponent, Double> createDoubleSpinner(MutableProperty<Double> value) {
        return new SwingSpinner<Double>(value);
    }

    public CPSpinner<JComponent, Double> createDoubleSpinner(MutableBoundedInterval interval) {
        return new SwingSpinner<Double>(interval);
    }

    public CPSlider<JComponent> createSlider() {
        return new SwingSlider();
    }

    public CPSlider<JComponent> createSlider(MutableBoundedInterval interval) {
        return new SwingSlider(interval);
    }

    public CPColorPicker<JComponent, Color> createColorPicker() {
        return new SwingColorPicker();
    }

    public CPColorPicker<JComponent, Color> createColorPicker(MutableProperty<CPColor<Color>> color) {
        return new SwingColorPicker(color);
    }

    public CPFontPicker<JComponent, Font> createFontPicker() {
        return new SwingFontPicker();
    }

    public CPFontPicker<JComponent, Font> createFontPicker(MutableProperty<CPFont<Font>> font) {
        return new SwingFontPicker(font);
    }

    public SwingCanvas createCanvas() {
        return new SwingCanvas();
    }

    public <Node> CPTree<JComponent, Color, Node> createTree(CPTreeModel<Node> model) {
        return new SwingTree<Node>(model);
    }

    public CPPopupMenu<JComponent> createPopupMenu() {
        return new SwingPopupMenu();
    }

    public CPFont<Font> createFont(String family, int style, int size) {
        Font font = Font.decode(family);
        if (font != null) {
            return new SwingFont(font.deriveFont(style, size));
        }
        return null;
    }

    public CPFont<Font> createFontFamily(String family) {
        Font font = Font.decode(family);
        return new SwingFont(font);
    }

    public CPFont<Font> decodeFont(String font) {
        Font f = Font.decode(font);
        if (f != null) {
            return new SwingFont(f);
        }
        return null;
    }

    public CPFont<Font> createDefaultFont() {
        Font font = UIManager.getDefaults().getFont("Label.font");
        if (font == null) {
            font = new JLabel().getFont();
        }
        return new SwingFont(font);
    }

    public CPRectangle<Rectangle> createRectangle(int x, int y, int width, int height) {
        return new SwingRectangle(x, y, width, height);
    }

    public CPColor<Color> createRGBAColor(int r, int g, int b, int a) {
        return new SwingColor(r, g, b, a);
    }

    public CPColor<Color> createColor(int rgba) {
        return new SwingColor(rgba);
    }

    public CPColor<Color> createNativeColor(Object color) {
        if (color instanceof Color) {
            return new SwingColor((Color)color);
        }
        return null;
    }

    public ExecutorService newFixedThreadPool(final String name, int corePoolSize, int maximumPoolSize) {
        return new ThreadPoolExecutor(corePoolSize, maximumPoolSize, 20L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){
            final ThreadGroup group = System.getSecurityManager() != null ? System.getSecurityManager().getThreadGroup() : Thread.currentThread().getThreadGroup();

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(this.group, r, name, 0L);
                if (t.isDaemon()) {
                    t.setDaemon(false);
                }
                if (t.getPriority() != 5) {
                    t.setPriority(5);
                }
                return t;
            }
        });
    }

    public CPTimer createTimer(String name, int delay, boolean postponing) {
        return new SwingTimer(name, delay, 10000, postponing);
    }

    public void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public boolean isAssignableFrom(Class a, Class b) {
        return a.isAssignableFrom(b);
    }

    public boolean isNumericType(Class type) {
        return type != null && (this.isAssignableFrom(Number.class, type) || type == Double.TYPE || type == Integer.TYPE || type == Float.TYPE || type == Short.TYPE || type == Long.TYPE);
    }

    public boolean isTemporalType(Class type) {
        return type != null && (this.isAssignableFrom(Date.class, type) || this.isAssignableFrom(Calendar.class, type) || type == Double.TYPE || type == Long.TYPE);
    }

    public boolean isVisualType(Class type) {
        return type != null && (this.isAssignableFrom(CPColor.class, type) || this.isAssignableFrom(CPIcon.class, type) || this.isAssignableFrom(Image.class, type));
    }

    public FormatFactory getFormatFactory() {
        return SwingFormatFactory.getInstance();
    }

    public Class getNativeColorClass() {
        return Color.class;
    }
}

