/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.button;

import com.macrofocus.button.AbstractButton;
import com.macrofocus.button.ButtonModel;
import com.macrofocus.button.DualImageButtonView;
import com.macrofocus.button.GroupButtonController;
import com.macrofocus.button.SimpleButtonController;
import com.macrofocus.button.SimpleButtonModel;
import com.macrofocus.button.SwitchingButtonController;
import java.awt.Image;

public final class DualImageButton
extends AbstractButton {
    public static final int MODE_PAINT_RED = 1;
    public static final int MODE_PAINT_GREEN = 2;
    public static final int MODE_PAINT_BLUE = 3;
    public static final int MODE_RED_FRAME = 4;
    public static final int MODE_HIGHLIGHT = 5;
    public static final int MODE_GREY_OUT = 6;
    public static final int MODE_UNCHANGED = 7;
    final boolean isSwitching;
    final boolean isGrouped;
    final Image buttonOnImage;
    final Image buttonOffImage;
    final int focusOnMode;
    final int focusOffMode;
    final int disabledOnMode;
    final int disabledOffMode;

    public DualImageButton(Image buttonOnImage, Image buttonOffImage) {
        this(false, false, buttonOnImage, buttonOffImage, 5, 5, 6, 6);
    }

    public DualImageButton(boolean isSwitching, Image buttonOnImage, Image buttonOffImage) {
        this(isSwitching, false, buttonOnImage, buttonOffImage, 5, 5, 6, 6);
    }

    public DualImageButton(boolean isSwitching, boolean isGrouped, Image buttonOnImage, Image buttonOffImage) {
        this(isSwitching, isGrouped, buttonOnImage, buttonOffImage, 5, 5, 6, 6);
    }

    public DualImageButton(boolean isSwitching, Image buttonOnImage, Image buttonOffImage, int focusOnMode, int focusOffMode, int disabledOnMode, int disabledOffMode) {
        this(isSwitching, false, buttonOnImage, buttonOffImage, focusOnMode, focusOffMode, disabledOnMode, disabledOffMode);
    }

    public DualImageButton(boolean isSwitching, boolean isGrouped, Image buttonOnImage, Image buttonOffImage, int focusOnMode, int focusOffMode, int disabledOnMode, int disabledOffMode) {
        this(new SimpleButtonModel(), isSwitching, isGrouped, buttonOnImage, buttonOffImage, focusOnMode, focusOffMode, disabledOnMode, disabledOffMode);
    }

    public DualImageButton(ButtonModel buttonModel, boolean isSwitching, boolean isGrouped, Image buttonOnImage, Image buttonOffImage, int focusOnMode, int focusOffMode, int disabledOnMode, int disabledOffMode) {
        this.isSwitching = isSwitching;
        this.isGrouped = isGrouped;
        this.buttonOnImage = buttonOnImage;
        this.buttonOffImage = buttonOffImage;
        this.focusOnMode = focusOnMode;
        this.focusOffMode = focusOffMode;
        this.disabledOnMode = disabledOnMode;
        this.disabledOffMode = disabledOffMode;
        this.create(buttonModel);
    }

    private void create(ButtonModel buttonModel) {
        this.setButtonModel(buttonModel);
        this.setButtonView(new DualImageButtonView(this.getButtonModel(), this.buttonOnImage, this.buttonOffImage, this.focusOnMode, this.focusOffMode, this.disabledOnMode, this.disabledOffMode));
        if (this.isSwitching) {
            if (this.isGrouped) {
                this.setButtonController(new GroupButtonController(this.getButtonView(), this.getButtonModel()));
            } else {
                this.setButtonController(new SwitchingButtonController(this.getButtonView(), this.getButtonModel()));
            }
        } else {
            this.setButtonController(new SimpleButtonController(this.getButtonView(), this.getButtonModel()));
        }
    }

    protected Object clone() {
        return new DualImageButton(this.getButtonModel(), this.isSwitching, this.isGrouped, this.buttonOnImage, this.buttonOffImage, this.focusOnMode, this.focusOffMode, this.disabledOnMode, this.disabledOffMode);
    }
}

