/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.combobox;

import com.jidesoft.combobox.ColorComboBox;
import com.macrofocus.combobox.MAbstractComboBox;
import com.macrofocus.combobox.MJYComboBox;
import com.macrofocus.helper.WeakActionListeners;
import de.javasoft.combobox.JYComboBox;
import de.javasoft.combobox.controls.ColorComboBoxRenderer;
import de.javasoft.combobox.controls.ColorPopupPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.OverlayLayout;

public class MColorComboBox
extends JPanel
implements MAbstractComboBox {
    private ColorComboBox jideComboBox;
    private JComboBox swingComboBox;
    private MJYComboBox jyComboBox;
    private final WeakActionListeners actionListeners = new WeakActionListeners();

    public MColorComboBox() {
        this.setLayout(new OverlayLayout(this));
        this.jyComboBox = new MJYComboBox();
        this.jyComboBox.setEditable(false);
        ColorPopupPanel colorPopup = new ColorPopupPanel((JYComboBox)this.jyComboBox);
        colorPopup.setNonColorButtonVisible(false);
        colorPopup.setOtherColorButtonVisible(true);
        this.jyComboBox.setPopupComponent((JComponent)colorPopup);
        ColorComboBoxRenderer renderer = new ColorComboBoxRenderer(this.jyComboBox.getRenderer(), false, true){

            public Component getListCellRendererComponent(JList<? extends Color> list, Color value, int index, boolean isSelected, boolean cellHasFocus) {
                Color color;
                Component component = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value != null && value instanceof Color && this.isAlphaValueIncluded() && component instanceof JLabel && (color = value).getAlpha() == 255) {
                    JLabel label = (JLabel)component;
                    label.setText(MColorComboBox.colorAsText(color, false, false));
                }
                if (MColorComboBox.this.jyComboBox.isEnabled()) {
                    ((JComponent)component).setOpaque(true);
                    component.setBackground(Color.white);
                } else {
                    ((JComponent)component).setOpaque(false);
                    component.setBackground(Color.white);
                }
                return component;
            }
        };
        this.jyComboBox.setRenderer((ListCellRenderer)renderer);
        if (this.jyComboBox != null) {
            this.add((Component)((Object)this.jyComboBox));
        } else if (this.jideComboBox != null) {
            this.add((Component)this.jideComboBox);
        } else {
            this.add(this.swingComboBox);
        }
    }

    static String colorAsText(Color color, boolean hexadecimal, boolean includeAlphaValue) {
        String delimiter = ",";
        Object s = null;
        if (hexadecimal) {
            s = includeAlphaValue ? Integer.toHexString(color.getRGB()).toUpperCase() : Integer.toHexString(color.getRGB()).substring(2).toUpperCase();
        } else {
            s = color.getRed() + delimiter + " " + color.getGreen() + delimiter + " " + color.getBlue();
            if (includeAlphaValue) {
                s = (String)s + delimiter + " " + color.getAlpha();
            }
        }
        return s;
    }

    public void setRenderer(ListCellRenderer listCellRenderer) {
        if (this.jyComboBox != null) {
            this.jyComboBox.setRenderer(listCellRenderer);
        } else if (this.jideComboBox != null) {
            this.jideComboBox.setRenderer(listCellRenderer);
        } else {
            this.swingComboBox.setRenderer(listCellRenderer);
        }
    }

    public void setStretchToFit(boolean b) {
        if (this.jyComboBox == null && this.jideComboBox != null) {
            this.jideComboBox.setStretchToFit(b);
        }
    }

    public void setEditable(boolean b) {
        if (this.jyComboBox == null) {
            if (this.jideComboBox != null) {
                this.jideComboBox.setEditable(b);
            } else {
                this.swingComboBox.setEditable(b);
            }
        }
    }

    @Override
    public void addItemListener(ItemListener listener) {
        if (this.jyComboBox != null) {
            this.jyComboBox.addItemListener(listener);
        } else if (this.jideComboBox != null) {
            this.jideComboBox.addItemListener(listener);
        } else {
            this.swingComboBox.addItemListener(listener);
        }
    }

    @Override
    public void removeItemListener(ItemListener listener) {
        if (this.jyComboBox != null) {
            this.jyComboBox.removeItemListener(listener);
        } else if (this.jideComboBox != null) {
            this.jideComboBox.removeItemListener(listener);
        } else {
            this.swingComboBox.removeItemListener(listener);
        }
    }

    @Override
    public Object getSelectedItem() {
        if (this.jyComboBox != null) {
            return this.jyComboBox.getSelectedItem();
        }
        if (this.jideComboBox != null) {
            return this.jideComboBox.getSelectedItem();
        }
        return this.swingComboBox.getSelectedItem();
    }

    public Color getSelectedColor() {
        if (this.jyComboBox != null) {
            return (Color)this.jyComboBox.getSelectedItem();
        }
        if (this.jideComboBox != null) {
            return this.jideComboBox.getSelectedColor();
        }
        return (Color)this.swingComboBox.getSelectedItem();
    }

    @Override
    public void setModel(ComboBoxModel comboBoxModel) {
        if (this.jyComboBox != null) {
            this.jyComboBox.setModel(comboBoxModel);
        } else if (this.jideComboBox != null) {
            this.jideComboBox.setModel(comboBoxModel);
        } else {
            this.swingComboBox.setModel(comboBoxModel);
        }
    }

    @Override
    public ComboBoxModel getModel() {
        if (this.jyComboBox != null) {
            return this.jyComboBox.getModel();
        }
        if (this.jideComboBox != null) {
            return this.jideComboBox.getModel();
        }
        return this.swingComboBox.getModel();
    }

    @Override
    public void setSelectedItem(Object item) {
        if (this.jyComboBox != null) {
            this.jyComboBox.setSelectedItem(item);
        } else if (this.jideComboBox != null) {
            this.jideComboBox.setSelectedItem(item);
        } else {
            this.swingComboBox.setSelectedItem(item);
        }
    }

    public void setSelectedColor(Color item) {
        if (this.jyComboBox != null) {
            if (this.jyComboBox.getSelectedItem() != item) {
                boolean isEditable = this.jyComboBox.isEditable();
                this.jyComboBox.setEditable(true);
                this.jyComboBox.setSelectedItem(item);
                this.jyComboBox.setEditable(isEditable);
            }
        } else if (this.jideComboBox != null) {
            if (this.jideComboBox.getSelectedColor() != item) {
                this.jideComboBox.setSelectedColor(item);
            }
        } else {
            this.swingComboBox.setSelectedItem(item);
        }
    }

    @Override
    public void addActionListener(ActionListener listener) {
        if (this.jyComboBox != null) {
            this.jyComboBox.addActionListener(this.actionListeners.create(listener, (Object)this.jyComboBox));
        } else if (this.jideComboBox != null) {
            this.jideComboBox.addActionListener(this.actionListeners.create(listener, (Object)this.jideComboBox));
        } else {
            this.swingComboBox.addActionListener(this.actionListeners.create(listener, (Object)this.swingComboBox));
        }
    }

    @Override
    public void removeActionListener(ActionListener listener) {
        if (this.jyComboBox != null) {
            this.jyComboBox.removeActionListener(this.actionListeners.remove(listener));
        } else if (this.jideComboBox != null) {
            this.jideComboBox.removeActionListener(this.actionListeners.remove(listener));
        } else {
            this.swingComboBox.removeActionListener(this.actionListeners.remove(listener));
        }
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension size = super.getMinimumSize();
        size.width = 0;
        return size;
    }
}

