/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.graphic;

import com.macrofocus.graphic.GraphicModel;

public abstract class AbstractGraphicModel
implements GraphicModel {
    @Override
    public void drawRect(int x1, int y1, int x2, int y2, int color) {
        for (int y = y1; y <= y2; ++y) {
            if (y == y1 || y == y2) {
                for (int x = x1; x <= x2; ++x) {
                    this.drawPoint(x, y, color);
                }
                continue;
            }
            this.drawPoint(x1, y, color);
            this.drawPoint(x2, y, color);
        }
    }

    @Override
    public void fillRect(int x1, int y1, int x2, int y2, int color) {
        for (int y = y1; y <= y2; ++y) {
            this.drawHorizontalLine(x1, x2, y, color);
        }
    }

    @Override
    public void drawHorizontalLine(int x1, int x2, int y, int color) {
        for (int x = x1; x <= x2; ++x) {
            this.drawPoint(x, y, color);
        }
    }

    @Override
    public void drawVerticalLine(int x, int y1, int y2, int color) {
        for (int y = y1; y <= y2; ++y) {
            this.drawPoint(x, y, color);
        }
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2, int color) {
        int incY;
        int incX;
        int x = x1;
        int y = y1;
        int longX = x2 - x1;
        int longY = y2 - y1;
        if (longX >= 0) {
            incX = 1;
        } else {
            incX = -1;
            longX = -longX;
        }
        if (longY >= 0) {
            incY = 1;
        } else {
            incY = -1;
            longY = -longY;
        }
        if (longY < longX) {
            int const1 = 2 * (longY - longX);
            int const2 = 2 * longY;
            int criteria = const2 - longX;
            for (int i = 1; i <= longX; ++i) {
                this.drawPoint(x, y, color);
                if (criteria > 0) {
                    y += incY;
                    criteria += const1;
                } else {
                    criteria += const2;
                }
                x += incX;
            }
        } else {
            int const1 = 2 * (longX - longY);
            int const2 = 2 * longX;
            int criteria = const2 - longY;
            for (int i = 1; i <= longY; ++i) {
                this.drawPoint(x, y, color);
                if (criteria > 0) {
                    x += incX;
                    criteria += const1;
                } else {
                    criteria += const2;
                }
                y += incY;
            }
        }
    }

    @Override
    public void drawCircle(int cx, int cy, int r, int color) {
        int y = r;
        int criteria = 3 - 2 * r;
        int deltaC1 = 6;
        int deltaC2 = 4 * (1 - y);
        for (int x = 0; x <= y; ++x) {
            this.drawSymPoints(cx, cy, x, y, color);
            if ((criteria += deltaC1) >= deltaC1) {
                criteria += deltaC2;
                deltaC2 += 4;
                --y;
            }
            deltaC1 += 4;
        }
    }

    @Override
    public void drawClippedCircle(int cx, int cy, int r, int x1, int y1, int x2, int y2, int color) {
        int y = r;
        int criteria = 3 - 2 * r;
        int deltaC1 = 6;
        int deltaC2 = 4 * (1 - y);
        for (int x = 0; x <= y; ++x) {
            this.drawClippedSymPoints(cx, cy, x, y, x1, y1, x2, y2, color);
            if ((criteria += deltaC1) >= deltaC1) {
                criteria += deltaC2;
                deltaC2 += 4;
                --y;
            }
            deltaC1 += 4;
        }
    }

    @Override
    public void fillCircle(int cx, int cy, int r, int color) {
        int y = r;
        int criteria = 3 - 2 * r;
        int deltaC1 = 6;
        int deltaC2 = 4 * (1 - y);
        for (int x = 0; x <= y; ++x) {
            this.drawSymPoints(cx, cy, x, y, color);
            if ((criteria += deltaC1) >= deltaC1) {
                criteria += deltaC2;
                deltaC2 += 4;
                --y;
            }
            deltaC1 += 4;
        }
    }

    @Override
    public void fillClippedCircle(int cx, int cy, int r, int x1, int y1, int x2, int y2, int color) {
        int y = r;
        int criteria = 3 - 2 * r;
        int deltaC1 = 6;
        int deltaC2 = 4 * (1 - y);
        for (int x = 0; x <= y; ++x) {
            this.drawClippedSymPoints(cx, cy, x, y, x1, y1, x2, y2, color);
            if ((criteria += deltaC1) >= deltaC1) {
                criteria += deltaC2;
                deltaC2 += 4;
                --y;
            }
            deltaC1 += 4;
        }
    }

    private void drawSymPoints(int ax, int ay, int x, int y, int color) {
        if (x != y) {
            this.drawPoint(ax + x, ay + y, color);
            this.drawPoint(ax + y, ay - x, color);
            this.drawPoint(ax - x, ay - y, color);
            this.drawPoint(ax - y, ay + x, color);
        }
        if (x != 0) {
            this.drawPoint(ax + x, ay - y, color);
            this.drawPoint(ax - y, ay - x, color);
            this.drawPoint(ax - x, ay + y, color);
            this.drawPoint(ax + y, ay + x, color);
        }
    }

    private void drawClippedSymPoints(int ax, int ay, int x, int y, int x1, int y1, int x2, int y2, int color) {
        if (x != y) {
            this.drawClippedPoint(ax + x, ay + y, x1, y1, x2, y2, color);
            this.drawClippedPoint(ax + y, ay - x, x1, y1, x2, y2, color);
            this.drawClippedPoint(ax - x, ay - y, x1, y1, x2, y2, color);
            this.drawClippedPoint(ax - y, ay + x, x1, y1, x2, y2, color);
        }
        if (x != 0) {
            this.drawClippedPoint(ax + x, ay - y, x1, y1, x2, y2, color);
            this.drawClippedPoint(ax - y, ay - x, x1, y1, x2, y2, color);
            this.drawClippedPoint(ax - x, ay + y, x1, y1, x2, y2, color);
            this.drawClippedPoint(ax + y, ay + x, x1, y1, x2, y2, color);
        }
    }

    private void drawClippedPoint(int x, int y, int x1, int y1, int x2, int y2, int color) {
        if (x >= x1 && x <= x2 && y >= y1 && y <= y2) {
            this.drawPoint(x, y, color);
        }
    }

    public final String toString() {
        return this.getClass().getName() + "[width=" + this.getWidth() + ",height=" + this.getHeight() + "]";
    }
}

