/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.slider.range;

import com.macrofocus.slider.RangeSliderEvent;
import com.macrofocus.slider.RangeSliderListener;
import com.macrofocus.slider.RangeSliderModel;
import com.macrofocus.soom.lens.coordinate.CoordinateAxisModel;
import com.macrofocus.soom.lens.coordinate.OptimizedCoordinateAxisModel;
import com.macrofocus.util.swing.mouse.MMouseAdapter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;

public class MRangeSlider
extends JComponent {
    private boolean paintRange = false;
    private Color rangeColor = null;
    private final RangeSliderModel model;
    private CoordinateAxisModel coordinateAxis;
    private Icon minCursorIcon;
    private Icon maxCursorIcon;
    private double alignment;

    public MRangeSlider(final RangeSliderModel model, Icon minCursorIcon, Icon maxCursorIcon, double alignment) {
        this.model = model;
        this.minCursorIcon = minCursorIcon;
        this.maxCursorIcon = maxCursorIcon;
        this.alignment = alignment;
        model.addSliderListener(new RangeSliderListener(){

            public void sliderScaleChanged(RangeSliderEvent e) {
                MRangeSlider.this.coordinateAxis.setWorld(model.getMinimum(), model.getMaximum());
                MRangeSlider.this.repaint();
            }

            public void sliderChanged(RangeSliderEvent e) {
                MRangeSlider.this.coordinateAxis.setWorld(model.getMinimum(), model.getMaximum());
                MRangeSlider.this.repaint();
            }
        });
        this.coordinateAxis = new OptimizedCoordinateAxisModel(model.getMinimum(), model.getMaximum());
        MMouseAdapter mouseListener = new MMouseAdapter(){
            private MouseEvent last;
            private Cursor cursorSelected;

            @Override
            public void mousePressed(MouseEvent e) {
                this.last = e;
                if (MRangeSlider.this.getMaxCursorBounds().contains(e.getPoint())) {
                    this.cursorSelected = Cursor.Max;
                } else if (MRangeSlider.this.getMinCursorBounds().contains(e.getPoint())) {
                    this.cursorSelected = Cursor.Min;
                } else {
                    double x = MRangeSlider.this.coordinateAxis.screenToWorld(e.getX());
                    this.cursorSelected = Cursor.Max;
                    model.setValues((Object)this, x, x);
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (this.cursorSelected != null) {
                    int diff = e.getX() - this.last.getX();
                    switch (this.cursorSelected.ordinal()) {
                        case 0: {
                            int currentX = MRangeSlider.this.coordinateAxis.worldToScreen(model.getCurrentMinimum());
                            int newX = currentX + diff;
                            double x = MRangeSlider.this.coordinateAxis.screenToWorld(newX);
                            if (!(x <= model.getCurrentMaximum())) break;
                            model.setValues((Object)this, x, model.getCurrentMaximum());
                            break;
                        }
                        case 1: {
                            int currentX = MRangeSlider.this.coordinateAxis.worldToScreen(model.getCurrentMaximum());
                            int newX = currentX + diff;
                            double x = MRangeSlider.this.coordinateAxis.screenToWorld(newX);
                            if (!(x >= model.getCurrentMinimum())) break;
                            model.setValues((Object)this, model.getCurrentMinimum(), x);
                            break;
                        }
                        case 2: {
                            int minX = MRangeSlider.this.coordinateAxis.worldToScreen(model.getCurrentMinimum());
                            int newMinX = minX + diff;
                            double x1 = MRangeSlider.this.coordinateAxis.screenToWorld(newMinX);
                            int maxX = MRangeSlider.this.coordinateAxis.worldToScreen(model.getCurrentMaximum());
                            int newMaxX = maxX + diff;
                            double x2 = MRangeSlider.this.coordinateAxis.screenToWorld(newMaxX);
                            if (!(x1 >= model.getMinimum()) || !(x2 <= model.getMaximum())) break;
                            model.setValues((Object)this, x1, x2);
                            break;
                        }
                    }
                    this.last = e;
                }
            }
        };
        this.addMouseListener(mouseListener);
        this.addMouseMotionListener(mouseListener);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        this.coordinateAxis.setScreenSize(this.getSize().width);
        if (this.paintRange && this.rangeColor != null) {
            this.setForeground(this.rangeColor);
            g2.fill(this.getRangeCursorBounds());
        }
        int x1 = this.coordinateAxis.worldToScreen(this.model.getCurrentMinimum());
        int x2 = this.coordinateAxis.worldToScreen(this.model.getCurrentMaximum());
        int y1 = (int)(this.alignment * (double)(this.getSize().height - this.minCursorIcon.getIconHeight()));
        int y2 = (int)(this.alignment * (double)(this.getSize().height - this.maxCursorIcon.getIconHeight()));
        this.minCursorIcon.paintIcon(this, g, x1 - this.minCursorIcon.getIconWidth() / 2, y1);
        this.maxCursorIcon.paintIcon(this, g, x2 - this.maxCursorIcon.getIconWidth() / 2, y2);
    }

    private Rectangle getMinCursorBounds() {
        int x = this.coordinateAxis.worldToScreen(this.model.getCurrentMinimum()) - this.minCursorIcon.getIconWidth() / 2;
        int y = (int)(this.alignment * (double)(this.getSize().height - this.minCursorIcon.getIconHeight()));
        return new Rectangle(x, y, this.minCursorIcon.getIconWidth(), this.minCursorIcon.getIconHeight());
    }

    private Rectangle getMaxCursorBounds() {
        int x = this.coordinateAxis.worldToScreen(this.model.getCurrentMaximum()) - this.maxCursorIcon.getIconWidth() / 2;
        int y = (int)(this.alignment * (double)(this.getSize().height - this.maxCursorIcon.getIconHeight()));
        return new Rectangle(x, y, this.maxCursorIcon.getIconWidth(), this.maxCursorIcon.getIconHeight());
    }

    private Rectangle getRangeCursorBounds() {
        Rectangle min = this.getMinCursorBounds();
        Rectangle max = this.getMaxCursorBounds();
        return new Rectangle(min.x + min.width - this.minCursorIcon.getIconWidth() / 2, min.y, max.x - (min.x + min.width) + this.maxCursorIcon.getIconWidth(), min.height);
    }

    public void setRangeColor(Color color) {
        this.rangeColor = color;
        this.repaint();
    }

    public void setPaintRange(boolean b) {
        this.paintRange = b;
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(Math.max(this.minCursorIcon.getIconWidth(), this.maxCursorIcon.getIconWidth()), Math.max(this.minCursorIcon.getIconHeight(), this.maxCursorIcon.getIconHeight()));
    }

    private static enum Cursor {
        Min,
        Max,
        Range;

    }
}

