/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.geometry;

import com.macrofocus.util.geometry.Delaunay;
import com.macrofocus.util.geometry.PointModel;
import com.macrofocus.util.geometry.TriangleModel;

public class ExtendedDelaunay
extends Delaunay {
    private int l = 1;
    final int oldmoveHullLayer = this.l++;
    final int oldmoveVorLayer = this.l++;
    final int oldmoveDelLayer = this.l++;
    final int oldrefreshLayer = this.l++;
    final int oldhideVorLayer = this.l++;
    final int oldhideDelLayer = this.l++;
    final int hideDelLayer = this.l++;
    final int hideVorLayer = this.l++;
    final int refreshLayer = this.l++;
    final int moveDelLayer = this.l++;
    final int moveVorLayer = this.l++;
    final int moveHullLayer = this.l++;
    final int oldrefreshPointLayer = this.l++;
    final int refreshPointLayer = this.l++;
    final int layers = this.l;
    private boolean stepMode;
    private boolean oldShowVor;
    private boolean oldShowDel;
    private boolean moving = false;

    public ExtendedDelaunay() {
        this.createLayers(this.layers);
    }

    private TriangleModel insertTempSimple(PointModel p) {
        if (!this.allCollinear) {
            this.startTriangle = this.startTriangle.find(p);
            if (this.startTriangle.isHalfplane()) {
                return this.extendOutsideTemp(this.startTriangle, p);
            }
            return this.extendInsideTemp(this.startTriangle, p);
        }
        if (this.stepMode) {
            return null;
        }
        if (this.nPoints == 0) {
            return null;
        }
        if (this.nPoints == 1) {
            this.canvas.add(new PointModel(this.firstP), this.refreshPointLayer);
            if (this.showDel) {
                this.canvas.add(this.firstP, p, this.moveDelLayer);
            }
            if (this.showVor) {
                this.canvas.add(p.Bisector(this.firstP), this.moveVorLayer);
            }
            return null;
        }
        if (this.showHull) {
            this.canvas.add(new PointModel(this.firstP), this.refreshPointLayer);
            this.canvas.add(new PointModel(this.lastP), this.refreshPointLayer);
            this.canvas.add(this.firstP, p, this.moveHullLayer);
            this.canvas.add(p, this.lastP, this.moveHullLayer);
            this.canvas.add(this.lastP, this.firstP, this.moveHullLayer);
        }
        switch (p.pointLineTest(this.firstP, this.lastP)) {
            case 1: {
                this.firstNonCollinearTemp(this.extendOutsideTemp(this.firstT.getAbnext(), p));
                break;
            }
            case 2: {
                this.firstNonCollinearTemp(this.extendOutsideTemp(this.firstT, p));
                break;
            }
            case 0: {
                this.insertCollinearTemp(p, 0);
                break;
            }
            case 3: {
                this.insertCollinearTemp(p, 3);
                break;
            }
            case 4: {
                this.insertCollinearTemp(p, 4);
            }
        }
        return null;
    }

    private void firstNonCollinearTemp(TriangleModel t) {
        if (!this.showVor) {
            return;
        }
        TriangleModel tt = t;
        this.canvas.add(tt.getDualEdge(tt.getBcnext()), this.moveVorLayer);
        while (!tt.isHalfplane()) {
            this.canvas.add(tt.getDualEdge(tt.getAbnext()), this.moveVorLayer);
            this.canvas.add(tt.getDualEdge(tt.getCanext()), this.moveVorLayer);
            tt = tt.getCanext();
        }
    }

    private void insertCollinearTemp(PointModel p, int res) {
        TriangleModel t = this.firstT;
        switch (res) {
            case 3: {
                if (this.showDel) {
                    this.canvas.add(this.firstP, p, this.moveDelLayer);
                }
                if (!this.showVor) break;
                this.canvas.add(this.firstP.Bisector(p), this.moveVorLayer);
                break;
            }
            case 4: {
                if (this.showDel) {
                    this.canvas.add(this.lastP, p, this.moveDelLayer);
                }
                if (!this.showVor) break;
                this.canvas.add(this.lastP.Bisector(p), this.moveVorLayer);
                break;
            }
            case 0: {
                while (p.isGreater(t.getA())) {
                    this.canvas.add(new PointModel(t.getB()), this.refreshPointLayer);
                    if (this.showVor) {
                        this.canvas.add(t.getA().Bisector(t.getB()), this.moveVorLayer);
                    }
                    if (this.showDel) {
                        this.canvas.add(t.getA(), t.getB(), this.moveDelLayer);
                    }
                    t = t.getCanext();
                }
                this.canvas.add(new PointModel(t.getB()), this.refreshPointLayer);
                if (this.showVor) {
                    this.canvas.add(t.getA().Bisector(p), this.moveVorLayer);
                    this.canvas.add(t.getB().Bisector(p), this.moveVorLayer);
                }
                if (this.showDel) {
                    this.canvas.add(t.getA(), t.getB(), this.moveDelLayer);
                }
                t = t.getCanext();
            }
        }
        while (t.getB() != this.lastP) {
            this.canvas.add(new PointModel(t.getB()), this.refreshPointLayer);
            if (this.showVor) {
                this.canvas.add(t.getA().Bisector(t.getB()), this.moveVorLayer);
            }
            if (this.showDel) {
                this.canvas.add(t.getA(), t.getB(), this.moveDelLayer);
            }
            t = t.getCanext();
        }
        this.canvas.add(new PointModel(this.lastP), this.refreshPointLayer);
    }

    private TriangleModel startTriangulationTempA(PointModel A, PointModel B, PointModel C) {
        TriangleModel t = null;
        int res = C.pointLineTest(A, B);
        if (res == 1 || res == 4) {
            t = new TriangleModel(A, B, C);
        } else if (res == 2 || res == 0) {
            t = new TriangleModel(A, C, B);
        } else if (res == 3) {
            t = new TriangleModel(C, A, B);
        }
        TriangleModel h1 = new TriangleModel(t.getB(), t.getA());
        TriangleModel h2 = new TriangleModel(t.getC(), t.getB());
        TriangleModel h3 = new TriangleModel(t.getA(), t.getC());
        t.setNextTriangleAb(h1);
        h1.setNextTriangleAb(t);
        t.setNextTriangleBc(h2);
        h2.setNextTriangleAb(t);
        t.setNextTriangleCa(h3);
        h3.setNextTriangleAb(t);
        h1.setNextTriangleCa(h2);
        h2.setNextTriangleBc(h1);
        h2.setNextTriangleCa(h3);
        h3.setNextTriangleBc(h2);
        h3.setNextTriangleCa(h1);
        h1.setNextTriangleBc(h3);
        return t;
    }

    private TriangleModel extendInsideTemp(TriangleModel t, PointModel p) {
        TriangleModel h1 = this.treatDegeneracyInsideTemp(t, p);
        if (h1 != null) {
            return h1;
        }
        h1 = new TriangleModel(t.getA(), t.getB(), p);
        TriangleModel h2 = new TriangleModel(t.getB(), t.getC(), p);
        TriangleModel h3 = new TriangleModel(t.getC(), t.getA(), p);
        h1.setNextTriangleAb(t.getAbnext());
        h2.setNextTriangleAb(t.getBcnext());
        h3.setNextTriangleAb(t.getCanext());
        h1.setNextTriangleBc(h2);
        h2.setNextTriangleCa(h1);
        h2.setNextTriangleBc(h3);
        h3.setNextTriangleCa(h2);
        h3.setNextTriangleBc(h1);
        h1.setNextTriangleCa(h3);
        if (this.showDel) {
            this.canvas.add(t.getA(), p, this.moveDelLayer);
            this.canvas.add(t.getB(), p, this.moveDelLayer);
            this.canvas.add(t.getC(), p, this.moveDelLayer);
        }
        this.canvas.add(new PointModel(t.getA()), this.refreshPointLayer);
        this.canvas.add(new PointModel(t.getB()), this.refreshPointLayer);
        this.canvas.add(new PointModel(t.getC()), this.refreshPointLayer);
        return h1;
    }

    private TriangleModel treatDegeneracyInsideTemp(TriangleModel t, PointModel p) {
        if (t.getAbnext().isHalfplane() && p.pointLineTest(t.getB(), t.getA()) == 0) {
            return this.extendOutsideTemp(t.getAbnext(), p);
        }
        if (t.getBcnext().isHalfplane() && p.pointLineTest(t.getC(), t.getB()) == 0) {
            return this.extendOutsideTemp(t.getBcnext(), p);
        }
        if (t.getCanext().isHalfplane() && p.pointLineTest(t.getA(), t.getC()) == 0) {
            return this.extendOutsideTemp(t.getCanext(), p);
        }
        return null;
    }

    private TriangleModel extendOutsideTemp(TriangleModel t, PointModel p) {
        TriangleModel h2;
        if (p.pointLineTest(t.getA(), t.getB()) == 0) {
            TriangleModel dg = new TriangleModel(t.getA(), t.getB(), p);
            TriangleModel hp1 = new TriangleModel(t.getA(), p);
            TriangleModel hp2 = new TriangleModel(p, t.getB());
            dg.setNextTriangleAb(t.getAbnext());
            dg.setNextTriangleBc(hp2);
            hp2.setNextTriangleAb(dg);
            dg.setNextTriangleCa(hp1);
            hp1.setNextTriangleAb(dg);
            hp2.setNextTriangleBc(t.getBcnext());
            hp2.setNextTriangleCa(hp1);
            hp1.setNextTriangleBc(hp2);
            hp1.setNextTriangleCa(t.getCanext());
            if (this.showDel) {
                this.canvas.add(t.getA(), p, this.moveDelLayer);
                this.canvas.add(t.getB(), p, this.moveDelLayer);
            }
            this.canvas.add(new PointModel(t.getA()), this.refreshPointLayer);
            this.canvas.add(new PointModel(t.getB()), this.refreshPointLayer);
            return dg;
        }
        TriangleModel h1 = new TriangleModel(t.getA(), t.getB(), p);
        h1.setNextTriangleAb(t.getAbnext());
        if (this.showDel) {
            this.canvas.add(t.getA(), p, this.moveDelLayer);
            this.canvas.add(t.getB(), p, this.moveDelLayer);
            if (this.allCollinear) {
                this.canvas.add(t.getA(), t.getB(), this.refreshLayer);
            }
        }
        this.canvas.add(new PointModel(t.getA()), this.refreshPointLayer);
        this.canvas.add(new PointModel(t.getB()), this.refreshPointLayer);
        TriangleModel t1 = t.getCanext();
        TriangleModel prev1 = h1;
        while (p.pointLineTest(t1.getA(), t1.getB()) < 2) {
            if (this.showDel) {
                this.canvas.add(t1.getA(), p, this.moveDelLayer);
                if (this.allCollinear) {
                    this.canvas.add(t1.getA(), t1.getB(), this.refreshLayer);
                }
            }
            this.canvas.add(new PointModel(t1.getA()), this.refreshPointLayer);
            h2 = new TriangleModel(t1.getA(), t1.getB(), p);
            h2.setNextTriangleAb(t1.getAbnext());
            h2.setNextTriangleBc(prev1);
            prev1.setNextTriangleCa(h2);
            prev1 = h2;
            t1 = t1.getCanext();
        }
        h2 = new TriangleModel(prev1.getA(), p);
        h2.setNextTriangleAb(prev1);
        prev1.setNextTriangleCa(h2);
        h2.setNextTriangleCa(t1);
        prev1 = h2;
        TriangleModel t2 = t.getBcnext();
        TriangleModel prev2 = h1;
        while (p.pointLineTest(t2.getA(), t2.getB()) < 2) {
            if (this.showDel) {
                this.canvas.add(t2.getB(), p, this.moveDelLayer);
                if (this.allCollinear) {
                    this.canvas.add(t2.getA(), t2.getB(), this.refreshLayer);
                }
            }
            this.canvas.add(new PointModel(t2.getB()), this.refreshPointLayer);
            h2 = new TriangleModel(t2.getA(), t2.getB(), p);
            h2.setNextTriangleAb(t2.getAbnext());
            h2.setNextTriangleCa(prev2);
            prev2.setNextTriangleBc(h2);
            prev2 = h2;
            t2 = t2.getBcnext();
        }
        h2 = new TriangleModel(p, prev2.getB());
        h2.setNextTriangleAb(prev2);
        prev2.setNextTriangleBc(h2);
        h2.setNextTriangleBc(t2);
        h2.setNextTriangleCa(prev1);
        prev1.setNextTriangleBc(h2);
        return prev2;
    }
}

