/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.help;

import com.macrofocus.resources.properties.PropertiesEvent;
import com.macrofocus.resources.properties.PropertiesListener;
import com.macrofocus.resources.properties.PropertiesModel;
import java.awt.event.ActionEvent;
import javax.help.BadIDException;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.InvalidHelpSetContextException;
import javax.help.Map;
import javax.swing.AbstractAction;
import javax.swing.JLabel;

public class JHelpAction
extends AbstractAction {
    private String key;
    private String target;
    private static final ActionEvent cshAction = new ActionEvent(new JLabel(), 1001, null);
    private static HelpBroker helpBroker = null;
    private String trailing = "...";

    public JHelpAction(String target, String label) {
        this.putValue("Name", label + "...");
        this.target = target;
    }

    public JHelpAction(String key, PropertiesModel propertiesModel) {
        this(null, key, propertiesModel);
    }

    public JHelpAction(String target, String key, PropertiesModel propertiesModel) {
        this(target, key, propertiesModel, "...");
    }

    public JHelpAction(String target, String key, final PropertiesModel propertiesModel, String trailing) {
        this.target = target;
        this.key = key;
        this.trailing = trailing;
        propertiesModel.addPropertiesListener(new PropertiesListener(){

            public void propertiesChanged(PropertiesEvent e) {
                JHelpAction.this.updateProperties(propertiesModel);
            }
        });
        this.updateProperties(propertiesModel);
    }

    private void updateProperties(PropertiesModel propertiesModel) {
        Object name = "Unknown";
        if (propertiesModel.isAvailable(this.key)) {
            name = (String)propertiesModel.getValue(this.key);
        }
        name = (String)name + this.trailing;
        this.putValue("Name", name);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (this.target != null) {
            JHelpAction.showHelp(this.target);
        } else {
            JHelpAction.showHelp();
        }
    }

    public static HelpBroker getHelpBroker() {
        return helpBroker;
    }

    public static void setHelpBroker(HelpBroker helpBroker) {
        JHelpAction.helpBroker = helpBroker;
    }

    public static void showHelp() {
        if (helpBroker == null) {
            if (JHelpAction.getHelpBroker() != null) {
                new CSH.DisplayHelpFromSource(helpBroker).actionPerformed(cshAction);
            }
        } else {
            helpBroker.setDisplayed(true);
        }
    }

    public static void showHelp(String target) {
        JHelpAction.showHelp();
        if (target != null) {
            try {
                if (JHelpAction.getHelpBroker() != null) {
                    JHelpAction.getHelpBroker().setCurrentID(Map.ID.create((String)target, (HelpSet)helpBroker.getHelpSet()));
                }
            }
            catch (InvalidHelpSetContextException ee) {
                System.out.println(ee.getMessage());
            }
            catch (BadIDException e) {
                System.out.println(e.getMessage());
            }
        }
    }

    public static void showHelpFromFocus() {
        if (JHelpAction.getHelpBroker() != null) {
            new CSH.DisplayHelpFromFocus(helpBroker).actionPerformed(cshAction);
        }
    }

    public static void trackFieldHelp() {
        if (JHelpAction.getHelpBroker() != null) {
            new CSH.DisplayHelpAfterTracking(helpBroker).actionPerformed(cshAction);
        }
    }
}

