/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.swing.export.format;

import com.macrofocus.common.logging.Logging;
import com.macrofocus.util.file.filter.AbstractFileFilter;
import com.macrofocus.util.file.filter.PostscriptFileFilter;
import com.macrofocus.util.swing.export.format.AbstractGraphicsExportFormat;
import com.macrofocus.util.swing.export.format.ContentProvider;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.freehep.graphicsbase.util.UserProperties;
import org.freehep.graphicsio.ps.PSGraphics2D;

public class FreeHEPPostscriptExportFormat
extends AbstractGraphicsExportFormat {
    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public AbstractFileFilter getFileFilter() {
        return new PostscriptFileFilter();
    }

    @Override
    public Component getSettingsPanel() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(ContentProvider<Component> contentProvider, File file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        try {
            ((UserProperties)PSGraphics2D.getDefaultProperties()).setProperty(PSGraphics2D.TEXT_AS_SHAPES, false);
            PSGraphics2D g = new PSGraphics2D((OutputStream)fos, new Dimension(this.getExportWidth(contentProvider.getContent()), this.getExportHeight(contentProvider.getContent())));
            g.startExport();
            this.print(contentProvider.getContent(), (Graphics)g);
            g.endExport();
            g.dispose();
        }
        catch (RuntimeException e1) {
            Logging.getInstance().process((Throwable)e1);
        }
        finally {
            try {
                fos.flush();
                fos.close();
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
    }

    public String toString() {
        return this.getFileFilter().getName();
    }
}

