/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.swing.export.format;

import com.macrofocus.util.file.filter.PngFileFilter;
import com.macrofocus.util.swing.export.format.AbstractRasterExportFormat;
import java.awt.Component;
import java.awt.image.RenderedImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.NodeList;

public class PNGExportFormat
extends AbstractRasterExportFormat {
    public PngFileFilter getFileFilter() {
        return pngFileFilter;
    }

    @Override
    public Component getSettingsPanel() {
        return this.getSettingsEditor().getSettingsPanel();
    }

    public String toString() {
        return this.getFileFilter().getName();
    }

    @Override
    protected IIOMetadata createMetadata(ImageWriter writer, float xDPI, float yDPI, RenderedImage ri, ImageWriteParam writeParam) throws IIOInvalidTreeException {
        IIOMetadataNode horz;
        IIOMetadataNode dim;
        IIOMetadata destMeta = writer.getDefaultImageMetadata(new ImageTypeSpecifier(ri), writeParam);
        IIOMetadataNode destNodes = (IIOMetadataNode)destMeta.getAsTree("javax_imageio_1.0");
        NodeList nl = destNodes.getElementsByTagName("Dimension");
        if (nl != null && nl.getLength() > 0) {
            dim = (IIOMetadataNode)nl.item(0);
        } else {
            dim = new IIOMetadataNode("Dimension");
            destNodes.appendChild(dim);
        }
        nl = destNodes.getElementsByTagName("HorizontalPixelSize");
        if (nl == null || nl.getLength() == 0) {
            horz = new IIOMetadataNode("HorizontalPixelSize");
            dim.appendChild(horz);
            horz.setAttribute("value", Float.toString(xDPI / 25.4f));
        }
        if ((nl = destNodes.getElementsByTagName("VerticalPixelSize")) == null || nl.getLength() == 0) {
            horz = new IIOMetadataNode("VerticalPixelSize");
            dim.appendChild(horz);
            horz.setAttribute("value", Float.toString(yDPI / 25.4f));
        }
        destMeta.setFromTree("javax_imageio_1.0", destNodes);
        return destMeta;
    }

    @Override
    protected ImageWriteParam createWriteParam(ImageWriter writer) {
        return writer.getDefaultWriteParam();
    }
}

