/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.swing.print;

import com.macrofocus.resources.properties.PropertiesEvent;
import com.macrofocus.resources.properties.PropertiesListener;
import com.macrofocus.resources.properties.PropertiesModel;
import com.macrofocus.util.swing.print.ImageSelection;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;

public class CopyAction
extends AbstractAction {
    private Component component;
    private String propertyKey;
    private CopyCustomizer customizer = null;

    public CopyAction(String name, Component component) {
        super(name);
        this.component = component;
    }

    public CopyAction(final PropertiesModel propertiesModel, String propertyKey, CopyCustomizer customizer) {
        this.propertyKey = propertyKey;
        this.customizer = customizer;
        this.updateProperties(propertiesModel);
        if (propertiesModel != null) {
            propertiesModel.addPropertiesListener(new PropertiesListener(){

                public void propertiesChanged(PropertiesEvent e) {
                    CopyAction.this.updateProperties(propertiesModel);
                }
            });
        }
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.component != null) {
            Component component = this.component;
            this.paintToClipboard(component);
        }
    }

    private void paintToClipboard(Component component) {
        if (this.customizer != null) {
            component = this.customizer.configure(component);
        }
        Dimension size = component.getSize();
        BufferedImage bufferedImage = new BufferedImage(size.width, size.height, 1);
        Graphics2D g2 = bufferedImage.createGraphics();
        g2.setColor(Color.WHITE);
        g2.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        component.print(g2);
        ImageSelection imageSelection = new ImageSelection(bufferedImage);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        toolkit.getSystemClipboard().setContents(imageSelection, null);
        if (this.customizer != null) {
            this.customizer.restore(component);
        }
    }

    public void setComponent(Component component) {
        this.component = component;
        this.setEnabled(component != null);
    }

    private void updateProperties(PropertiesModel propertiesModel) {
        String name = "Copy";
        if (propertiesModel != null && propertiesModel.isAvailable(this.propertyKey)) {
            name = (String)propertiesModel.getValue(this.propertyKey);
        }
        this.putValue("Name", name);
    }

    public static interface CopyCustomizer {
        public Component configure(Component var1);

        public void restore(Component var1);
    }

    public static class DefaultCopyCustomizer
    implements CopyCustomizer {
        @Override
        public Component configure(Component component) {
            return component;
        }

        @Override
        public void restore(Component component) {
        }
    }
}

