/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.widgets;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.syntheticaaddons.SyntheticaAddonsUtilities;
import de.javasoft.widgets.IUIPropertySupport;
import de.javasoft.widgets.ui.UIValue;
import de.javasoft.widgets.util.WidgetUtils;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.ItemEvent;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;

public class JYCheckBox
extends JCheckBox
implements IUIPropertySupport {
    private static final long serialVersionUID = 559458749450181044L;
    private boolean setStateInteractive = true;
    private UIValue<Icon> halfSelectedIcon;
    private UIValue<Icon> rolloverHalfSelectedIcon;
    private UIValue<Icon> disabledHalfSelectedIcon;

    public JYCheckBox() {
        this(null, null, false);
    }

    public JYCheckBox(Action a) {
        this();
        this.setAction(a);
    }

    public JYCheckBox(Icon icon) {
        this(null, icon, false);
    }

    public JYCheckBox(Icon icon, boolean selected) {
        this(null, icon, selected);
    }

    public JYCheckBox(String text) {
        this(text, null, false);
    }

    public JYCheckBox(String text, boolean selected) {
        this(text, null, selected);
    }

    public JYCheckBox(String text, Icon icon) {
        this(text, icon, false);
    }

    public JYCheckBox(String text, Icon icon, boolean selected) {
        this(text, icon, selected ? State.SELECTED : State.DESELECTED);
    }

    public JYCheckBox(String text, Icon icon, State state) {
        super(text, icon, false);
        this.setModel(new CheckBoxModel(state));
    }

    @Override
    public void updateUI() {
        super.updateUI();
        Icon icon = SyntheticaLookAndFeel.loadIcon((String)"JYCheckBox.halfSelected.icon", (Component)this, (boolean)true);
        if (icon == null && this.getDefaultSelectedIcon() != null) {
            icon = SyntheticaAddonsUtilities.createAlphaIcon((Icon)this.getDefaultSelectedIcon(), (float)0.5f);
        }
        if (this.halfSelectedIconIsUIResource()) {
            this.setHalfSelectedIcon(icon, true);
        }
        if ((icon = SyntheticaLookAndFeel.loadIcon((String)"JYCheckBox.halfSelected.icon.hover", (Component)this, (boolean)true)) == null && this.getDefaultRolloverSelectedIcon() != null) {
            icon = SyntheticaAddonsUtilities.createAlphaIcon((Icon)this.getDefaultRolloverSelectedIcon(), (float)0.5f);
        }
        if (this.rolloverHalfSelectedIconIsUIResource()) {
            this.setRolloverHalfSelectedIcon(icon, true);
        }
        if ((icon = SyntheticaLookAndFeel.loadIcon((String)"JYCheckBox.halfSelected.icon.disabled", (Component)this, (boolean)true)) == null && this.getHalfSelectedIcon() != null) {
            icon = SyntheticaAddonsUtilities.createAlphaIcon((Component)this, (Icon)this.getHalfSelectedIcon(), (float)0.5f);
        }
        if (this.disabledHalfSelectedIconIsUIResource()) {
            this.setDisabledHalfSelectedIcon(icon, true);
        }
    }

    private Icon getDefaultSelectedIcon() {
        Icon icon = SyntheticaLookAndFeel.loadIcon((String)"Synthetica.checkBox.selected.image", (Component)this, (boolean)true);
        if (icon == null && UIManager.getLookAndFeel() instanceof SynthLookAndFeel) {
            SynthStyle ss = SynthLookAndFeel.getStyle(this, Region.CHECK_BOX);
            SynthContext sc = new SynthContext(this, Region.CHECK_BOX, ss, 512);
            icon = ss.getIcon(sc, "CheckBox.icon");
        }
        return icon;
    }

    private Icon getDefaultRolloverSelectedIcon() {
        Icon icon = SyntheticaLookAndFeel.loadIcon((String)"Synthetica.checkBox.hover.selected.image", (Component)this, (boolean)true);
        if (icon == null && UIManager.getLookAndFeel() instanceof SynthLookAndFeel) {
            SynthStyle ss = SynthLookAndFeel.getStyle(this, Region.CHECK_BOX);
            SynthContext sc = new SynthContext(this, Region.CHECK_BOX, ss, 514);
            icon = ss.getIcon(sc, "CheckBox.icon");
        }
        return icon;
    }

    @Override
    public Icon getSelectedIcon() {
        return ((CheckBoxModel)this.getModel()).getState() == State.HALF_SELECTED ? this.getHalfSelectedIcon() : super.getSelectedIcon();
    }

    @Override
    public Icon getRolloverSelectedIcon() {
        return ((CheckBoxModel)this.getModel()).getState() == State.HALF_SELECTED ? this.getRolloverHalfSelectedIcon() : super.getRolloverSelectedIcon();
    }

    @Override
    public Icon getDisabledSelectedIcon() {
        return ((CheckBoxModel)this.getModel()).getState() == State.HALF_SELECTED ? this.getDisabledHalfSelectedIcon() : super.getSelectedIcon();
    }

    public void setState(State state) {
        ((CheckBoxModel)this.getModel()).setState(state);
    }

    public State getState() {
        return ((CheckBoxModel)this.getModel()).getState();
    }

    public void setStateInteractive(boolean enabled) {
        this.setStateInteractive = enabled;
    }

    public boolean isStateInteractive() {
        return this.setStateInteractive;
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void setHalfSelectedIcon(Icon icon) {
        this.setHalfSelectedIcon(icon, false);
    }

    public void setHalfSelectedIcon(Icon icon, boolean isUIResource) {
        WidgetUtils.setUIProperty(this, "halfSelectedIcon", this.halfSelectedIcon, this.getHalfSelectedIcon(), icon, isUIResource, false, false);
    }

    public boolean halfSelectedIconIsUIResource() {
        return this.getHalfSelectedIconUIValue().isUIResource();
    }

    public Icon getHalfSelectedIcon() {
        return this.getHalfSelectedIconUIValue().get();
    }

    private UIValue<Icon> getHalfSelectedIconUIValue() {
        if (this.halfSelectedIcon == null) {
            this.halfSelectedIcon = new UIValue();
        }
        return this.halfSelectedIcon;
    }

    public void setRolloverHalfSelectedIcon(Icon icon) {
        this.setRolloverHalfSelectedIcon(icon, false);
    }

    public void setRolloverHalfSelectedIcon(Icon icon, boolean isUIResource) {
        WidgetUtils.setUIProperty(this, "rolloverHalfSelectedIcon", this.rolloverHalfSelectedIcon, this.getRolloverHalfSelectedIcon(), icon, isUIResource, false, false);
    }

    public boolean rolloverHalfSelectedIconIsUIResource() {
        return this.getRolloverHalfSelectedIconUIValue().isUIResource();
    }

    public Icon getRolloverHalfSelectedIcon() {
        return this.getRolloverHalfSelectedIconUIValue().get();
    }

    private UIValue<Icon> getRolloverHalfSelectedIconUIValue() {
        if (this.rolloverHalfSelectedIcon == null) {
            this.rolloverHalfSelectedIcon = new UIValue();
        }
        return this.rolloverHalfSelectedIcon;
    }

    public void setDisabledHalfSelectedIcon(Icon icon) {
        this.setDisabledHalfSelectedIcon(icon, false);
    }

    public void setDisabledHalfSelectedIcon(Icon icon, boolean isUIResource) {
        WidgetUtils.setUIProperty(this, "disabledHalfSelectedIcon", this.disabledHalfSelectedIcon, this.getDisabledHalfSelectedIcon(), icon, isUIResource, false, false);
    }

    public boolean disabledHalfSelectedIconIsUIResource() {
        return this.getDisabledHalfSelectedIconUIValue().isUIResource();
    }

    public Icon getDisabledHalfSelectedIcon() {
        return this.getDisabledHalfSelectedIconUIValue().get();
    }

    private UIValue<Icon> getDisabledHalfSelectedIconUIValue() {
        if (this.disabledHalfSelectedIcon == null) {
            this.disabledHalfSelectedIcon = new UIValue();
        }
        return this.disabledHalfSelectedIcon;
    }

    private class CheckBoxModel
    extends JToggleButton.ToggleButtonModel {
        private static final long serialVersionUID = 6033408508665083060L;
        private State state;

        public CheckBoxModel() {
            this(State.DESELECTED);
        }

        public CheckBoxModel(State state) {
            this.setState(state);
        }

        @Override
        public void setPressed(boolean pressed) {
            if (!JYCheckBox.this.setStateInteractive) {
                super.setPressed(pressed);
                return;
            }
            if (this.isPressed() == pressed || !this.isEnabled()) {
                return;
            }
            if (!pressed && this.isArmed()) {
                this.nextState();
            }
            this.stateMask = pressed ? (this.stateMask |= 4) : (this.stateMask &= 0xFFFFFFFB);
            this.fireStateChanged();
            if (!this.isPressed() && this.isArmed()) {
                int modifiers = 0;
                AWTEvent currentEvent = EventQueue.getCurrentEvent();
                if (currentEvent instanceof InputEvent) {
                    modifiers = ((InputEvent)currentEvent).getModifiersEx();
                } else if (currentEvent instanceof ActionEvent) {
                    modifiers = ((ActionEvent)currentEvent).getModifiers();
                }
                this.fireActionPerformed(new ActionEvent(this, 1001, this.getActionCommand(), EventQueue.getMostRecentEventTime(), modifiers));
            }
        }

        @Override
        public void setSelected(boolean selected) {
            this.setState(selected ? State.SELECTED : State.DESELECTED);
        }

        public void setState(State state) {
            this.state = state;
            if (state == State.SELECTED) {
                super.setSelected(true);
                if (this.nextStateReverse()) {
                    this.fireStateChanged();
                    this.fireItemStateChanged(new ItemEvent(this, 701, this, 1));
                }
            } else if (state == State.DESELECTED) {
                super.setSelected(false);
            } else {
                super.setSelected(true);
                this.fireStateChanged();
                this.fireItemStateChanged(new ItemEvent(this, 701, this, -1));
            }
        }

        public State getState() {
            return this.state;
        }

        private void nextState() {
            State state = this.getState();
            if (state == State.DESELECTED) {
                this.setState(this.nextStateReverse() ? State.HALF_SELECTED : State.SELECTED);
            } else if (state == State.SELECTED) {
                this.setState(this.nextStateReverse() ? State.DESELECTED : State.HALF_SELECTED);
            } else if (state == State.HALF_SELECTED) {
                this.setState(this.nextStateReverse() ? State.SELECTED : State.DESELECTED);
            }
        }

        private boolean nextStateReverse() {
            return (Boolean)SyntheticaLookAndFeel.getClientProperty((String)"JYCheckBox.nextStateReverse", (JComponent)JYCheckBox.this, (Object)false);
        }
    }

    public static enum State {
        SELECTED,
        HALF_SELECTED,
        DESELECTED;

    }
}

