/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing.originalfastvoronoi.convexHull;

import com.treemap.swing.originalfastvoronoi.convexHull.JFace;
import com.treemap.swing.originalfastvoronoi.convexHull.JVertex;
import java.util.List;

public class HEdge {
    private JVertex origin;
    private JVertex dest;
    private HEdge twin;
    private JFace iFace;
    private HEdge next;
    private HEdge prev;

    public HEdge(JVertex origin, JVertex dest, JFace iFace) {
        this.origin = origin;
        this.dest = dest;
        this.iFace = iFace;
    }

    public void setDest(JVertex dest) {
        this.dest = dest;
    }

    public boolean isEqual(JVertex origin, JVertex dest) {
        return this.origin.equals(origin) && this.dest.equals(dest) || this.origin.equals(dest) && this.dest.equals(origin);
    }

    public JVertex getOrigin() {
        return this.origin;
    }

    public void setOrigin(JVertex origin) {
        this.origin = origin;
    }

    public HEdge getTwin() {
        return this.twin;
    }

    public void setTwin(HEdge twin) {
        this.twin = twin;
    }

    public JFace getiFace() {
        return this.iFace;
    }

    public void setiFace(JFace iFace) {
        this.iFace = iFace;
    }

    public HEdge getNext() {
        return this.next;
    }

    public void setNext(HEdge next) {
        this.next = next;
    }

    public HEdge getPrev() {
        return this.prev;
    }

    public void setPrev(HEdge prev) {
        this.prev = prev;
    }

    public String toString() {
        return this.origin.toString() + "->" + this.dest.toString();
    }

    public JVertex getDest() {
        return this.dest;
    }

    public boolean isHorizon() {
        return this.twin != null && this.twin.getiFace().isMarked() && !this.iFace.isMarked();
    }

    public void findHorizon(List<HEdge> horizon) {
        if (this.isHorizon()) {
            if (horizon.size() > 0 && this == horizon.get(0)) {
                return;
            }
            horizon.add(this);
            this.next.findHorizon(horizon);
        } else if (this.twin != null) {
            this.twin.getNext().findHorizon(horizon);
        }
    }
}

