/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing.originalfastvoronoi.convexHull;

import com.treemap.swing.originalfastvoronoi.convexHull.JConflictList;
import com.treemap.swing.originalfastvoronoi.j3d.Point3d;

public class JVertex {
    public double x;
    public double y;
    public double z;
    private static final double epsilon = 1.0E-10;
    private JConflictList list = new JConflictList(false);
    private int index = -1;
    private boolean handled;
    public Object originalObject;

    public JVertex(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public JConflictList getList() {
        return this.list;
    }

    public void setList(JConflictList list) {
        this.list = list;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public boolean equals(Object o) {
        if (!(o instanceof JVertex)) {
            return false;
        }
        JVertex obj = (JVertex)o;
        return obj.x == this.x && obj.y == this.y && obj.z == this.z;
    }

    public boolean linearDependent(JVertex v) {
        if (this.x == 0.0 && v.x == 0.0) {
            if (this.y == 0.0 && v.y == 0.0) {
                if (this.z == 0.0 && v.z == 0.0) {
                    return true;
                }
                return this.z != 0.0 && v.y != 0.0;
            }
            if (this.y == 0.0 || v.y == 0.0) {
                return false;
            }
            return this.z / this.y >= v.z / v.y - 1.0E-10 && this.z / this.y <= v.z / v.y + 1.0E-10;
        }
        if (this.x == 0.0 || v.x == 0.0) {
            return false;
        }
        return this.y / this.x <= v.y / v.x + 1.0E-10 && this.y / this.x >= v.y / v.x - 1.0E-10 && this.z / this.x >= v.y / v.x - 1.0E-10 && this.z / this.x <= v.z / v.x + 1.0E-10;
    }

    public void negate() {
        this.x *= -1.0;
        this.y *= -1.0;
        this.z *= -1.0;
    }

    public JVertex subtract(JVertex v) {
        return new JVertex(v.x - this.x, v.y - this.y, v.z - this.z);
    }

    public JVertex crossProduct(JVertex v) {
        return new JVertex(this.y * v.z - this.z * v.y, this.z * v.x - this.x * v.z, this.x * v.y - this.y * v.x);
    }

    public String toString() {
        return "Vertex{x=" + this.x + ", y=" + this.y + ", z=" + this.z + "}";
    }

    public void setHandled(boolean b) {
        this.handled = b;
    }

    public boolean isHandled() {
        return this.handled;
    }

    public Point3d toPoint3D() {
        return new Point3d(this.x, this.y, this.z);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public void clear() {
        this.list = new JConflictList(false);
        this.index = -1;
        this.handled = false;
    }
}

