/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing.voronoi;

import com.treemap.swing.voronoi.Path;
import com.treemap.swing.voronoi.VoronoiCell;
import com.treemap.swing.voronoi.VoronoiOutputRaster;
import com.treemap.swing.voronoi.smoothing.Direction;
import java.awt.Rectangle;
import java.util.ArrayList;

public class MarchingSquares {
    private final VoronoiCell cell;
    private final VoronoiOutputRaster outputRaster;
    private final int width;
    private final int height;
    private final Rectangle domainBounds;

    public MarchingSquares(int width, int height, VoronoiCell cell, VoronoiOutputRaster outputRaster) {
        this.width = width;
        this.height = height;
        this.cell = cell;
        this.outputRaster = outputRaster;
        this.domainBounds = this.outputRaster.getDomainBounds();
    }

    public Path identifyPerimeter(int initialX, int initialY) {
        Direction direction;
        int initialValue;
        if (initialX < this.domainBounds.x) {
            initialX = this.domainBounds.x;
        }
        if (initialX > this.domainBounds.x + this.width) {
            initialX = this.domainBounds.x + this.width;
        }
        if (initialY < this.domainBounds.y) {
            initialY = this.domainBounds.y;
        }
        if (initialY > this.domainBounds.y + this.height) {
            initialY = this.domainBounds.y + this.height;
        }
        if ((initialValue = this.value(initialX, initialY)) == 0 || initialValue == 15) {
            throw new IllegalArgumentException(String.format("Supplied initial coordinates (%d, %d) do not lie on a perimeter.", initialX, initialY));
        }
        ArrayList<Direction> directions = new ArrayList<Direction>();
        int x = initialX;
        int y = initialY;
        Direction previous = null;
        do {
            switch (this.value(x, y)) {
                case 1: {
                    direction = Direction.N;
                    break;
                }
                case 2: {
                    direction = Direction.E;
                    break;
                }
                case 3: {
                    direction = Direction.E;
                    break;
                }
                case 4: {
                    direction = Direction.W;
                    break;
                }
                case 5: {
                    direction = Direction.N;
                    break;
                }
                case 6: {
                    direction = previous == Direction.N ? Direction.W : Direction.E;
                    break;
                }
                case 7: {
                    direction = Direction.E;
                    break;
                }
                case 8: {
                    direction = Direction.S;
                    break;
                }
                case 9: {
                    direction = previous == Direction.E ? Direction.N : Direction.S;
                    break;
                }
                case 10: {
                    direction = Direction.S;
                    break;
                }
                case 11: {
                    direction = Direction.S;
                    break;
                }
                case 12: {
                    direction = Direction.W;
                    break;
                }
                case 13: {
                    direction = Direction.N;
                    break;
                }
                case 14: {
                    direction = Direction.W;
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid value " + this.value(x, y));
                }
            }
            directions.add(direction);
            previous = direction;
        } while ((x += direction.screenX) != initialX || (y += direction.screenY) != initialY);
        return new Path(initialX, initialY, directions);
    }

    public Path identifyPerimeter() {
        for (int x = this.domainBounds.x; x < this.domainBounds.x + this.width; ++x) {
            for (int y = this.domainBounds.y; y < this.domainBounds.y + this.height; ++y) {
                if (this.outputRaster.get(x, y) != this.cell) continue;
                return this.identifyPerimeter(x, y);
            }
        }
        return null;
    }

    private int value(int x, int y) {
        int sum = 0;
        if (this.isSet(x, y)) {
            sum |= 1;
        }
        if (this.isSet(x + 1, y)) {
            sum |= 2;
        }
        if (this.isSet(x, y + 1)) {
            sum |= 4;
        }
        if (this.isSet(x + 1, y + 1)) {
            sum |= 8;
        }
        return sum;
    }

    private boolean isSet(int x, int y) {
        return x > this.domainBounds.x && x <= this.domainBounds.x + this.width && y > this.domainBounds.y && y <= this.domainBounds.y + this.height && this.outputRaster.get(x - 1, y - 1) == this.cell;
    }
}

