/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing.voronoi;

import com.macrofocus.common.collection.PluggableCollectionFactory;
import com.macrofocus.crossplatform.swing.SwingFactory;
import com.macrofocus.geom.AffineTransform;
import com.macrofocus.geom.Point2D;
import com.macrofocus.geom.Polygon;
import com.macrofocus.geom.Rectangle;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.geom.Shape;
import com.treemap.AbstractAlgorithm;
import com.treemap.AbstractLabeling;
import com.treemap.Algorithm;
import com.treemap.MutableTreeMapNode;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapWorker;
import com.treemap.swing.voronoi.MovingAverager;
import com.treemap.swing.voronoi.Point2d;
import com.treemap.swing.voronoi.PrecomputedRandom;
import com.treemap.swing.voronoi.ShapeConverter;
import com.treemap.swing.voronoi.VoronoiCell;
import com.treemap.swing.voronoi.VoronoiOutputRaster;
import com.treemap.swing.voronoi.VoronoiRandom;
import com.treemap.swing.voronoi.debug.Debugger;
import com.treemap.swing.voronoi.smoothing.CornerDetector;
import com.treemap.swing.voronoi.smoothing.SmoothVoronoiCellShape;
import com.treemap.swing.voronoi.smoothing.Vertex;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class VoronoiAlgorithm<N, Row, Column, Color, Font>
extends AbstractAlgorithm<N, Row, Column, Color, Font> {
    private static final boolean ITERATION_DEBUG = false;
    private static final boolean TIME_DEBUG = false;
    private static final boolean PROGRESS_DEBUG = false;
    private static final boolean ACCURACY_DEBUG = false;
    private static final boolean SMOOTHING_DEBUG = false;
    private static final boolean SMOOTHING = true;
    private final int minIterations;
    private final int maxIterations;
    private final int maxRestarts;
    private final int seed;
    private double epsilon;
    private final WeightType weightType;
    private long startMillis = 0L;
    protected double delta;
    private double maxError = 0.0;
    private VoronoiRandom random;
    private final VoronoiOutputRaster outputRaster = new VoronoiOutputRaster();
    private final int pixelCellsPerSec = 1000000;
    private final Map<MutableTreeMapNode, Integer> nodeRemainingPixelCells = new LinkedHashMap<MutableTreeMapNode, Integer>();
    private final double maxDomainArea = Double.MAX_VALUE;
    private final ExecutorService executor;
    private final int nAvailableProcessors;
    private int estimatedPixelCells;
    private final MovingAverager averager = new MovingAverager(10);
    private int actualPixelCells = 0;
    private final List<Future<Object>> futures = PluggableCollectionFactory.getInstance().copyOnWriteArrayList();

    public VoronoiAlgorithm() {
        this(1.0E-4, -0.4844, 1, 100, 11, 20, WeightType.AW);
    }

    public VoronoiAlgorithm(double epsilon, double delta, int minIterations, int maxIterations, int seed, int maxRestarts, WeightType weightType) {
        this.epsilon = epsilon;
        this.delta = delta;
        this.minIterations = minIterations;
        this.maxIterations = maxIterations;
        this.maxRestarts = maxRestarts;
        this.seed = seed;
        this.weightType = weightType;
        this.nAvailableProcessors = Math.max(Runtime.getRuntime().availableProcessors(), 1);
        this.executor = SwingFactory.getInstance().newFixedThreadPool(VoronoiAlgorithm.class.getSimpleName(), 0, this.nAvailableProcessors);
        this.random = new PrecomputedRandom(seed, 10000);
    }

    public void startLayout(Rectangle2D bounds, TreeMapModel<N, Row, Column, Color, Font> model, N root, TreeMapWorker worker) {
        this.random.reset();
        LinkedHashMap<Object, Integer> nodePixelsMap = new LinkedHashMap<Object, Integer>();
        LinkedHashMap<Object, Integer> nodePixelCellsMap = new LinkedHashMap<Object, Integer>();
        HashMap<Object, Double> nodeSumSizesMap = new HashMap<Object, Double>();
        this.nodeRemainingPixelCells.clear();
        int diagramPixels = (int)(bounds.getWidth() * bounds.getHeight());
        int diagramPixelsForCalc = Math.min(diagramPixels, Integer.MAX_VALUE);
        nodePixelsMap.put(root, diagramPixels);
        int nRootChildren = 0;
        double sumSizes = 0.0;
        for (Object child : model.getChildren(root)) {
            sumSizes += model.getSize(child);
            ++nRootChildren;
        }
        nodeSumSizesMap.put(root, sumSizes);
        Algorithm algorithm = model.getSettings().getFieldSettings(model.getChildrenGroupByField(root)).getAlgorithm();
        Iterable iterator = algorithm.iterator(model, root);
        int rootPixelCells = diagramPixelsForCalc * nRootChildren;
        nodePixelCellsMap.put(root, rootPixelCells);
        this.estimatedPixelCells = rootPixelCells;
        for (Object node : iterator) {
            if (node == root || model.hasNoChildren(node)) continue;
            int nCells = 0;
            sumSizes = 0.0;
            for (Object child : model.getChildren(node)) {
                sumSizes += model.getSize(child);
                ++nCells;
            }
            nodeSumSizesMap.put(node, sumSizes);
            Object parent = model.getParent(node);
            int parentPixels = (Integer)nodePixelsMap.get(parent);
            double parentSumSizes = (Double)nodeSumSizesMap.get(parent);
            double size = model.getSize(node);
            int pixels = (int)((double)parentPixels * size / parentSumSizes);
            nodePixelsMap.put(node, pixels);
            int pixelsForCalc = Math.min(pixels, Integer.MAX_VALUE);
            int pixelCells = pixelsForCalc * nCells;
            this.estimatedPixelCells += pixelCells;
            nodePixelCellsMap.put(node, pixelCells);
        }
        int accPixelCells = 0;
        for (Object node : nodePixelCellsMap.keySet()) {
            int pixelCells = (Integer)nodePixelCellsMap.get(node);
            this.nodeRemainingPixelCells.put((MutableTreeMapNode)node, this.estimatedPixelCells - (accPixelCells += pixelCells));
        }
        Debugger debugger = Debugger.instance();
        debugger.setEstimatedPixelXells(this.estimatedPixelCells);
        this.startMillis = System.currentTimeMillis();
        this.actualPixelCells = 0;
        debugger.clearErrorValues();
    }

    public boolean breadthFirstLayout(Shape shape, MutableTreeMapNode parent, MutableTreeMapNode[] children, double sumSizes, int horizontalVanishingPoint, int verticalVanishingPoint, TreeMapWorker worker) {
        long layoutStart = System.currentTimeMillis();
        ArrayList<VoronoiCell> cellList = new ArrayList<VoronoiCell>();
        for (MutableTreeMapNode child : children) {
            double normalizedDesiredArea = child.getSize() / sumSizes;
            if (!(normalizedDesiredArea > 0.0)) continue;
            cellList.add(new VoronoiCell(normalizedDesiredArea, child, parent));
        }
        int size = cellList.size();
        VoronoiCell[] cells = cellList.toArray(new VoronoiCell[size]);
        if (children.length > 1) {
            List<Vertex> domainVertexes;
            VoronoiOutputRaster voronoiOutputRaster = this.run(shape, cells, worker, parent);
            if (voronoiOutputRaster == null) {
                return false;
            }
            this.removeSingleDiagonallySeparatedPixels(voronoiOutputRaster);
            List<Vertex> vertexes = CornerDetector.detect(voronoiOutputRaster, shape);
            if (vertexes != null && shape instanceof SmoothVoronoiCellShape && (domainVertexes = ((SmoothVoronoiCellShape)shape).getVertexes()) != null) {
                for (Vertex domainVertex : domainVertexes) {
                    boolean vertexOfParentSegment = !domainVertex.isRectangleCorner();
                    vertexes.add(new Vertex(domainVertex, vertexOfParentSegment));
                }
            }
            ShapeConverter.getShapeByMarchingSquares(cells, voronoiOutputRaster, vertexes, shape);
        } else {
            children[0].setShape(parent.getShape());
        }
        for (VoronoiCell cell : cells) {
            if (cell.getCurrentArea() != 0) continue;
            Debugger.instance().incZeroAreaCellsCount();
        }
        int progress = (int)(this.estimateProgress(shape, parent, layoutStart, cells) * 99.0);
        worker.setProgress(progress);
        return false;
    }

    private double estimateProgress(Shape domain, MutableTreeMapNode parent, long layoutStart, VoronoiCell[] cells) {
        long lyoutEndMillis = System.currentTimeMillis();
        double layoutDuration = this.toSecs(lyoutEndMillis - layoutStart);
        double durationSec = this.toSecs(lyoutEndMillis - this.startMillis);
        int pixels = (int)Math.min(this.calculateArea(domain), Double.MAX_VALUE);
        int pixelCells = pixels * cells.length;
        this.actualPixelCells += pixelCells;
        double pixelCellsPerSec = (double)this.actualPixelCells / durationSec;
        this.averager.add(pixelCellsPerSec);
        pixelCellsPerSec = this.averager.getAverage();
        double estimatedProgress = (double)this.actualPixelCells / (double)this.estimatedPixelCells;
        double remainingTimeEstimation = durationSec / estimatedProgress - durationSec;
        Debugger.DataEntry dataEntry = new Debugger.DataEntry(parent.toString(), durationSec, estimatedProgress, remainingTimeEstimation, pixelCells, pixels, cells.length, layoutDuration);
        Debugger.instance().add(dataEntry, false);
        return estimatedProgress;
    }

    private void removeSingleDiagonallySeparatedPixels(VoronoiOutputRaster voronoiOutputRaster) {
        java.awt.Rectangle domainBounds = voronoiOutputRaster.getDomainBounds();
        ArrayList neighbourCells = new ArrayList(4);
        HashMap<VoronoiCell, Integer> cellNeighbourCountMap = new HashMap<VoronoiCell, Integer>();
        for (int x = domainBounds.x; x < domainBounds.x + domainBounds.width; ++x) {
            for (int y = domainBounds.y; y < domainBounds.y + domainBounds.height; ++y) {
                VoronoiCell cell = voronoiOutputRaster.get(x, y);
                VoronoiCell north = voronoiOutputRaster.get(x, y - 1);
                VoronoiCell south = voronoiOutputRaster.get(x, y + 1);
                VoronoiCell west = voronoiOutputRaster.get(x - 1, y);
                VoronoiCell east = voronoiOutputRaster.get(x + 1, y);
                neighbourCells.clear();
                Collections.addAll(neighbourCells, north, south, west, east);
                boolean connected = false;
                for (VoronoiCell neighbourCell : neighbourCells) {
                    if (cell != neighbourCell) continue;
                    connected = true;
                    break;
                }
                if (connected) continue;
                cellNeighbourCountMap.clear();
                for (VoronoiCell neighbourCell : neighbourCells) {
                    if (cellNeighbourCountMap.containsKey(neighbourCell)) {
                        int neighbourCount = (Integer)cellNeighbourCountMap.get(neighbourCell);
                        cellNeighbourCountMap.put(neighbourCell, ++neighbourCount);
                        continue;
                    }
                    cellNeighbourCountMap.put(neighbourCell, 1);
                }
                int maxNeighbourCount = 0;
                VoronoiCell maxNeighbourCountCell = west;
                for (VoronoiCell neighbourCell : cellNeighbourCountMap.keySet()) {
                    Integer neighbourCount = (Integer)cellNeighbourCountMap.get(neighbourCell);
                    if (neighbourCount <= maxNeighbourCount) continue;
                    maxNeighbourCount = neighbourCount;
                    maxNeighbourCountCell = neighbourCell;
                }
                voronoiOutputRaster.set(x, y, maxNeighbourCountCell);
            }
        }
    }

    private double toSecs(long millis) {
        return (double)millis / 1000.0;
    }

    public VoronoiOutputRaster run(Shape unscaledDomain, VoronoiCell[] cells, TreeMapWorker worker, MutableTreeMapNode parent) {
        Shape domain;
        double scale;
        boolean scaled;
        Double outputArea = this.calculateArea(unscaledDomain);
        if (outputArea == null) {
            return null;
        }
        Rectangle unscaledDomainBounds = new Rectangle(unscaledDomain.getBounds());
        boolean bl = scaled = outputArea > Double.MAX_VALUE;
        if (scaled) {
            scale = Math.sqrt(Double.MAX_VALUE / outputArea);
            AffineTransform scaleTransform = AffineTransform.getScaleInstance((double)scale, (double)scale);
            domain = scaleTransform.createTransformedShape(unscaledDomain);
            outputArea = Double.MAX_VALUE;
        } else {
            scale = 1.0;
            domain = unscaledDomain;
        }
        this.outputRaster.setDomain(domain);
        this.initializePositions(cells, domain, outputArea);
        int nIterations = 0;
        int nRestarts = 0;
        boolean proceed = true;
        double deltaForLayout = this.delta;
        block0: do {
            if (worker != null && worker.isCancelled()) {
                return null;
            }
            this.computeVoronoiTessellation(this.outputRaster, cells, domain);
            boolean stable = true;
            double maxErrorAbsolute = 0.0;
            this.maxError = 0.0;
            for (VoronoiCell cell : cells) {
                if (worker != null && worker.isCancelled()) {
                    return null;
                }
                double normalizedArea = outputArea != 0.0 ? (double)cell.getCurrentArea() / outputArea : 0.0;
                cell.setCurrentNormalizedArea(normalizedArea);
                double desiredArea = cell.getDesiredNormalizedArea();
                double error = normalizedArea - desiredArea;
                double errorAbsolute = Math.abs(error);
                cell.setErrorAbsolute(errorAbsolute);
                if (errorAbsolute >= this.epsilon) {
                    stable = false;
                }
                if (!(errorAbsolute > maxErrorAbsolute)) continue;
                this.maxError = error;
                maxErrorAbsolute = errorAbsolute;
                Debugger.instance().setMaxErrorCell(cell);
            }
            this.moveGenerators(cells, domain);
            for (VoronoiCell cell : cells) {
                this.adjustWeightPW(cell);
            }
            proceed = (!stable || ++nIterations < this.minIterations) && nIterations < this.maxIterations;
            double maxDeltaValue = -0.4844;
            if (proceed || stable || nRestarts >= this.maxRestarts) continue;
            for (VoronoiCell cell : cells) {
                if (cell.getCurrentArea() != 0) continue;
                deltaForLayout /= 10.0;
                deltaForLayout = Math.min(deltaForLayout, -0.4844);
                nIterations = 0;
                ++nRestarts;
                proceed = true;
                continue block0;
            }
        } while (proceed);
        if (scaled) {
            this.outputRaster.setDomain((Shape)unscaledDomainBounds);
            for (VoronoiCell cell : cells) {
                double reverseScale = 1.0 / scale;
                cell.scale(reverseScale);
            }
            this.computeVoronoiTessellation(this.outputRaster, cells, unscaledDomain);
        }
        return this.outputRaster;
    }

    private Double calculateArea(Shape shape) {
        Double outputArea;
        if (shape instanceof SmoothVoronoiCellShape) {
            outputArea = ((SmoothVoronoiCellShape)shape).getArea();
        } else if (shape instanceof Rectangle2D) {
            Rectangle2D rectangle = (Rectangle2D)shape;
            outputArea = rectangle.getWidth() * rectangle.getHeight();
        } else if (shape instanceof Ellipse2D) {
            Rectangle2D bounds = shape.getBounds2D();
            outputArea = Math.PI * bounds.getWidth() * bounds.getHeight() / 4.0;
        } else {
            outputArea = shape instanceof Polygon ? Double.valueOf(VoronoiAlgorithm.calculatePolygonArea((Polygon)shape)) : (shape instanceof Path2D ? Double.valueOf(AbstractLabeling.getArea((Shape)shape)) : Double.valueOf(AbstractLabeling.getArea((Shape)shape)));
        }
        assert (outputArea != null) : shape;
        return outputArea;
    }

    private void adjustWeightSud(VoronoiCell cell, double delta) {
        double currentWeight = cell.getWeight();
        if (currentWeight > -delta) {
            currentWeight = -delta;
        }
        double desiredArea = cell.getDesiredNormalizedArea();
        double normalizedArea = cell.getCurrentNormalizedArea();
        double weight = currentWeight + Math.abs(currentWeight) * (desiredArea - normalizedArea) / desiredArea;
        cell.setWeight(weight);
    }

    private void adjustWeightAW(VoronoiCell cell, double delta) {
        double currentWeight = cell.getWeight();
        if (Math.abs(currentWeight) < delta) {
            currentWeight = Math.signum(currentWeight) * delta;
        }
        double desiredNormalizedArea = cell.getDesiredNormalizedArea();
        double currentNormalizedArea = cell.getCurrentNormalizedArea();
        double weight = currentWeight + Math.abs(currentWeight) * (desiredNormalizedArea - currentNormalizedArea) / desiredNormalizedArea;
        cell.setWeight(weight);
    }

    private void adjustWeightPW(VoronoiCell cell) {
        double normalizedArea;
        double currentWeight = cell.getWeight();
        double desiredArea = cell.getDesiredNormalizedArea();
        if ((currentWeight *= 1.0 + (desiredArea - (normalizedArea = cell.getCurrentNormalizedArea())) / desiredArea) < 0.01) {
            currentWeight = 0.01;
        }
        cell.setWeight(currentWeight);
    }

    private double getDistance(VoronoiCell cell, int x, int y) {
        double distance;
        Point2d center = cell.getPosition();
        double deltaX = center.x - (double)x;
        double deltaY = center.y - (double)y;
        double distanceSquared = deltaX * deltaX + deltaY * deltaY;
        switch (this.weightType.ordinal()) {
            case 1: {
                distance = distanceSquared;
                break;
            }
            default: {
                distance = Math.sqrt(distanceSquared);
            }
        }
        return distance - cell.getWeight();
    }

    private void computeVoronoiTessellation(final VoronoiOutputRaster voronoiOutputRaster, final VoronoiCell[] cells, Shape domain) {
        for (VoronoiCell cell : cells) {
            cell.resetCellShapeData();
        }
        final Rectangle domainBounds = domain.getBounds();
        int nRows = domainBounds.height;
        if (domainBounds.width <= 0 || nRows <= 0) {
            return;
        }
        int nTasks = Math.min(this.nAvailableProcessors, nRows);
        int nRowsPerTask = nRows / nTasks;
        ArrayList<1> todo = new ArrayList<1>(nTasks);
        for (int nTask = 0; nTask < nTasks; ++nTask) {
            final int fromRow = nTask * nRowsPerTask;
            final int toRow = nTask < nTasks - 1 ? fromRow + nRowsPerTask : nRows;
            todo.add(new Callable<Object>(){
                private int from;
                private int to;
                {
                    this.from = fromRow;
                    this.to = toRow;
                }

                @Override
                public Object call() throws Exception {
                    if (cells.length == 0) {
                        return null;
                    }
                    for (int x = domainBounds.x; x < domainBounds.x + domainBounds.width; ++x) {
                        for (int y = domainBounds.y + this.from; y < domainBounds.y + this.to; ++y) {
                            if (voronoiOutputRaster.get(x, y) == VoronoiCell.outsideDomainCell) continue;
                            VoronoiCell minimumDistanceCell = cells[0];
                            double minimumDistance = VoronoiAlgorithm.this.getDistance(minimumDistanceCell, x, y);
                            if (cells.length > 1) {
                                for (int nCell = 1; nCell < cells.length; ++nCell) {
                                    VoronoiCell cell = cells[nCell];
                                    double accurateDistance = VoronoiAlgorithm.this.getDistance(cell, x, y);
                                    if (!(accurateDistance < minimumDistance)) continue;
                                    minimumDistanceCell = cell;
                                    minimumDistance = accurateDistance;
                                }
                            }
                            voronoiOutputRaster.set(x, y, minimumDistanceCell);
                            minimumDistanceCell.addPixelForAreaAndCenterOfMassDetermination(x, y);
                        }
                    }
                    return null;
                }
            });
        }
        try {
            List answers = this.executor.invokeAll(todo);
            for (Future answer : answers) {
                try {
                    answer.get();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (ExecutionException e) {
                    e.getCause().printStackTrace();
                }
            }
        }
        catch (InterruptedException answers) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void moveGenerators(VoronoiCell[] cells, Shape shape) {
        for (VoronoiCell cell : cells) {
            if (cell.getCurrentArea() <= 0) continue;
            Point2d centerOfMass = cell.getCenterOfMass();
            if ((!(shape instanceof Rectangle2D) || !shape.getBounds().contains(centerOfMass.x, centerOfMass.y)) && !shape.contains((Point2D)new Point2D.Double(centerOfMass.x, centerOfMass.y))) continue;
            cell.setPosition(centerOfMass);
        }
        double factorWeight = Double.MAX_VALUE;
        for (int i = 0; i < cells.length; ++i) {
            for (int j = i + 1; j < cells.length; ++j) {
                Point2d pJ;
                Point2d pI = cells[i].getPosition();
                double f = pI.distanceSquared(pJ = cells[j].getPosition()) / (cells[i].getWeight() + cells[j].getWeight()) * 0.1;
                if (!(0.0 < f) || !(f < factorWeight)) continue;
                factorWeight = f;
            }
        }
        if (factorWeight < 1.0) {
            for (VoronoiCell cell : cells) {
                cell.weight *= factorWeight;
            }
        }
    }

    private void initializePositions(VoronoiCell[] cells, Shape shape, double domainArea) {
        double averageAreaPerCell = domainArea / (double)cells.length;
        Rectangle bounds = shape.getBounds();
        ArrayList<Point2d> usedPositions = new ArrayList<Point2d>();
        int minimalDistanceSquaredAllowed = (int)(Math.sqrt(averageAreaPerCell) / 2.0);
        int maxIterationsPerCell = 10000;
        for (VoronoiCell cell : cells) {
            int y;
            int x;
            boolean positionFound = false;
            maxIterationsPerCell = 10000;
            int nIterations = 0;
            do {
                x = (int)(this.random.nextDouble() * (double)bounds.width + (double)bounds.x);
                y = (int)(this.random.nextDouble() * (double)bounds.height + (double)bounds.y);
                if ((!(shape instanceof Rectangle2D) || !bounds.contains((double)x, (double)y)) && !shape.contains((Point2D)new Point2D.Double((double)x, (double)y))) continue;
                boolean tooSmallDistanceFound = false;
                for (Point2d position : usedPositions) {
                    if (!(position.getDistanceSquared(x, y) < (double)minimalDistanceSquaredAllowed)) continue;
                    tooSmallDistanceFound = true;
                    break;
                }
                boolean bl = positionFound = !tooSmallDistanceFound;
            } while (nIterations++ < maxIterationsPerCell && !positionFound);
            cell.setPosition(x, y);
            usedPositions.add(new Point2d(x, y));
        }
    }

    public static double calculatePolygonArea(Polygon polygon) {
        double sum = 0.0;
        for (int i = 0; i < polygon.npoints; ++i) {
            int iPlus1 = i + 1;
            if (iPlus1 == polygon.npoints) {
                iPlus1 = 0;
            }
            sum += (double)(polygon.xpoints[i] * polygon.ypoints[iPlus1] - polygon.xpoints[iPlus1] * polygon.ypoints[i]);
        }
        double outputArea = Math.abs(sum / 2.0);
        return outputArea;
    }

    public boolean isCompatible(Shape shape) {
        return true;
    }

    public boolean isSpaceFilling() {
        return false;
    }

    String getName() {
        return "Voronoi";
    }

    public String toString() {
        return this.getName();
    }

    public static enum WeightType {
        AW,
        PW;

    }
}

