/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing.voronoi;

import com.macrofocus.geom.Polygon;
import com.treemap.MutableTreeMapNode;
import com.treemap.swing.voronoi.Point2d;
import com.treemap.swing.voronoi.smoothing.LineSegment;
import java.util.ArrayList;
import java.util.List;

public class VoronoiCell
implements Comparable<VoronoiCell> {
    private int yMax = 0;
    private double desiredNormalizedArea;
    private int currentArea;
    private final Point2d position = new Point2d();
    public double weight;
    private double currentNormalizedArea;
    private long xValueSum = 0L;
    private long yValueSum = 0L;
    private final Point2d centerOfMass = new Point2d();
    private int xMin = Integer.MAX_VALUE;
    private int xMax = 0;
    private int yMin = Integer.MAX_VALUE;
    private final MutableTreeMapNode child;
    private final MutableTreeMapNode parent;
    private double errorAbsolute;
    private final List<LineSegment> lineSegments = new ArrayList<LineSegment>();
    private Polygon polygon;
    public static final VoronoiCell outsideDomainCell = new VoronoiCell(1.0, null, null);

    public VoronoiCell(double desiredNormalizedArea, MutableTreeMapNode child, MutableTreeMapNode parent) {
        this.desiredNormalizedArea = desiredNormalizedArea;
        this.child = child;
        this.parent = parent;
        this.weight = 1.0;
    }

    public void scale(double scale) {
        this.desiredNormalizedArea *= scale;
        this.position.scale(scale);
        this.xValueSum = (long)(scale * (double)this.xValueSum);
        this.yValueSum = (long)(scale * (double)this.yValueSum);
        this.centerOfMass.scale(scale);
        this.xMin = (int)(scale * (double)this.xMin);
        this.xMax = (int)(scale * (double)this.xMax);
        this.yMin = (int)(scale * (double)this.yMin);
        this.yMax = (int)(scale * (double)this.yMax);
    }

    public int getCurrentArea() {
        return this.currentArea;
    }

    public double getDesiredNormalizedArea() {
        return this.desiredNormalizedArea;
    }

    public Point2d getPosition() {
        return this.position;
    }

    public double getWeight() {
        return this.weight;
    }

    public void setPosition(int x, int y) {
        this.position.set(x, y);
    }

    public void setPosition(Point2d position) {
        this.position.set(position);
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    public void setCurrentNormalizedArea(double currentNormalizedArea) {
        this.currentNormalizedArea = currentNormalizedArea;
    }

    public double getCurrentNormalizedArea() {
        return this.currentNormalizedArea;
    }

    public synchronized void addPixelForAreaAndCenterOfMassDetermination(int x, int y) {
        ++this.currentArea;
        this.xMin = Math.min(x, this.xMin);
        this.xMax = Math.max(x, this.xMax);
        this.yMin = Math.min(y, this.yMin);
        this.yMax = Math.max(y, this.yMax);
        this.xValueSum += (long)x;
        this.yValueSum += (long)y;
    }

    public void resetCellShapeData() {
        this.xValueSum = 0L;
        this.yValueSum = 0L;
        this.xMin = Integer.MAX_VALUE;
        this.xMax = 0;
        this.yMin = Integer.MAX_VALUE;
        this.yMax = 0;
        this.currentArea = 0;
    }

    public Point2d getCenterOfMass() {
        this.centerOfMass.x = (double)this.xValueSum / (double)this.currentArea;
        this.centerOfMass.y = (double)this.yValueSum / (double)this.currentArea;
        return this.centerOfMass;
    }

    public MutableTreeMapNode getChild() {
        return this.child;
    }

    public void set(VoronoiCell cell) {
        this.currentArea = cell.currentArea;
        this.centerOfMass.set(cell.centerOfMass);
        this.desiredNormalizedArea = cell.desiredNormalizedArea;
        this.currentNormalizedArea = cell.currentNormalizedArea;
        this.position.set(cell.position);
        this.weight = cell.weight;
        this.xMax = cell.xMax;
        this.xMin = cell.xMin;
        this.xValueSum = cell.xValueSum;
        this.yMax = cell.yMax;
        this.yMin = cell.yMin;
        this.yValueSum = cell.yValueSum;
    }

    public void setErrorAbsolute(double errorAbsolute) {
        this.errorAbsolute = errorAbsolute;
    }

    public double getErrorAbsolute() {
        return this.errorAbsolute;
    }

    public void setLineSegments(List<LineSegment> lineSegments) {
        this.lineSegments.clear();
        this.lineSegments.addAll(lineSegments);
    }

    public void setPolygon(Polygon polygon) {
        this.polygon = polygon;
    }

    public Polygon getPolygon() {
        return this.polygon;
    }

    @Override
    public int compareTo(VoronoiCell o) {
        return Double.compare(this.currentArea, o.currentArea);
    }

    public String toString() {
        if (this != outsideDomainCell) {
            return String.format("%s, A=%d, desired A=%.3e, normalizedA=%.3e, weight=%.3e", this.child.toString(), this.currentArea, this.desiredNormalizedArea, this.currentNormalizedArea, this.weight);
        }
        return "Outside Domain Cell";
    }

    public MutableTreeMapNode getParent() {
        return this.parent;
    }
}

