/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.fields;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.web3d.x3d.jsail.ConfigurationProperties;
import org.web3d.x3d.jsail.fields.SFDouble;
import org.web3d.x3d.jsail.fields.X3DConcreteField;
import org.web3d.x3d.sai.InvalidFieldValueException;

public class MFDouble
extends X3DConcreteField
implements org.web3d.x3d.sai.MFDouble {
    public static final String NAME = "MFDouble";
    public static final double[] DEFAULT_VALUE = new double[0];
    public static final String DEFAULT_VALUE_STRING = "";
    public static final int TUPLE_SIZE = 1;
    public static final String REGEX = "(\\s)*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*";
    public static final Pattern PATTERN = Pattern.compile("(\\s)*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*");
    private static boolean priorRegexStackOverflowFound = false;
    private double[] MFDouble = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);

    public static final boolean isArray() {
        return true;
    }

    public MFDouble() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        this.MFDouble = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
    }

    public boolean equals(MFDouble comparisonMFDouble) {
        return this.getPrimitiveValue() == comparisonMFDouble.getPrimitiveValue();
    }

    public final String validate() {
        MFDouble tempHold = new MFDouble(this.getPrimitiveValue());
        if (!this.equals(tempHold)) {
            return "MFDouble validate() error: failed get/set round-trip test";
        }
        return DEFAULT_VALUE_STRING;
    }

    public final String validateRegex() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            if (!m.matches()) {
                String errorNotice = "*** Regular expression (regex) failure, new MFDouble PATTERN mismatch (\"" + this.toString() + "\")";
                return errorNotice;
            }
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for MFDouble array";
            validationResult.append(validationMessage).append("\n");
            System.out.println("*** " + validationMessage);
            return validationMessage;
        }
        return DEFAULT_VALUE_STRING;
    }

    public final boolean matches() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            return m.matches();
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for MFDouble array";
            validationResult.append(validationMessage).append("\n");
            System.out.println("*** " + validationMessage);
            return false;
        }
    }

    public static final boolean matches(String value) {
        Matcher m = PATTERN.matcher(value);
        return m.matches();
    }

    public MFDouble setValueByString(String newValue) throws InvalidFieldValueException {
        if (newValue == null) {
            newValue = new String();
        }
        if (!org.web3d.x3d.jsail.fields.MFDouble.matches(newValue)) {
            String errorNotice = "*** Regular expression (regex) failure, new MFDouble(" + newValue + ")";
            validationResult.append(errorNotice).append("\n");
        }
        if (newValue.trim().isEmpty()) {
            this.MFDouble = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        try {
            String[] newValues = newValue.replace(",", " ").trim().split("\\s+");
            this.MFDouble = new double[newValues.length];
            for (int i = 0; i < newValues.length; ++i) {
                this.MFDouble[i] = Double.parseDouble(newValues[i]);
            }
        }
        catch (NumberFormatException e) {
            String errorNotice = "new MFDouble(" + newValue + ") " + e.getMessage();
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        return this;
    }

    public MFDouble(double newValue) {
        this.setValue(new SFDouble(newValue));
    }

    public MFDouble(SFDouble newValue) {
        if (newValue == null) {
            this.MFDouble = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return;
        }
        this.MFDouble = new double[1];
        this.MFDouble[0] = newValue.getValue();
    }

    public MFDouble(MFDouble newValue) {
        if (newValue == null) {
            this.MFDouble = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return;
        }
        this.MFDouble = newValue.getPrimitiveValue();
    }

    public MFDouble(double[] newValue) {
        if (newValue == null) {
            newValue = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
        }
        this.MFDouble = newValue;
    }

    public MFDouble(float newValue) {
        this.setValue(new SFDouble(newValue));
    }

    public MFDouble(float[] newValue) {
        this.setValue(newValue);
    }

    public static String toString(double[] value) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < value.length; ++i) {
            if (ConfigurationProperties.isStripTrailingZeroes()) {
                result.append(SFDouble.stripTrailingZeroes(value[i])).append(" ");
                continue;
            }
            result.append(value[i]).append(" ");
        }
        return result.toString().trim();
    }

    @Override
    public void getValue(double[] valueDestination) {
        valueDestination = this.MFDouble;
    }

    public double[] getPrimitiveValue() {
        return this.MFDouble;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.MFDouble.length; ++i) {
            if (ConfigurationProperties.isStripTrailingZeroes()) {
                result.append(SFDouble.stripTrailingZeroes(this.MFDouble[i]));
            } else {
                result.append(this.MFDouble[i]);
            }
            if (i >= this.MFDouble.length - 1) continue;
            result.append(" ");
        }
        return result.toString();
    }

    @Override
    public double get1Value(int index) {
        if (index < 0) {
            String errorNotice = "Index value is negative, thus cannot get1Value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (this.MFDouble.length == 0) {
            String errorNotice = "Value array is empty, thus cannot get1Value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (index >= this.MFDouble.length / 1) {
            String errorNotice = "Provided array index=" + index + " must be less than MFDouble array length=" + this.MFDouble.length / 1;
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        return this.MFDouble[index];
    }

    @Override
    public void setValue(int size, double[] newValue) {
        if (newValue == null) {
            throw new InvalidFieldValueException(" newValue is null and cannot be set");
        }
        if (size < 0) {
            throw new InvalidFieldValueException("requested setValue() array-copy size=" + size + " is negative");
        }
        if (size > newValue.length) {
            throw new InvalidFieldValueException("requested setValue() array-copy size=" + size + " is greater than newValue.length()=" + newValue.length);
        }
        this.MFDouble = Arrays.copyOf(newValue, size);
    }

    public void setValue(double[] newValue) {
        if (newValue == null) {
            newValue = new double[]{};
        }
        this.MFDouble = new double[newValue.length];
        this.MFDouble = newValue;
    }

    public MFDouble setValue(float[] newValue) {
        if (newValue == null) {
            newValue = new float[]{};
        }
        this.MFDouble = new double[newValue.length];
        for (int i = 0; i < newValue.length; ++i) {
            this.MFDouble[i] = newValue[i];
        }
        return this;
    }

    public void setValue(double newValue) {
        this.MFDouble = new double[1];
        this.MFDouble[0] = newValue;
    }

    public MFDouble setValue(SFDouble newValue) {
        if (newValue == null) {
            this.MFDouble = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        this.MFDouble = new double[1];
        this.MFDouble[0] = newValue.getValue();
        return this;
    }

    @Override
    public void set1Value(int index, double newValue) throws ArrayIndexOutOfBoundsException {
        if (index < 0) {
            String errorNotice = "Index value is negative, thus cannot set1Value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (this.MFDouble.length == 0) {
            String errorNotice = "Value array is empty, thus cannot set1Value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (index >= this.MFDouble.length / 1) {
            String errorNotice = "Provided array index=" + index + " must be less than MFDouble array length=" + this.MFDouble.length / 1;
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        this.MFDouble[index] = newValue;
    }

    @Override
    public void append(double newValue) {
        this.MFDouble = Arrays.copyOf(this.MFDouble, this.MFDouble.length + 1);
        this.MFDouble[this.MFDouble.length - 1] = newValue;
    }

    public void append(double[] newValue) {
        if (newValue.length % 1 != 0) {
            String errorNotice = "illegal number of values (" + newValue.length + ") in initialization array, must be multiple of 4 when declaring new MFVec4f(" + newValue + ")";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        int originalLength = this.MFDouble.length;
        this.MFDouble = Arrays.copyOf(this.MFDouble, this.MFDouble.length + newValue.length);
        for (int i = 0; i < newValue.length; ++i) {
            this.MFDouble[originalLength + i] = newValue[i];
        }
    }

    public MFDouble append(SFDouble newValue) {
        this.append(newValue.getPrimitiveValue());
        return this;
    }

    public MFDouble append(MFDouble newValue) {
        this.append(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public void insertValue(int index, double newValue) {
        if (index < 0) {
            String errorNotice = "Index value is negative, thus cannot insertValue at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (index >= this.MFDouble.length) {
            String errorNotice = "Provided array index=" + index + " must be less than MFDouble array length=" + this.MFDouble.length;
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        int sliceLength = this.MFDouble.length - index;
        this.MFDouble = Arrays.copyOf(this.MFDouble, this.MFDouble.length + 1);
        System.arraycopy(this.MFDouble, index, this.MFDouble, index + 1, sliceLength);
        this.MFDouble[index] = newValue;
    }

    @Override
    public int size() {
        return this.MFDouble.length;
    }

    @Override
    public void clear() {
        this.MFDouble = new double[0];
    }

    @Override
    public void remove(int index) {
        if (index < 0) {
            String errorNotice = "Index value is negative, thus cannot remove() value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (this.MFDouble.length == 0) {
            String errorNotice = "Value array is empty, thus cannot remove value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (index >= this.MFDouble.length) {
            String errorNotice = "Provided array index=" + index + " must be less than MFDouble array length=" + this.MFDouble.length;
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        int offsetLength = this.MFDouble.length - (index + 1) * 1;
        System.arraycopy(this.MFDouble, (index + 1) * 1, this.MFDouble, index * 1, offsetLength);
        this.MFDouble = Arrays.copyOfRange(this.MFDouble, 0, this.MFDouble.length - 1);
    }

    public double[] toDoubleArray() {
        return this.MFDouble;
    }

    public MFDouble setValue(MFDouble newValue) {
        if (newValue == null) {
            this.MFDouble = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        this.MFDouble = newValue.getPrimitiveValue();
        return this;
    }

    public MFDouble multiply(double scaleFactor) {
        int i = 0;
        while (i < this.MFDouble.length) {
            int n = i++;
            this.MFDouble[n] = this.MFDouble[n] * scaleFactor;
        }
        return this;
    }

    public boolean isDefaultValue() {
        return Arrays.equals(this.MFDouble, DEFAULT_VALUE);
    }

    static {
        try {
            Pattern.compile(REGEX);
            if (!new MFDouble(DEFAULT_VALUE).matches()) {
                System.out.println("MFDouble.initialize() problem: failed to match DEFAULT_VALUE=" + Arrays.toString(DEFAULT_VALUE));
            }
        }
        catch (PatternSyntaxException exception) {
            System.out.println("Exception in MFDouble initialization testing, regex pattern compilation failure.");
            System.out.println("REGEX=\"(\\s)*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*\"");
            System.out.println(exception.getDescription());
        }
    }
}

