/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.fields;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.web3d.x3d.jsail.ConfigurationProperties;
import org.web3d.x3d.jsail.fields.SFDouble;
import org.web3d.x3d.jsail.fields.SFTime;
import org.web3d.x3d.jsail.fields.X3DConcreteField;
import org.web3d.x3d.sai.InvalidFieldValueException;

public class MFTime
extends X3DConcreteField
implements org.web3d.x3d.sai.MFTime {
    public static final String NAME = "MFTime";
    public static final double[] DEFAULT_VALUE = new double[0];
    public static final String DEFAULT_VALUE_STRING = "";
    public static final int TUPLE_SIZE = 1;
    public static final String REGEX = "(\\s)*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*";
    public static final Pattern PATTERN = Pattern.compile("(\\s)*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*");
    private static boolean priorRegexStackOverflowFound = false;
    private double[] MFTime = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);

    public static final boolean isArray() {
        return true;
    }

    public MFTime() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        this.MFTime = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
    }

    public boolean equals(MFTime comparisonMFTime) {
        return this.getPrimitiveValue() == comparisonMFTime.getPrimitiveValue();
    }

    public final String validate() {
        MFTime tempHold = new MFTime(this.getPrimitiveValue());
        if (!this.equals(tempHold)) {
            return "MFTime validate() error: failed get/set round-trip test";
        }
        return DEFAULT_VALUE_STRING;
    }

    public final String validateRegex() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            if (!m.matches()) {
                String errorNotice = "*** Regular expression (regex) failure, new MFTime PATTERN mismatch (\"" + this.toString() + "\")";
                return errorNotice;
            }
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for MFTime array";
            validationResult.append(validationMessage).append("\n");
            System.out.println("*** " + validationMessage);
            return validationMessage;
        }
        return DEFAULT_VALUE_STRING;
    }

    public final boolean matches() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            return m.matches();
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for MFTime array";
            validationResult.append(validationMessage).append("\n");
            System.out.println("*** " + validationMessage);
            return false;
        }
    }

    public static final boolean matches(String value) {
        Matcher m = PATTERN.matcher(value);
        return m.matches();
    }

    public MFTime setValueByString(String newValue) throws InvalidFieldValueException {
        if (newValue == null) {
            newValue = new String();
        }
        if (!org.web3d.x3d.jsail.fields.MFTime.matches(newValue)) {
            String errorNotice = "*** Regular expression (regex) failure, new MFTime(" + newValue + ")";
            validationResult.append(errorNotice).append("\n");
        }
        if (newValue.trim().isEmpty()) {
            this.MFTime = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        try {
            String[] newValues = newValue.replace(",", " ").trim().split("\\s+");
            if (newValues.length % 1 != 0) {
                String errorNotice = "illegal number of values (" + newValues.length + ") in initialization string, must be multiple of 1 when declaring new MFTime(" + newValue + ")";
                validationResult.append(errorNotice).append("\n");
                throw new InvalidFieldValueException(errorNotice);
            }
            this.MFTime = new double[newValues.length];
            for (int i = 0; i < newValues.length; ++i) {
                this.MFTime[i] = Double.parseDouble(newValues[i]);
                if (!(this.MFTime[i] < 0.0) || this.MFTime[i] == -1.0) continue;
                this.MFTime[i] = -1.0;
            }
        }
        catch (NumberFormatException e) {
            String errorNotice = "new MFTime(" + newValue + ") " + e.getMessage();
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        return this;
    }

    public MFTime(double newValue) {
        this.setValue(new SFTime(newValue));
    }

    public MFTime(SFTime newValue) {
        if (newValue == null) {
            this.MFTime = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return;
        }
        this.MFTime = new double[1];
        this.MFTime[0] = newValue.getValue();
    }

    public MFTime(MFTime newValue) {
        if (newValue == null) {
            this.MFTime = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return;
        }
        this.MFTime = newValue.getPrimitiveValue();
    }

    public MFTime(double[] newValue) {
        if (newValue == null) {
            newValue = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
        }
        for (int i = 0; i < newValue.length; ++i) {
            if (!(newValue[i] < 0.0) || newValue[i] == -1.0) continue;
            newValue[i] = -1.0;
        }
        this.MFTime = newValue;
    }

    public MFTime(float newValue) {
        this.setValue(newValue);
    }

    public MFTime(float[] newValue) {
        this.setValue(newValue);
    }

    public static String toString(double[] value) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < value.length; ++i) {
            if (ConfigurationProperties.isStripTrailingZeroes()) {
                result.append(SFDouble.stripTrailingZeroes(value[i])).append(" ");
                continue;
            }
            result.append(value[i]).append(" ");
        }
        return result.toString().trim();
    }

    @Override
    public void getValue(double[] valueDestination) {
        valueDestination = this.MFTime;
    }

    public double[] getPrimitiveValue() {
        return this.MFTime;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.MFTime.length; ++i) {
            if (ConfigurationProperties.isStripTrailingZeroes()) {
                result.append(SFDouble.stripTrailingZeroes(this.MFTime[i]));
            } else {
                result.append(this.MFTime[i]);
            }
            if (i >= this.MFTime.length - 1) continue;
            result.append(" ");
        }
        return result.toString();
    }

    @Override
    public double get1Value(int index) {
        if (index < 0) {
            String errorNotice = "Index value is negative, thus cannot get1Value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (this.MFTime.length == 0) {
            String errorNotice = "Value array is empty, thus cannot get1Value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (index >= this.MFTime.length / 1) {
            String errorNotice = "Provided array index=" + index + " must be less than MFTime array length=" + this.MFTime.length / 1;
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        return this.MFTime[index];
    }

    @Override
    public void setValue(int size, double[] newValue) {
        if (newValue == null) {
            throw new InvalidFieldValueException(" newValue is null and cannot be set");
        }
        if (size < 0) {
            throw new InvalidFieldValueException("requested setValue() array-copy size=" + size + " is negative");
        }
        if (size > newValue.length) {
            throw new InvalidFieldValueException("requested setValue() array-copy size=" + size + " is greater than newValue.length()=" + newValue.length);
        }
        for (int i = 0; i < newValue.length; ++i) {
            if (!(newValue[i] < 0.0) || newValue[i] == -1.0) continue;
            newValue[i] = -1.0;
        }
        this.MFTime = Arrays.copyOf(newValue, size);
    }

    public void setValue(double[] newValue) {
        if (newValue == null) {
            newValue = new double[]{};
        }
        for (int i = 0; i < newValue.length; ++i) {
            if (!(newValue[i] < 0.0) || newValue[i] == -1.0) continue;
            newValue[i] = -1.0;
        }
        this.MFTime = new double[newValue.length];
        this.MFTime = newValue;
    }

    public void setValue(double newValue) {
        if (newValue < 0.0 && newValue != -1.0) {
            newValue = -1.0;
        }
        this.MFTime = new double[1];
        this.MFTime[0] = newValue;
    }

    public MFTime setValue(SFTime newValue) {
        if (newValue == null) {
            this.MFTime = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        this.MFTime = new double[1];
        this.MFTime[0] = newValue.getValue();
        return this;
    }

    @Override
    public void set1Value(int index, double newValue) throws ArrayIndexOutOfBoundsException {
        if (index < 0) {
            String errorNotice = "Index value is negative, thus cannot set1Value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (this.MFTime.length == 0) {
            String errorNotice = "Value array is empty, thus cannot set1Value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (index >= this.MFTime.length / 1) {
            String errorNotice = "Provided array index=" + index + " must be less than MFTime array length=" + this.MFTime.length / 1;
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (newValue < 0.0 && newValue != -1.0) {
            newValue = -1.0;
        }
        this.MFTime[index] = newValue;
    }

    @Override
    public void append(double newValue) {
        if (newValue < 0.0 && newValue != -1.0) {
            newValue = -1.0;
        }
        this.MFTime = Arrays.copyOf(this.MFTime, this.MFTime.length + 1);
        this.MFTime[this.MFTime.length - 1] = newValue;
    }

    public void append(double[] newValue) {
        if (newValue.length % 1 != 0) {
            String errorNotice = "illegal number of values (" + newValue.length + ") in initialization array, must be multiple of 4 when declaring new MFVec4f(" + newValue + ")";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        int originalLength = this.MFTime.length;
        this.MFTime = Arrays.copyOf(this.MFTime, this.MFTime.length + newValue.length);
        for (int i = 0; i < newValue.length; ++i) {
            this.MFTime[originalLength + i] = newValue[i];
        }
    }

    public MFTime append(SFTime newValue) {
        this.append(newValue.getPrimitiveValue());
        return this;
    }

    public MFTime append(MFTime newValue) {
        this.append(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public void insertValue(int index, double newValue) {
        if (index < 0) {
            String errorNotice = "Index value is negative, thus cannot insertValue at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (index >= this.MFTime.length) {
            String errorNotice = "Provided array index=" + index + " must be less than MFTime array length=" + this.MFTime.length;
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (newValue < 0.0 && newValue != -1.0) {
            newValue = -1.0;
        }
        int sliceLength = this.MFTime.length - index;
        this.MFTime = Arrays.copyOf(this.MFTime, this.MFTime.length + 1);
        System.arraycopy(this.MFTime, index, this.MFTime, index + 1, sliceLength);
        this.MFTime[index] = newValue;
    }

    @Override
    public void append(long newValue) {
        if (newValue < 0L && (double)newValue != -1.0) {
            this.append(-1.0);
        } else {
            this.append((double)newValue);
        }
    }

    @Override
    public void insertValue(int index, long newValue) {
        if (newValue < 0L && (double)newValue != -1.0) {
            this.insertValue(index, -1.0);
        } else {
            this.insertValue(index, (double)newValue);
        }
    }

    @Override
    public void set1Value(int index, long newValue) throws ArrayIndexOutOfBoundsException {
        if (newValue < 0L && (double)newValue != -1.0) {
            this.set1Value(index, -1.0);
        } else {
            this.set1Value(index, (double)newValue);
        }
    }

    @Override
    public void setValue(int index, long[] newValue) throws ArrayIndexOutOfBoundsException {
        double[] doubleTimeValues = new double[newValue.length];
        for (int i = 0; i < newValue.length; ++i) {
            doubleTimeValues[i] = newValue[i] < 0L && (double)newValue[i] != -1.0 ? -1.0 : (double)newValue[i];
        }
        this.setValue(index, doubleTimeValues);
    }

    @Override
    public int size() {
        return this.MFTime.length;
    }

    @Override
    public void clear() {
        this.MFTime = new double[0];
    }

    @Override
    public void remove(int index) {
        if (index < 0) {
            String errorNotice = "Index value is negative, thus cannot remove() value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (this.MFTime.length == 0) {
            String errorNotice = "Value array is empty, thus cannot remove value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (index >= this.MFTime.length) {
            String errorNotice = "Provided array index=" + index + " must be less than MFTime array length=" + this.MFTime.length;
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        int offsetLength = this.MFTime.length - (index + 1) * 1;
        System.arraycopy(this.MFTime, (index + 1) * 1, this.MFTime, index * 1, offsetLength);
        this.MFTime = Arrays.copyOfRange(this.MFTime, 0, this.MFTime.length - 1);
    }

    @Override
    public long get1JavaValue(int index) {
        if (index < 0) {
            String errorNotice = "Index value is negative, thus cannot get1JavaValue at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        return (long)this.MFTime[index];
    }

    @Override
    public void setValue(long[] newValue) {
        if (newValue == null) {
            throw new InvalidFieldValueException(" newValue is null and cannot be set");
        }
        this.MFTime = new double[newValue.length];
        for (int i = 0; i < newValue.length; ++i) {
            this.MFTime[i] = newValue[i] < 0L && (double)newValue[i] != -1.0 ? -1.0 : (double)newValue[i];
        }
    }

    public MFTime setValue(float newValue) {
        this.setValue((double)newValue);
        return this;
    }

    public MFTime setValue(float[] newValue) {
        if (newValue == null) {
            this.initialize();
        } else {
            double[] doubleArray = new double[newValue.length];
            for (int i = 0; i < newValue.length; ++i) {
                doubleArray[i] = newValue[i];
            }
            this.setValue(doubleArray);
        }
        return this;
    }

    public double[] toDoubleArray() {
        return this.MFTime;
    }

    public MFTime setValue(MFTime newValue) {
        if (newValue == null) {
            this.MFTime = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        this.MFTime = newValue.getPrimitiveValue();
        return this;
    }

    public boolean isDefaultValue() {
        return Arrays.equals(this.MFTime, DEFAULT_VALUE);
    }

    static {
        try {
            Pattern.compile(REGEX);
            if (!new MFTime(DEFAULT_VALUE).matches()) {
                System.out.println("MFTime.initialize() problem: failed to match DEFAULT_VALUE=" + Arrays.toString(DEFAULT_VALUE));
            }
        }
        catch (PatternSyntaxException exception) {
            System.out.println("Exception in MFTime initialization testing, regex pattern compilation failure.");
            System.out.println("REGEX=\"(\\s)*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*\"");
            System.out.println(exception.getDescription());
        }
    }
}

