/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.fields;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.web3d.x3d.jsail.ConfigurationProperties;
import org.web3d.x3d.jsail.fields.SFDouble;
import org.web3d.x3d.jsail.fields.X3DConcreteField;
import org.web3d.x3d.sai.InvalidFieldValueException;
import org.web3d.x3d.sai.Matrix3;
import org.web3d.x3d.sai.SFRotation;
import org.web3d.x3d.sai.SFVec3d;

public class SFMatrix3d
extends X3DConcreteField
implements org.web3d.x3d.sai.SFMatrix3d {
    public static final String NAME = "SFMatrix3d";
    public static final double[] DEFAULT_VALUE = new double[]{1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0};
    public static final String DEFAULT_VALUE_STRING = "1 0 0 0 1 0 0 0 1";
    public static final int TUPLE_SIZE = 9;
    public static final String REGEX = "\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){8}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*";
    public static final Pattern PATTERN = Pattern.compile("\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){8}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*");
    private static boolean priorRegexStackOverflowFound = false;
    private double[] SFMatrix3d = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);

    public static final boolean isArray() {
        return false;
    }

    public SFMatrix3d() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        this.SFMatrix3d = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
    }

    public boolean equals(SFMatrix3d comparisonSFMatrix3d) {
        return this.getPrimitiveValue() == comparisonSFMatrix3d.getPrimitiveValue();
    }

    public final String validate() {
        SFMatrix3d tempHold = new SFMatrix3d(this.getPrimitiveValue());
        if (!this.equals(tempHold)) {
            return "SFMatrix3d validate() error: failed get/set round-trip test";
        }
        return "";
    }

    public final String validateRegex() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            if (!m.matches()) {
                String errorNotice = "*** Regular expression (regex) failure, new SFMatrix3d PATTERN mismatch (\"" + this.toString() + "\")";
                return errorNotice;
            }
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for SFMatrix3d";
            validationResult.append(validationMessage).append("\n");
            System.out.println("*** " + validationMessage);
            return validationMessage;
        }
        return "";
    }

    public final boolean matches() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            return m.matches();
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for SFMatrix3d";
            validationResult.append(validationMessage).append("\n");
            System.out.println("*** " + validationMessage);
            return false;
        }
    }

    public static final boolean matches(String value) {
        Matcher m = PATTERN.matcher(value);
        return m.matches();
    }

    public SFMatrix3d setValueByString(String newValue) throws InvalidFieldValueException {
        if (newValue == null) {
            newValue = new String();
        }
        if (!org.web3d.x3d.jsail.fields.SFMatrix3d.matches(newValue)) {
            String errorNotice = "*** Regular expression (regex) failure, new SFMatrix3d(" + newValue + ")";
            validationResult.append(errorNotice).append("\n");
        }
        if (newValue.trim().isEmpty()) {
            this.SFMatrix3d = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        try {
            String[] newValues = newValue.replace(",", " ").trim().split("\\s+");
            if (newValues.length != 9) {
                String errorNotice = "illegal number of values in initialization string, new SFMatrix3d(" + newValue + ")";
                validationResult.append(errorNotice).append("\n");
                throw new InvalidFieldValueException(errorNotice);
            }
            this.SFMatrix3d[0] = Double.parseDouble(newValues[0]);
            this.SFMatrix3d[1] = Double.parseDouble(newValues[1]);
            this.SFMatrix3d[2] = Double.parseDouble(newValues[2]);
            this.SFMatrix3d[3] = Double.parseDouble(newValues[3]);
            this.SFMatrix3d[4] = Double.parseDouble(newValues[4]);
            this.SFMatrix3d[5] = Double.parseDouble(newValues[5]);
            this.SFMatrix3d[6] = Double.parseDouble(newValues[6]);
            this.SFMatrix3d[7] = Double.parseDouble(newValues[7]);
            this.SFMatrix3d[8] = Double.parseDouble(newValues[8]);
        }
        catch (NumberFormatException e) {
            String errorNotice = "new SFMatrix3d(" + newValue + ") " + e.getMessage();
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        return this;
    }

    public SFMatrix3d(SFMatrix3d newValue) {
        if (newValue == null) {
            this.SFMatrix3d = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return;
        }
        this.SFMatrix3d = newValue.getPrimitiveValue();
    }

    public SFMatrix3d(double[] newValue) {
        if (newValue == null) {
            newValue = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
        } else if (newValue.length != 9) {
            String errorNotice = "Illegal SFMatrix3d newValue array length=" + newValue.length + ", must equal 9 or else be empty (newValue=" + org.web3d.x3d.jsail.fields.SFMatrix3d.toString(newValue) + ")";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.SFMatrix3d = newValue;
    }

    public static String toString(double[] value) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < value.length; ++i) {
            if (ConfigurationProperties.isStripTrailingZeroes()) {
                result.append(SFDouble.stripTrailingZeroes(value[i])).append(" ");
                continue;
            }
            result.append(value[i]).append(" ");
        }
        return result.toString().trim();
    }

    public double[] getPrimitiveValue() {
        return this.SFMatrix3d;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.SFMatrix3d.length; ++i) {
            if (ConfigurationProperties.isStripTrailingZeroes()) {
                result.append(SFDouble.stripTrailingZeroes(this.SFMatrix3d[i]));
            } else {
                result.append(this.SFMatrix3d[i]);
            }
            if (i >= this.SFMatrix3d.length - 1) continue;
            result.append(" ");
        }
        return result.toString();
    }

    public SFMatrix3d setValue(double[] newValue) {
        if (newValue == null) {
            this.SFMatrix3d = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        if (newValue.length != 9) {
            String errorNotice = "Illegal array newValue=" + newValue + " must have base length 9 for setValue() on SFMatrix3d";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.SFMatrix3d = newValue;
        return this;
    }

    @Override
    public void setIdentity() {
        this.SFMatrix3d = DEFAULT_VALUE;
    }

    @Override
    public void set(int row, int column) {
    }

    @Override
    public float get(int row, int column) {
        if (row < 0 || row > 4 || column < 0 || column > 4) {
            String errorNotice = "Illegal SFMatrix3d[row=" + row + ",column=" + column + "] access, all values must be in numeric range [0..4]";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        return (float)this.SFMatrix3d[3 * row + column];
    }

    @Override
    public void setTransform(SFVec3d translation, SFRotation rotation, SFVec3d scale, SFRotation scaleOrientation, SFVec3d center) {
    }

    @Override
    public void getTransform(SFVec3d translation, SFRotation rotation, SFVec3d scale) {
    }

    @Override
    public Matrix3 inverse() {
        return null;
    }

    @Override
    public Matrix3 transpose() {
        return null;
    }

    @Override
    public Matrix3 multiplyLeft(Matrix3 matrix3x3) {
        return null;
    }

    @Override
    public Matrix3 multiplyRight(Matrix3 matrix3x3) {
        return null;
    }

    @Override
    public Matrix3 multiplyRowVector(SFVec3d vector3d) {
        return null;
    }

    @Override
    public Matrix3 multiplyColVector(SFVec3d vector3d) {
        return null;
    }

    public double[] toDoubleArray() {
        return this.SFMatrix3d;
    }

    public SFMatrix3d setValue(SFMatrix3d newValue) {
        if (newValue == null) {
            this.SFMatrix3d = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        this.SFMatrix3d = newValue.getPrimitiveValue();
        return this;
    }

    public SFMatrix3d multiply(double scaleFactor) {
        int i = 0;
        while (i < this.SFMatrix3d.length) {
            int n = i++;
            this.SFMatrix3d[n] = this.SFMatrix3d[n] * scaleFactor;
        }
        return this;
    }

    public boolean isDefaultValue() {
        return Arrays.equals(this.SFMatrix3d, DEFAULT_VALUE);
    }

    static {
        try {
            Pattern.compile(REGEX);
            if (!new SFMatrix3d(DEFAULT_VALUE).matches()) {
                System.out.println("SFMatrix3d.initialize() problem: failed to match DEFAULT_VALUE=" + Arrays.toString(DEFAULT_VALUE));
            }
        }
        catch (PatternSyntaxException exception) {
            System.out.println("Exception in SFMatrix3d initialization testing, regex pattern compilation failure.");
            System.out.println("REGEX=\"\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){8}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*\"");
            System.out.println(exception.getDescription());
        }
    }
}

