/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.fields;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.web3d.x3d.jsail.ConfigurationProperties;
import org.web3d.x3d.jsail.fields.SFFloat;
import org.web3d.x3d.jsail.fields.X3DConcreteField;
import org.web3d.x3d.sai.InvalidFieldValueException;

public class SFVec3f
extends X3DConcreteField
implements org.web3d.x3d.sai.SFVec3f {
    public static final String NAME = "SFVec3f";
    public static final float[] DEFAULT_VALUE = new float[]{0.0f, 0.0f, 0.0f};
    public static final String DEFAULT_VALUE_STRING = "0.0 0.0 0.0";
    public static final int TUPLE_SIZE = 3;
    public static final String REGEX = "\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){2}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*";
    public static final Pattern PATTERN = Pattern.compile("\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){2}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*");
    private static boolean priorRegexStackOverflowFound = false;
    public static final float[] DEFAULT_VALUE_BBOXSIZETYPE = new float[]{-1.0f, -1.0f, -1.0f};
    public static final String DEFAULT_VALUE_BBOXSIZETYPE_STRING = "-1 -1 -1";
    public static final String REGEX_BBOXSIZETYPE = "\\s*((([+]?(((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){2}([+]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*)|((\\-1(\\.(0)*)?([Ee][+-]?[0]+)?\\s+){2}\\-1(\\.(0)*)?([Ee][+-]?[0]+)?)\\s*)?";
    public static final Pattern PATTERN_BBOXSIZETYPE = Pattern.compile("\\s*((([+]?(((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){2}([+]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*)|((\\-1(\\.(0)*)?([Ee][+-]?[0]+)?\\s+){2}\\-1(\\.(0)*)?([Ee][+-]?[0]+)?)\\s*)?");
    private float[] SFVec3f = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);

    public static final boolean isArray() {
        return false;
    }

    public final boolean matchesBboxSizeType() {
        try {
            Matcher m = PATTERN_BBOXSIZETYPE.matcher(this.toString());
            return m.matches();
        }
        catch (StackOverflowError soe) {
            if (!priorRegexStackOverflowFound) {
                priorRegexStackOverflowFound = true;
                String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for bboxSizeType";
                validationResult.append(validationMessage).append("\n");
                System.out.println("*** " + validationMessage);
            }
            return false;
        }
    }

    public static final boolean matchesBboxSizeType(String value) {
        try {
            Matcher m = PATTERN_BBOXSIZETYPE.matcher(value);
            return m.matches();
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for bboxSizeType";
            validationResult.append(validationMessage).append("\n");
            System.out.println("*** " + validationMessage);
            return false;
        }
    }

    public SFVec3f() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        this.SFVec3f = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
    }

    public boolean equals(SFVec3f comparisonSFVec3f) {
        return this.getPrimitiveValue() == comparisonSFVec3f.getPrimitiveValue();
    }

    public final String validate() {
        SFVec3f tempHold = new SFVec3f(this.getPrimitiveValue());
        if (!this.equals(tempHold)) {
            return "SFVec3f validate() error: failed get/set round-trip test";
        }
        return "";
    }

    public final String validateRegex() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            if (!m.matches()) {
                String errorNotice = "*** Regular expression (regex) failure, new SFVec3f PATTERN mismatch (\"" + this.toString() + "\")";
                return errorNotice;
            }
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for SFVec3f";
            validationResult.append(validationMessage).append("\n");
            System.out.println("*** " + validationMessage);
            return validationMessage;
        }
        return "";
    }

    public final boolean matches() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            return m.matches();
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for SFVec3f";
            validationResult.append(validationMessage).append("\n");
            System.out.println("*** " + validationMessage);
            return false;
        }
    }

    public static final boolean matches(String value) {
        Matcher m = PATTERN.matcher(value);
        return m.matches();
    }

    public SFVec3f setValueByString(String newValue) throws InvalidFieldValueException {
        if (newValue == null) {
            newValue = new String();
        }
        if (!org.web3d.x3d.jsail.fields.SFVec3f.matches(newValue)) {
            String errorNotice = "*** Regular expression (regex) failure, new SFVec3f(" + newValue + ")";
            validationResult.append(errorNotice).append("\n");
        }
        if (newValue.trim().isEmpty()) {
            this.SFVec3f = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        try {
            String[] newValues = newValue.replace(",", " ").trim().split("\\s+");
            if (newValues.length != 3) {
                String errorNotice = "illegal number of values in initialization string, new SFVec3f(" + newValue + ")";
                validationResult.append(errorNotice).append("\n");
                throw new InvalidFieldValueException(errorNotice);
            }
            this.SFVec3f[0] = Float.parseFloat(newValues[0]);
            this.SFVec3f[1] = Float.parseFloat(newValues[1]);
            this.SFVec3f[2] = Float.parseFloat(newValues[2]);
        }
        catch (NumberFormatException e) {
            String errorNotice = "new SFVec3f(" + newValue + ") " + e.getMessage();
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        return this;
    }

    public SFVec3f(SFVec3f newValue) {
        if (newValue == null) {
            this.SFVec3f = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return;
        }
        this.SFVec3f = newValue.getPrimitiveValue();
    }

    public SFVec3f(float[] newValue) {
        if (newValue == null) {
            newValue = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
        } else if (newValue.length != 3) {
            String errorNotice = "Illegal SFVec3f newValue array length=" + newValue.length + ", must equal 3 or else be empty (newValue=" + org.web3d.x3d.jsail.fields.SFVec3f.toString(newValue) + ")";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.SFVec3f = newValue;
    }

    public SFVec3f(float x, float y, float z) {
        this.SFVec3f[0] = x;
        this.SFVec3f[1] = y;
        this.SFVec3f[2] = z;
    }

    public SFVec3f normalize() {
        float length = (float)Math.sqrt(this.SFVec3f[0] * this.SFVec3f[0] + this.SFVec3f[1] * this.SFVec3f[1] + this.SFVec3f[2] * this.SFVec3f[2]);
        if (length > 0.0f) {
            this.SFVec3f[0] = this.SFVec3f[0] / length;
            this.SFVec3f[1] = this.SFVec3f[1] / length;
            this.SFVec3f[2] = this.SFVec3f[2] / length;
        }
        return this;
    }

    public SFVec3f(double x, double y, double z) {
        this.setValue((float)x, (float)y, (float)z);
    }

    public SFVec3f(double[] newValue) {
        this.setValue(newValue);
    }

    public static String toString(float[] value) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < value.length; ++i) {
            if (ConfigurationProperties.isStripTrailingZeroes()) {
                result.append(SFFloat.stripTrailingZeroes(value[i])).append(" ");
                continue;
            }
            result.append(value[i]).append(" ");
        }
        return result.toString().trim();
    }

    @Override
    public void getValue(float[] valueDestination) {
        valueDestination = this.SFVec3f;
    }

    public float[] getPrimitiveValue() {
        return this.SFVec3f;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.SFVec3f.length; ++i) {
            if (ConfigurationProperties.isStripTrailingZeroes()) {
                result.append(SFFloat.stripTrailingZeroes(this.SFVec3f[i]));
            } else {
                result.append(this.SFVec3f[i]);
            }
            if (i >= this.SFVec3f.length - 1) continue;
            result.append(" ");
        }
        return result.toString();
    }

    @Override
    public void setValue(float[] newValue) {
        if (newValue == null) {
            return;
        }
        if (newValue == null) {
            newValue = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
        } else if (newValue.length != 3) {
            String errorNotice = "Illegal SFVec3f newValue array length=" + newValue.length + ", must equal 3 or else be empty (newValue=" + org.web3d.x3d.jsail.fields.SFVec3f.toString(newValue) + ")";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.SFVec3f = newValue;
    }

    public SFVec3f setValueArray(float[] newValue) {
        this.setValue(newValue);
        return this;
    }

    public SFVec3f setValue(double[] newValue) {
        float[] newFloatArray = new float[newValue.length];
        for (int i = 0; i < newValue.length; ++i) {
            newFloatArray[i] = (float)newValue[i];
        }
        this.setValue(newFloatArray);
        return this;
    }

    public SFVec3f setValue(float x, float y, float z) {
        this.SFVec3f[0] = x;
        this.SFVec3f[1] = y;
        this.SFVec3f[2] = z;
        return this;
    }

    public SFVec3f setValue(double x, double y, double z) {
        this.setValue((float)x, (float)y, (float)z);
        return this;
    }

    public float[] toFloatArray() {
        return this.SFVec3f;
    }

    public SFVec3f setValue(SFVec3f newValue) {
        if (newValue == null) {
            this.SFVec3f = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        this.SFVec3f = newValue.getPrimitiveValue();
        return this;
    }

    public SFVec3f multiply(float scaleFactor) {
        this.SFVec3f[0] = this.SFVec3f[0] * scaleFactor;
        this.SFVec3f[1] = this.SFVec3f[1] * scaleFactor;
        this.SFVec3f[2] = this.SFVec3f[2] * scaleFactor;
        return this;
    }

    public boolean isDefaultValue() {
        return Arrays.equals(this.SFVec3f, DEFAULT_VALUE);
    }

    static {
        try {
            Pattern.compile(REGEX);
            if (!new SFVec3f(DEFAULT_VALUE).matches()) {
                System.out.println("SFVec3f.initialize() problem: failed to match DEFAULT_VALUE=" + Arrays.toString(DEFAULT_VALUE));
            }
        }
        catch (PatternSyntaxException exception) {
            System.out.println("Exception in SFVec3f initialization testing, regex pattern compilation failure.");
            System.out.println("REGEX=\"\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){2}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*\"");
            System.out.println(exception.getDescription());
        }
    }
}

