/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import com.treemap.Algorithm;
import com.treemap.BarAlgorithm;
import com.treemap.CirclePackingAlgorithm;
import com.treemap.CircularAlgorithm;
import com.treemap.IcicleAlgorithm;
import com.treemap.O;
import com.treemap.PieAlgorithm;
import com.treemap.PivotByAlgorithm;
import com.treemap.Q;
import com.treemap.SliceAndDiceAlgorithm;
import com.treemap.SquarifiedAlgorithm;
import com.treemap.SquarifiedPlusAlgorithm;
import com.treemap.SunburstAlgorithm;
import com.treemap.f;
import com.treemap.w;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jsinterop.annotations.JsType;

@JsType
public class AlgorithmFactory {
    public static final Algorithm BINARY_TREE = new f();
    public static final Algorithm SLICE = new SliceAndDiceAlgorithm();
    public static final Algorithm SQUARIFIED = new SquarifiedAlgorithm();
    public static final Algorithm SQUARIFIEDPLUS = new SquarifiedPlusAlgorithm();
    public static final Algorithm STRIP = new Q();
    public static final Algorithm PIVOT_BY_SPLIT_SIZE = new PivotByAlgorithm();
    public static final Algorithm SPLIT = new O();
    public static final Algorithm CIRCULAR = new CircularAlgorithm();
    public static final Algorithm CIRCLEPACKING = new CirclePackingAlgorithm();
    public static final Algorithm PIE = new PieAlgorithm();
    public static final Algorithm BAR = new BarAlgorithm();
    public static final Algorithm MATRIX = new w();
    public static final Algorithm SUNBURST = new SunburstAlgorithm();
    public static final Algorithm ICICLE = new IcicleAlgorithm();
    private final List<Algorithm> a = new ArrayList<Algorithm>();
    private static final AlgorithmFactory b = new AlgorithmFactory(BINARY_TREE, SLICE, SQUARIFIED, SQUARIFIEDPLUS, STRIP, PIVOT_BY_SPLIT_SIZE, SPLIT, CIRCULAR, BAR, PIE, SUNBURST, MATRIX, ICICLE);

    protected AlgorithmFactory(Algorithm ... entries) {
        this.a.addAll(Arrays.asList(entries));
    }

    public static AlgorithmFactory getInstance() {
        return b;
    }

    public void add(Algorithm entry) {
        this.a.add(entry);
    }

    public Algorithm getDefault() {
        return SQUARIFIEDPLUS;
    }

    public List<Algorithm> getAlgorithms() {
        return this.a;
    }

    public Algorithm get(String name) {
        for (Algorithm algorithm : this.a) {
            if (!algorithm.toString().equals(name)) continue;
            return algorithm;
        }
        return this.getDefault();
    }
}

