/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.document;

import com.macrofocus.common.collection.Iterables;
import com.macrofocus.common.command.Command;
import com.macrofocus.common.selection.MutableSingleSelection;
import com.macrofocus.common.selection.PropertySingleSelection;
import com.macrofocus.common.selection.SingleSelection;
import com.macrofocus.common.selection.SingleSelectionEvent;
import com.macrofocus.common.selection.SingleSelectionListener;
import com.macrofocus.crossplatform.CPButton;
import com.macrofocus.crossplatform.CPColorPicker;
import com.macrofocus.crossplatform.CPComboBox;
import com.macrofocus.crossplatform.CPComponent;
import com.macrofocus.crossplatform.CPFactory;
import com.macrofocus.crossplatform.CPFontPicker;
import com.macrofocus.crossplatform.CPFormPanel;
import com.macrofocus.crossplatform.CPLabel;
import com.macrofocus.crossplatform.CPSwitch;
import com.macrofocus.format.CPFormat;
import com.macrofocus.labeling.EnhancedLabel;
import com.treemap.Aggregation;
import com.treemap.AggregationFactory;
import com.treemap.TreeMapField;
import com.treemap.TreeMapFieldSettings;
import com.treemap.TreeMapModel;

class TooltipSettingsPanel<Component, Color, Font> {
    private final TreeMapModel treeMapModel;
    private final SingleSelection<TreeMapField> selection;
    private TreeMapFieldSettings settings;
    private final CPFormPanel<Component> layout;
    private final CPLabel<Component, Font> overrideDefaults;
    private final CPSwitch<Component> overrideCommonSettings;
    private final CPButton<Component> reset;
    private final CPFontPicker tooltipFont;
    private final CPColorPicker tooltipBackground;
    private final CPComboBox<Component, EnhancedLabel.Rendering> tooltipRendering;
    private final CPComboBox<Component, Aggregation> aggregation;
    private final CPComboBox<Component, CPFormat> format;
    private final CPSwitch<Component> showLabel;

    public TooltipSettingsPanel(TreeMapModel treeMapModel, SingleSelection<TreeMapField> selection, CPFactory<Component, Font, ?, Color> factory) {
        this.treeMapModel = treeMapModel;
        this.selection = selection;
        this.settings = selection.isActive() ? treeMapModel.getSettings().getFieldSettings((TreeMapField)selection.getSelected()) : treeMapModel.getSettings().getDefaultFieldSettings();
        selection.addSingleSelectionListener((SingleSelectionListener)new SingleSelectionListener<TreeMapField>(){

            public void selectionChanged(SingleSelectionEvent<TreeMapField> event) {
                TooltipSettingsPanel.this.setTreeMapField((TreeMapField)event.getCurrentSelection());
            }
        });
        this.layout = factory.createFormPanel();
        this.overrideCommonSettings = factory.createSwitch(this.settings != null ? this.settings.getOverrideDefaultsProperty() : null);
        this.reset = factory.createButton("Reset");
        this.reset.setCommand(new Command(){

            public void execute() {
                TooltipSettingsPanel.this.settings.reset();
            }
        });
        this.overrideDefaults = factory.createLabel("Override Defaults:");
        this.layout.add(this.overrideDefaults, (CPComponent)factory.createGridPanel(1, 2, new CPComponent[]{this.overrideCommonSettings, this.reset}));
        this.overrideDefaults.setVisible(this.settings.getOverrideDefaultsProperty() != null);
        this.overrideCommonSettings.setVisible(this.settings.getOverrideDefaultsProperty() != null);
        this.reset.setVisible(this.settings.getOverrideDefaultsProperty() != null);
        this.tooltipFont = factory.createFontPicker(this.settings.getTooltipFontProperty());
        this.tooltipBackground = factory.createColorPicker(this.settings.getTooltipForegroundProperty());
        this.layout.add((CPComponent)factory.createLabel("Font:"), (CPComponent)factory.createGridPanel(1, 2, new CPComponent[]{this.tooltipFont, this.tooltipBackground}));
        this.tooltipRendering = factory.createComboBox((MutableSingleSelection)new PropertySingleSelection(this.settings.getTooltipRenderingProperty()), Iterables.forArray((Object[])EnhancedLabel.Rendering.values()));
        this.layout.add((CPComponent)factory.createLabel("Overflow"), this.tooltipRendering);
        this.aggregation = factory.createComboBox((MutableSingleSelection)new PropertySingleSelection(this.settings.getAggregationProperty()), (Iterable)AggregationFactory.getInstance().getAggregations());
        this.layout.add((CPComponent)factory.createLabel("Aggregation:"), this.aggregation);
        this.format = factory.createComboBox((MutableSingleSelection)new PropertySingleSelection(this.settings.getFormatProperty()), Iterables.forArray((Object[])new CPFormat[0]));
        this.layout.add((CPComponent)factory.createLabel("Format:"), this.format);
        this.showLabel = factory.createSwitch(this.settings.getShowLabelProperty());
        this.layout.add((CPComponent)factory.createLabel("Show variable name:"), this.showLabel);
    }

    public void setTreeMapField(TreeMapField field) {
        this.settings = this.selection.isActive() ? this.treeMapModel.getSettings().getFieldSettings((TreeMapField)this.selection.getSelected()) : this.treeMapModel.getSettings().getDefaultFieldSettings();
        this.overrideCommonSettings.setProperty(this.settings != null ? this.settings.getOverrideDefaultsProperty() : null);
        this.overrideDefaults.setVisible(this.settings.getOverrideDefaultsProperty() != null);
        this.overrideCommonSettings.setVisible(this.settings.getOverrideDefaultsProperty() != null);
        this.reset.setVisible(this.settings.getOverrideDefaultsProperty() != null);
        this.tooltipFont.setProperty(this.settings.getTooltipFontProperty());
        this.tooltipBackground.setProperty(this.settings.getTooltipForegroundProperty());
        this.tooltipRendering.setModel((MutableSingleSelection)new PropertySingleSelection(this.settings.getTooltipRenderingProperty()), Iterables.forArray((Object[])EnhancedLabel.Rendering.values()));
        this.aggregation.setModel((MutableSingleSelection)new PropertySingleSelection(this.settings.getAggregationProperty()), (Iterable)AggregationFactory.getInstance().getAggregations());
        this.format.setModel((MutableSingleSelection)new PropertySingleSelection(this.settings.getFormatProperty()), Iterables.forArray((Object[])new CPFormat[0]));
        this.showLabel.setProperty(this.settings.getShowLabelProperty());
    }

    public CPComponent<Component> getPanel() {
        return this.layout;
    }
}

