/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.document.persistence;

import com.macrofocus.application.ApplicationModelFactory;
import com.macrofocus.application.SimpleVersionModel;
import com.macrofocus.application.VersionModel;
import com.macrofocus.colormap.ColorMap;
import com.macrofocus.colormap.MutableColorMap;
import com.macrofocus.common.geom.Dimension;
import com.macrofocus.common.interval.MutableInterval;
import com.macrofocus.common.logging.Logging;
import com.macrofocus.format.CPFormat;
import com.macrofocus.format.FormatFactory;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.igraphics.CPColorFactory;
import com.macrofocus.igraphics.CPFont;
import com.macrofocus.igraphics.CPFontFactory;
import com.macrofocus.labeling.EnhancedLabel;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.dataframe.WrappedDataFrame;
import com.macrofocus.molap.expression.ExpressionCalculatedColumn;
import com.macrofocus.palette.FixedPalette;
import com.macrofocus.palette.MutablePalette;
import com.macrofocus.palette.PaletteFactory;
import com.macrofocus.persistence.Attribute;
import com.macrofocus.persistence.Element;
import com.macrofocus.persistence.ElementFactory;
import com.macrofocus.persistence.Elements;
import com.treemap.AggregationFactory;
import com.treemap.AlgorithmFactory;
import com.treemap.DefaultTreeMapFieldSettings;
import com.treemap.DepthFactory;
import com.treemap.LabelingFactory;
import com.treemap.NestingFactory;
import com.treemap.NoTreeMapField;
import com.treemap.Ordering;
import com.treemap.OrderingFactory;
import com.treemap.RenderingFactory;
import com.treemap.ScaleFactory;
import com.treemap.TreeMapField;
import com.treemap.TreeMapFieldSettings;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapSettings;
import com.treemap.TreeMapView;
import com.treemap.app.document.TreeMapDocument;
import com.treemap.app.document.persistence.ColorMapState;
import com.treemap.treeplot.TreePlotModel;
import java.util.ArrayList;

public class TreeMapPersistence<Color, Font, File> {
    private final TreeMapDocument<?, Color, Font, File> document;
    private final DataFrame<Integer, String, ?> dataFrame;
    private final TreeMapModel<?, Integer, String, Color, Font> model;
    private final ColorMapState<Color> colorMapState;
    private final CPColorFactory<Color> colorFactory;
    private final CPFontFactory<Font> fontFactory;
    private final AggregationFactory aggregationFactory;
    private final PaletteFactory<Color> paletteFactory;
    private final FormatFactory formatFactory;
    private final AlgorithmFactory algorithmFactory;
    private final ElementFactory elementFactory;

    public TreeMapPersistence(TreeMapDocument<?, Color, Font, File> document, CPColorFactory<Color> colorFactory, CPFontFactory<Font> fontFactory, AggregationFactory aggregationFactory, PaletteFactory<Color> paletteFactory, FormatFactory formatFactory, AlgorithmFactory algorithmFactory, ElementFactory elementFactory, ColorMapState<Color> colorMapState) {
        this.document = document;
        this.dataFrame = document.getDataFrame();
        this.model = document.getTreeMapModel();
        this.colorFactory = colorFactory;
        this.fontFactory = fontFactory;
        this.aggregationFactory = aggregationFactory;
        this.paletteFactory = paletteFactory;
        this.formatFactory = formatFactory;
        this.algorithmFactory = algorithmFactory;
        this.elementFactory = elementFactory;
        this.colorMapState = colorMapState;
    }

    public TreeMapSettings<?, String, Color, Font> getSettings() {
        return this.model.getSettings();
    }

    private TreePlotModel getTreePlotModel() {
        return this.document.getTreePlotModel();
    }

    public void load(Element root) {
        block96: {
            boolean updateGroupBy = true;
            try {
                if (!root.getLocalName().equals("TreeMap")) break block96;
                String versionValue = root.getAttributeValue("version");
                VersionModel version = null;
                if (versionValue != null) {
                    try {
                        version = new SimpleVersionModel(versionValue);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (version == null) {
                    version = ApplicationModelFactory.TREEMAP_API.getVersionModel();
                }
                Elements children = root.getChildElements();
                for (int h = 0; h < children.size(); ++h) {
                    Elements configurations;
                    TreeMapField<?, String> field;
                    String background;
                    int i;
                    Element child = children.get(h);
                    if (child.getLocalName().equals("Options")) {
                        Elements options = child.getChildElements();
                        for (i = 0; i < options.size(); ++i) {
                            Attribute sizeAttribute;
                            Element option = options.get(i);
                            if (option.getLocalName().equals("Logo")) {
                                Attribute visibleAttribute = option.getAttribute("visible");
                                if (visibleAttribute == null) continue;
                                boolean bl = Boolean.valueOf(visibleAttribute.getValue());
                                continue;
                            }
                            if (!option.getLocalName().equals("Divider") || (sizeAttribute = option.getAttribute("size")) == null) continue;
                            Integer n = Integer.valueOf(sizeAttribute.getValue());
                        }
                    }
                    if (child.getLocalName().equals("Settings")) {
                        String lightSourceZ;
                        String lightSourceY;
                        String lightSourceX;
                        String lightSourceAmbient;
                        String lightSourceHeight;
                        String maximumHeight;
                        String progressive;
                        String dimension;
                        String dimensionFixed;
                        String hideFilterResults;
                        String hideSearchResults;
                        String selectionColor;
                        String probingColor;
                        String tooltipBackground;
                        String rendering;
                        String depth = child.getAttributeValue("depth");
                        if (depth != null) {
                            this.getSettings().setDepth(DepthFactory.getInstance().get(depth));
                        }
                        if ((rendering = child.getAttributeValue("rendering")) != null) {
                            this.getSettings().setRendering(RenderingFactory.getInstance().get(rendering));
                        }
                        if ((background = child.getAttributeValue("background")) != null) {
                            this.getSettings().setBackground(this.colorFactory.parseHTMLColor(background));
                        }
                        if ((tooltipBackground = child.getAttributeValue("tooltipBackground")) != null) {
                            this.getSettings().setTooltipBackground(this.colorFactory.parseHTMLColor(tooltipBackground));
                        }
                        if ((probingColor = child.getAttributeValue("probingColor")) != null) {
                            this.getSettings().setProbingColor(this.colorFactory.parseHTMLColor(probingColor));
                        }
                        if ((selectionColor = child.getAttributeValue("selectionColor")) != null) {
                            this.getSettings().setSelectionColor(this.colorFactory.parseHTMLColor(selectionColor));
                        }
                        if ((hideSearchResults = child.getAttributeValue("hideSearchResults")) != null) {
                            this.getSettings().setHideSearchResults(Boolean.valueOf(Boolean.parseBoolean(hideSearchResults)));
                        }
                        if ((hideFilterResults = child.getAttributeValue("hideFilterResults")) != null) {
                            this.getSettings().setHideFilterResults(Boolean.valueOf(Boolean.parseBoolean(hideFilterResults)));
                        }
                        if ((dimensionFixed = child.getAttributeValue("dimensionFixed")) != null) {
                            this.getSettings().setDimensionFixed(Boolean.valueOf(Boolean.parseBoolean(dimensionFixed)));
                        }
                        if ((dimension = child.getAttributeValue("dimension")) != null && this.getSettings().getDimensionFixed().booleanValue()) {
                            String[] st = dimension.split("[;,]");
                            int width = Integer.parseInt(st[0].trim());
                            int height = Integer.parseInt(st[1].trim());
                            this.getSettings().setDimension(new Dimension(width, height));
                        }
                        if ((progressive = child.getAttributeValue("progressive")) != null) {
                            this.getSettings().setProgressive(TreeMapView.Progressive.valueOf((String)progressive));
                        }
                        if ((maximumHeight = child.getAttributeValue("maximumHeight")) != null) {
                            try {
                                this.getSettings().setMaximumHeight(Double.parseDouble(maximumHeight));
                            }
                            catch (NumberFormatException e) {
                                e.printStackTrace();
                            }
                        }
                        if ((lightSourceHeight = child.getAttributeValue("lightSourceHeight")) != null) {
                            try {
                                this.getSettings().setLightSourceHeight(Double.parseDouble(lightSourceHeight));
                            }
                            catch (NumberFormatException e) {
                                e.printStackTrace();
                            }
                        }
                        if ((lightSourceAmbient = child.getAttributeValue("lightSourceAmbient")) != null) {
                            try {
                                this.getSettings().setLightSourceAmbient(Double.parseDouble(lightSourceAmbient));
                            }
                            catch (NumberFormatException e) {
                                e.printStackTrace();
                            }
                        }
                        if ((lightSourceX = child.getAttributeValue("lightSourceX")) != null) {
                            try {
                                this.getSettings().setLightSourceX(Double.parseDouble(lightSourceX));
                            }
                            catch (NumberFormatException e) {
                                e.printStackTrace();
                            }
                        }
                        if ((lightSourceY = child.getAttributeValue("lightSourceY")) != null) {
                            try {
                                this.getSettings().setLightSourceY(Double.parseDouble(lightSourceY));
                            }
                            catch (NumberFormatException e) {
                                e.printStackTrace();
                            }
                        }
                        if ((lightSourceZ = child.getAttributeValue("lightSourceZ")) != null) {
                            try {
                                this.getSettings().setLightSourceZ(Double.parseDouble(lightSourceZ));
                            }
                            catch (NumberFormatException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    if (child.getLocalName().equals("Variables")) {
                        Elements variables = child.getChildElements();
                        for (i = 0; i < variables.size(); ++i) {
                            String showLabel;
                            String showPopup;
                            String aggregation;
                            Element variable = variables.get(i);
                            if (variable.getLocalName().equals("Default")) {
                                this.loadSpecific(version, null, variable, this.getSettings().getDefaultFieldSettings());
                                continue;
                            }
                            if (!variable.getLocalName().equals("Variable")) continue;
                            String name = variable.getAttributeValue("name");
                            field = this.locateVariable(this.convertIndex(variable.getAttributeValue("index")), name);
                            String index = field.isValid() ? (String)field.getIndex() : null;
                            String expression = variable.getAttributeValue("expression");
                            if (expression != null && !this.locateVariable(this.convertIndex(variable.getAttributeValue("index")), name).isValid() && this.dataFrame instanceof WrappedDataFrame) {
                                WrappedDataFrame calculatedDataFrame = (WrappedDataFrame)this.dataFrame;
                                calculatedDataFrame.addDerivedColumn(new WrappedDataFrame.Column[]{new ExpressionCalculatedColumn((Object)name, expression)});
                                index = (String)this.locateVariable(this.convertIndex(variable.getAttributeValue("index")), name).getIndex();
                            }
                            if (index == null) {
                                System.err.println("Could not find variable " + name);
                                continue;
                            }
                            String pattern = variable.getAttributeValue("pattern");
                            if (pattern != null) {
                                this.setFormatPattern(index, pattern);
                            }
                            if ((aggregation = variable.getAttributeValue("aggregation")) != null) {
                                this.getSettings().getFieldSettings(this.model.getTreeMapField((Object)index)).setAggregation(this.aggregationFactory.find(aggregation));
                            }
                            if (version.getMajor() < 3 && (showPopup = variable.getAttributeValue("showPopup")) != null) {
                                this.getSettings().setShowPopup(this.model.getTreeMapField((Object)index), Boolean.parseBoolean(showPopup));
                            }
                            if ((showLabel = variable.getAttributeValue("showLabel")) != null) {
                                this.getSettings().getFieldSettings(this.model.getTreeMapField((Object)index)).setShowLabel(Boolean.parseBoolean(showLabel));
                            }
                            String colorMin = variable.getAttributeValue("colorMin");
                            String colorMax = variable.getAttributeValue("colorMax");
                            if (colorMin != null && colorMax != null) {
                                MutableInterval interval;
                                MutableColorMap predefinedColorMap;
                                double min = Double.parseDouble(colorMin);
                                double max = Double.parseDouble(colorMax);
                                double extent = max - min;
                                if (extent > 0.0 && (predefinedColorMap = this.model.getPredefinedColorMap((Object)index)) != null && (interval = predefinedColorMap.getInterval()) != null) {
                                    interval.setValue(min, extent);
                                }
                            }
                            this.loadSpecific(version, index, variable, this.getSettings().getFieldSettings(this.model.getTreeMapField((Object)index)));
                        }
                    }
                    if (child.getLocalName().equals("Configuration")) {
                        configurations = child.getChildElements();
                        for (i = 0; i < configurations.size(); ++i) {
                            ArrayList labels;
                            String name;
                            String name2;
                            TreeMapField<?, String> v;
                            Element variable;
                            Element configuration = configurations.get(i);
                            if (configuration.getLocalName().equals("GroupBy")) {
                                Elements variables = configuration.getChildElements();
                                ArrayList list = new ArrayList();
                                for (int j = 0; j < variables.size(); ++j) {
                                    int index;
                                    variable = variables.get(j);
                                    if (!variable.getLocalName().equals("Variable") || !(v = this.locateVariable(index = this.convertIndex(variable.getAttributeValue("index")), name2 = variable.getAttributeValue("name"))).isValid()) continue;
                                    list.add(v);
                                }
                                this.getSettings().getGroupByVariablesSelection().setSelectedIterable(list);
                                updateGroupBy = false;
                                continue;
                            }
                            if (configuration.getLocalName().equals("Size")) {
                                int index = this.convertIndex(configuration.getAttributeValue("variableIndex"));
                                name = configuration.getAttributeValue("variableName");
                                this.getSettings().getSizeVariableSelection().setSelected(this.locateVariable(index, name));
                                continue;
                            }
                            if (configuration.getLocalName().equals("Height")) {
                                int index = this.convertIndex(configuration.getAttributeValue("variableIndex"));
                                name = configuration.getAttributeValue("variableName");
                                this.getSettings().getHeightVariableSelection().setSelected(this.locateVariable(index, name));
                                continue;
                            }
                            if (configuration.getLocalName().equals("Color")) {
                                int index = this.convertIndex(configuration.getAttributeValue("variableIndex"));
                                name = configuration.getAttributeValue("variableName");
                                this.getSettings().getColorVariableSelection().setSelected(this.locateVariable(index, name));
                                continue;
                            }
                            if (configuration.getLocalName().equals("Label")) {
                                Elements variables = configuration.getChildElements();
                                labels = new ArrayList();
                                for (int j = 0; j < variables.size(); ++j) {
                                    int index;
                                    variable = variables.get(j);
                                    if (!variable.getLocalName().equals("Variable") || !(v = this.locateVariable(index = this.convertIndex(variable.getAttributeValue("index")), name2 = variable.getAttributeValue("name"))).isValid()) continue;
                                    labels.add(v);
                                }
                                this.getSettings().getLabelVariablesSelection().setSelectedIterable(labels);
                                continue;
                            }
                            if (configuration.getLocalName().equals("Tooltip")) {
                                Elements variables = configuration.getChildElements();
                                labels = new ArrayList();
                                for (int j = 0; j < variables.size(); ++j) {
                                    int index;
                                    variable = variables.get(j);
                                    if (!variable.getLocalName().equals("Variable") || !(v = this.locateVariable(index = this.convertIndex(variable.getAttributeValue("index")), name2 = variable.getAttributeValue("name"))).isValid()) continue;
                                    labels.add(v);
                                }
                                this.getSettings().getTooltipVariablesSelection().setSelectedIterable(labels);
                                continue;
                            }
                            if (configuration.getLocalName().equals("Background")) {
                                int index = this.convertIndex(configuration.getAttributeValue("variableIndex"));
                                name = configuration.getAttributeValue("variableName");
                                field = this.locateVariable(index, name);
                                if (version.getMajor() < 3) {
                                    if (field == null || !field.isValid()) continue;
                                    this.getSettings().getFieldSettings(field).setLabelingResizeTextToFitShape(Boolean.valueOf(true));
                                    this.getSettings().getLabelVariablesSelection().setSelectedState(field, true);
                                    continue;
                                }
                                this.getSettings().getBackgroundVariableSelection().setSelected(field);
                                continue;
                            }
                            if (!configuration.getLocalName().equals("Colormap")) continue;
                            String name3 = configuration.getAttributeValue("name");
                            PaletteFactory.Entry entry = this.paletteFactory.get(name3);
                            if (entry != null) {
                                MutableColorMap colorMap;
                                FixedPalette palette = entry.getPalette();
                                if (palette == null || !this.getSettings().getColorTreeMapField().isValid() || (colorMap = this.model.getPredefinedColorMap((Object)((String)this.getSettings().getColorTreeMapField().getIndex()))) == null) continue;
                                colorMap.setPalette((MutablePalette)palette);
                                continue;
                            }
                            System.err.println("Could not find palette " + name3);
                        }
                    }
                    if (child.getLocalName().equals("Layout")) {
                        configurations = child.getChildElements();
                        for (i = 0; i < configurations.size(); ++i) {
                            String borderThickness;
                            String borderColor;
                            String lightSourceZ;
                            String lightSourceY;
                            String lightSourceX;
                            String lightSourceAmbient;
                            String lightSourceHeight;
                            String name;
                            Element layout = configurations.get(i);
                            if (layout.getLocalName().equals("Algorithm")) {
                                name = layout.getAttributeValue("name");
                                this.getSettings().getDefaultFieldSettings().setAlgorithm(this.algorithmFactory.get(name));
                                continue;
                            }
                            if (layout.getLocalName().equals("Aggregation")) {
                                name = layout.getAttributeValue("name");
                                this.getSettings().getDefaultFieldSettings().setAggregation(this.aggregationFactory.get(name));
                                continue;
                            }
                            if (layout.getLocalName().equals("Scale")) {
                                name = layout.getAttributeValue("name");
                                this.getSettings().getDefaultFieldSettings().setScale(ScaleFactory.getInstance().get(name));
                                continue;
                            }
                            if (layout.getLocalName().equals("Nesting")) {
                                name = layout.getAttributeValue("name");
                                this.getSettings().getDefaultFieldSettings().setNesting(NestingFactory.getInstance().get(name));
                                continue;
                            }
                            if (layout.getLocalName().equals("Ordering")) {
                                name = layout.getAttributeValue("name");
                                this.getSettings().getDefaultFieldSettings().setOrdering(OrderingFactory.getInstance().get(name));
                                continue;
                            }
                            if (layout.getLocalName().equals("Depth")) {
                                name = layout.getAttributeValue("name");
                                this.getSettings().setDepth(DepthFactory.getInstance().get(name));
                                continue;
                            }
                            if (layout.getLocalName().equals("Labeling")) {
                                String headerBackgroundColor;
                                String headerForegroundColor;
                                String headerFont;
                                String labelingForegroundColor;
                                String labelingFont;
                                name = layout.getAttributeValue("name");
                                this.getSettings().getDefaultFieldSettings().setLabeling(LabelingFactory.getInstance().get(name));
                                if (version.getMajor() < 3 && this.getSettings().getDefaultFieldSettings().getLabeling() == LabelingFactory.SURROUND) {
                                    this.getSettings().getDefaultFieldSettings().setNesting(NestingFactory.PROPORTIONAL);
                                }
                                if ((labelingFont = layout.getAttributeValue("labelingFont")) != null) {
                                    CPFont font = this.fontFactory.decodeFontWithDefault(labelingFont, DefaultTreeMapFieldSettings.getDefaultLabelingFont(this.fontFactory));
                                    this.getSettings().getDefaultFieldSettings().setLabelingFont(font);
                                }
                                if ((labelingForegroundColor = layout.getAttributeValue("labelingForegroundColor")) != null) {
                                    this.getSettings().getDefaultFieldSettings().setLabelingForeground(this.colorFactory.parseHTMLColor(labelingForegroundColor));
                                }
                                String labelingBackgroundColor = layout.getAttributeValue("labelingBackgroundColor");
                                if (labelingForegroundColor != null) {
                                    this.getSettings().getDefaultFieldSettings().setLabelingEffectColor(this.colorFactory.parseHTMLColor(labelingBackgroundColor));
                                }
                                if ((headerFont = layout.getAttributeValue("headerFont")) != null) {
                                    CPFont font = this.fontFactory.decodeFontWithDefault(headerFont, DefaultTreeMapFieldSettings.getDefaultHeaderFont(this.fontFactory));
                                    this.getSettings().getDefaultFieldSettings().setHeaderFont(font);
                                }
                                if ((headerForegroundColor = layout.getAttributeValue("headerForegroundColor")) != null) {
                                    this.getSettings().getDefaultFieldSettings().setHeaderForeground(this.colorFactory.parseHTMLColor(headerForegroundColor));
                                }
                                if ((headerBackgroundColor = layout.getAttributeValue("headerBackgroundColor")) == null) continue;
                                this.getSettings().getDefaultFieldSettings().setHeaderBackground(this.colorFactory.parseHTMLColor(headerBackgroundColor));
                                continue;
                            }
                            if (!layout.getLocalName().equals("Rendering")) continue;
                            name = layout.getAttributeValue("name");
                            this.getSettings().setRendering(RenderingFactory.getInstance().get(name));
                            String maximumHeight = layout.getAttributeValue("maximumHeight");
                            if (maximumHeight != null) {
                                this.getSettings().getMaximumHeightInterval().setStart(Double.parseDouble(maximumHeight));
                            }
                            if ((lightSourceHeight = layout.getAttributeValue("lightSourceHeight")) != null) {
                                this.getSettings().setLightSourceHeight(Double.parseDouble(lightSourceHeight));
                            }
                            if ((lightSourceAmbient = layout.getAttributeValue("lightSourceAmbient")) != null) {
                                this.getSettings().setLightSourceAmbient(Double.parseDouble(lightSourceAmbient));
                            }
                            if ((lightSourceX = layout.getAttributeValue("lightSourceX")) != null) {
                                this.getSettings().setLightSourceX(Double.parseDouble(lightSourceX));
                            }
                            if ((lightSourceY = layout.getAttributeValue("lightSourceY")) != null) {
                                this.getSettings().setLightSourceY(Double.parseDouble(lightSourceY));
                            }
                            if ((lightSourceZ = layout.getAttributeValue("lightSourceZ")) != null) {
                                this.getSettings().setLightSourceZ(Double.parseDouble(lightSourceZ));
                            }
                            if ((borderColor = layout.getAttributeValue("borderColor")) != null) {
                                if (version.getMajor() < 3 && borderColor.equals("#606006")) {
                                    this.getSettings().getDefaultFieldSettings().setBorderColor(this.colorFactory.parseHTMLColor("#606060"));
                                } else {
                                    this.getSettings().getDefaultFieldSettings().setBorderColor(this.colorFactory.parseHTMLColor(borderColor));
                                }
                            }
                            if ((borderThickness = layout.getAttributeValue("borderThickness")) == null) continue;
                            this.getSettings().getDefaultFieldSettings().setBorderThickness(Double.parseDouble(borderThickness));
                        }
                    }
                    if (!child.getLocalName().equals("TreePlot")) continue;
                    try {
                        String bubbleSize;
                        String groupBy;
                        String gridThickness;
                        String gridColor;
                        String xIndexValue = child.getAttributeValue("xIndex");
                        String yIndexValue = child.getAttributeValue("yIndex");
                        if (xIndexValue != null && yIndexValue != null) {
                            int xIndex = Integer.valueOf(xIndexValue);
                            int yIndex = Integer.valueOf(yIndexValue);
                            String xName = child.getAttributeValue("xName");
                            String yName = child.getAttributeValue("yName");
                            this.getTreePlotModel().getXVariable().setSelected(this.locateVariable(xIndex, xName));
                            this.getTreePlotModel().getYVariable().setSelected(this.locateVariable(yIndex, yName));
                        }
                        if ((background = child.getAttributeValue("background")) != null) {
                            this.getTreePlotModel().getSettings().setBackground(this.colorFactory.parseHTMLColor(background));
                        }
                        if ((gridColor = child.getAttributeValue("gridColor")) != null) {
                            this.getTreePlotModel().getSettings().setGridColor(this.colorFactory.parseHTMLColor(gridColor));
                        }
                        if ((gridThickness = child.getAttributeValue("gridThickness")) != null) {
                            this.getTreePlotModel().getSettings().setGridThickness(Double.valueOf(Double.parseDouble(gridThickness)));
                        }
                        if ((groupBy = child.getAttributeValue("groupBy")) != null) {
                            this.getTreePlotModel().getSettings().setGroupBy(Boolean.valueOf(Boolean.parseBoolean(groupBy)));
                        }
                        if ((bubbleSize = child.getAttributeValue("bubbleSize")) == null) continue;
                        this.getTreePlotModel().getSettings().getBubbleSizeInterval().setEnd(Double.parseDouble(bubbleSize));
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                Logging.getInstance().process((Throwable)e);
            }
        }
    }

    private void loadSpecific(VersionModel version, String column, Element root, TreeMapFieldSettings settings) {
        String colormap;
        String showLabel;
        String propertyFormat;
        String borderThickness;
        String borderColor;
        String tooltipRendering;
        String tooltipFont;
        String tooltipForeground;
        String headerOpacity;
        String headerMinimumCharactersToDisplay;
        String headerRendering;
        String headerVerticalAlignment;
        String headerHorizontalAlignment;
        String headerEffect;
        String headerFont;
        String headerBackground;
        String headerEffectColor;
        String headerForeground;
        String nestingBackground;
        String nestingAmount;
        String labelingContrastEnhancement;
        String labelingResizeTextToFitShape;
        String labelingShrinkTextToFitShape;
        String labelingEffectOpacity;
        String labelingMinimumCharactersToDisplay;
        String labelingRendering;
        String labelingVerticalAlignment;
        String labelingHorizontalAlignment;
        String labelingEffect;
        String labelingFont;
        String labelingEffectColor;
        String labelingForeground;
        String labeling;
        String orderingHorizontalVanishingPoint;
        String orderingVerticalVanishingPoint;
        String orderingDirection;
        String ordering;
        String nesting;
        String scale;
        String aggregation;
        String algorithm = root.getAttributeValue("algorithm");
        if (algorithm != null) {
            settings.setAlgorithm(AlgorithmFactory.getInstance().get(algorithm));
        }
        if ((aggregation = root.getAttributeValue("aggregation")) != null) {
            settings.setAggregation(this.aggregationFactory.find(aggregation));
        }
        if ((scale = root.getAttributeValue("scale")) != null) {
            settings.setScale(ScaleFactory.getInstance().get(scale));
        }
        if ((nesting = root.getAttributeValue("nesting")) != null) {
            settings.setNesting(NestingFactory.getInstance().get(nesting));
        }
        if ((ordering = root.getAttributeValue("ordering")) != null) {
            settings.setOrdering(OrderingFactory.getInstance().get(ordering));
        }
        if ((orderingDirection = root.getAttributeValue("orderingDirection")) != null) {
            settings.setOrderingDirection(Ordering.SortOrder.valueOf((String)orderingDirection));
        }
        if ((orderingVerticalVanishingPoint = root.getAttributeValue("orderingVerticalVanishingPoint")) != null) {
            settings.setOrderingVerticalVanishingPoint(Integer.valueOf(Integer.parseInt(orderingVerticalVanishingPoint)));
        }
        if ((orderingHorizontalVanishingPoint = root.getAttributeValue("orderingHorizontalVanishingPoint")) != null) {
            settings.setOrderingHorizontalVanishingPoint(Integer.valueOf(Integer.parseInt(orderingHorizontalVanishingPoint)));
        }
        if ((labeling = root.getAttributeValue("labeling")) != null) {
            settings.setLabeling(LabelingFactory.getInstance().get(labeling));
            if (version.getMajor() < 3 && settings.getLabeling() == LabelingFactory.SURROUND) {
                settings.setNesting(NestingFactory.PROPORTIONAL);
                settings.setNestingAmount(Double.valueOf(2.5));
            }
        }
        if ((labelingForeground = root.getAttributeValue("labelingForeground")) != null) {
            settings.setLabelingForeground(this.colorFactory.parseHTMLColor(labelingForeground));
        }
        if ((labelingEffectColor = root.getAttributeValue("labelingEffectColor")) != null) {
            settings.setLabelingEffectColor(this.colorFactory.parseHTMLColor(labelingEffectColor));
        }
        if ((labelingFont = root.getAttributeValue("labelingFont")) != null) {
            settings.setLabelingFont(this.fontFactory.decodeFontWithDefault(labelingFont, DefaultTreeMapFieldSettings.getDefaultLabelingFont(this.fontFactory)));
        }
        if ((labelingEffect = root.getAttributeValue("labelingEffect")) != null) {
            settings.setLabelingEffect(EnhancedLabel.Effect.valueOf((String)labelingEffect));
        }
        if ((labelingHorizontalAlignment = root.getAttributeValue("labelingHorizontalAlignment")) != null) {
            settings.setLabelingHorizontalAlignment(Integer.parseInt(labelingHorizontalAlignment));
        }
        if ((labelingVerticalAlignment = root.getAttributeValue("labelingVerticalAlignment")) != null) {
            settings.setLabelingVerticalAlignment(Integer.parseInt(labelingVerticalAlignment));
        }
        if ((labelingRendering = root.getAttributeValue("labelingRendering")) != null) {
            settings.setLabelingRendering(EnhancedLabel.Rendering.valueOf((String)labelingRendering));
        }
        if ((labelingMinimumCharactersToDisplay = root.getAttributeValue("labelingMinimumCharactersToDisplay")) != null) {
            settings.setLabelingMinimumCharactersToDisplay(Integer.parseInt(labelingMinimumCharactersToDisplay));
        }
        if ((labelingEffectOpacity = root.getAttributeValue("labelingEffectOpacity")) != null) {
            settings.setLabelingEffectOpacity(Float.valueOf(Float.parseFloat(labelingEffectOpacity)));
        }
        if ((labelingShrinkTextToFitShape = root.getAttributeValue("labelingShrinkTextToFitShape")) != null) {
            settings.setLabelingShrinkTextToFitShape(Boolean.valueOf(Boolean.parseBoolean(labelingShrinkTextToFitShape)));
        }
        if ((labelingResizeTextToFitShape = root.getAttributeValue("labelingResizeTextToFitShape")) != null) {
            settings.setLabelingResizeTextToFitShape(Boolean.valueOf(Boolean.parseBoolean(labelingResizeTextToFitShape)));
        }
        String labelingFloat = root.getAttributeValue("labelingFloat");
        if (labelingEffectOpacity != null) {
            settings.setLabelingFloat(Boolean.valueOf(Boolean.parseBoolean(labelingFloat)));
        }
        if ((labelingContrastEnhancement = root.getAttributeValue("labelingContrastEnhancement")) != null) {
            labelingContrastEnhancement = labelingContrastEnhancement.replaceAll("Black&White", EnhancedLabel.ContrastEnhancement.BlackWhite.name());
            settings.setLabelingContrastEnhancement(EnhancedLabel.ContrastEnhancement.valueOf((String)labelingContrastEnhancement));
        }
        if ((nestingAmount = root.getAttributeValue("nestingAmount")) != null) {
            settings.setNestingAmount(Double.valueOf(Double.parseDouble(nestingAmount)));
        }
        if ((nestingBackground = root.getAttributeValue("nestingBackground")) != null) {
            settings.setNestingBackground(this.colorFactory.parseHTMLColor(nestingBackground));
        }
        if ((headerForeground = root.getAttributeValue("headerForeground")) != null) {
            settings.setHeaderForeground(this.colorFactory.parseHTMLColor(headerForeground));
        }
        if ((headerEffectColor = root.getAttributeValue("headerEffectColor")) != null) {
            settings.setHeaderEffectColor(this.colorFactory.parseHTMLColor(headerEffectColor));
        }
        if ((headerBackground = root.getAttributeValue("headerBackground")) != null) {
            settings.setHeaderBackground(this.colorFactory.parseHTMLColor(headerBackground));
        }
        if ((headerFont = root.getAttributeValue("headerFont")) != null) {
            settings.setHeaderFont(this.fontFactory.decodeFontWithDefault(headerFont, DefaultTreeMapFieldSettings.getDefaultHeaderFont(this.fontFactory)));
        }
        if ((headerEffect = root.getAttributeValue("headerEffect")) != null) {
            settings.setHeaderEffect(EnhancedLabel.Effect.valueOf((String)headerEffect));
        }
        if ((headerHorizontalAlignment = root.getAttributeValue("headerHorizontalAlignment")) != null) {
            settings.setHeaderHorizontalAlignment(Integer.valueOf(Integer.parseInt(headerHorizontalAlignment)));
        }
        if ((headerVerticalAlignment = root.getAttributeValue("headerVerticalAlignment")) != null) {
            settings.setHeaderVerticalAlignment(Integer.valueOf(Integer.parseInt(headerVerticalAlignment)));
        }
        if ((headerRendering = root.getAttributeValue("headerRendering")) != null) {
            settings.setHeaderRendering(EnhancedLabel.Rendering.valueOf((String)headerRendering));
        }
        if ((headerMinimumCharactersToDisplay = root.getAttributeValue("headerMinimumCharactersToDisplay")) != null) {
            settings.setHeaderMinimumCharactersToDisplay(Integer.valueOf(Integer.parseInt(headerMinimumCharactersToDisplay)));
        }
        if ((headerOpacity = root.getAttributeValue("headerEffectOpacity")) != null) {
            settings.setHeaderEffectOpacity(Float.valueOf(Float.parseFloat(headerOpacity)));
        }
        if ((tooltipForeground = root.getAttributeValue("tooltipForeground")) != null) {
            settings.setTooltipForeground(this.colorFactory.parseHTMLColor(tooltipForeground));
        }
        if ((tooltipFont = root.getAttributeValue("tooltipFont")) != null) {
            settings.setTooltipFont(this.fontFactory.decodeFontWithDefault(tooltipFont, DefaultTreeMapFieldSettings.getDefaultTooltipFont(this.fontFactory)));
        }
        if ((tooltipRendering = root.getAttributeValue("tooltipRendering")) != null) {
            settings.setTooltipRendering(EnhancedLabel.Rendering.valueOf((String)tooltipRendering));
        }
        if ((borderColor = root.getAttributeValue("borderColor")) != null) {
            if (version.getMajor() < 3 && borderColor.equals("#606006")) {
                settings.setBorderColor(this.colorFactory.parseHTMLColor("#606060"));
            } else {
                settings.setBorderColor(this.colorFactory.parseHTMLColor(borderColor));
            }
        }
        if ((borderThickness = root.getAttributeValue("borderThickness")) != null) {
            settings.setBorderThickness(Double.parseDouble(borderThickness));
        }
        if ((propertyFormat = root.getAttributeValue("format")) != null) {
            // empty if block
        }
        if ((showLabel = root.getAttributeValue("showLabel")) != null) {
            settings.setShowLabel(Boolean.parseBoolean(showLabel));
        }
        if ((colormap = root.getAttributeValue("colormap")) != null && column != null) {
            if ("predefined".equals(colormap)) {
                settings.setColorMap(this.model.getPredefinedColorMap((Object)column));
            } else if ("custom".equals(colormap)) {
                settings.setColorMap(this.model.getCustomColorMap((Object)column));
            } else if ("categorical".equals(colormap)) {
                settings.setColorMap(this.model.getCategoricalColorMap((Object)column));
            }
        }
        Elements children = root.getChildElements();
        for (int h = 0; h < children.size(); ++h) {
            Element child = children.get(h);
            this.loadColormap(column, child);
        }
    }

    public void loadColormap(String column, Element child) {
        if (child.getLocalName().equals("Colormap")) {
            String type = child.getAttributeValue("type");
            if ("predefined".equals(type)) {
                MutableColorMap colorMap = this.model.getPredefinedColorMap((Object)column);
                this.colorMapState.loadPredefined(child, colorMap);
            } else if ("custom".equals(type)) {
                Double min = this.model.getNumericMin(this.model.getTreeMapField((Object)column));
                Double max = this.model.getNumericMax(this.model.getTreeMapField((Object)column));
                MutableColorMap colorMap = this.model.getCustomColorMap((Object)column);
                this.colorMapState.loadCustom(min, max, child, colorMap);
            } else if ("categorical".equals(type)) {
                MutableColorMap colorMap = this.model.getCategoricalColorMap((Object)column);
                this.colorMapState.loadCategorical(this.model.getColumnClass((Object)column), child, colorMap);
            }
        }
    }

    public void save(Element root, File file) {
        Element element;
        if (this.document.getDataSourcePersistence() != null && (element = this.document.getDataSourcePersistence().create(file)) != null) {
            root.appendChild(element);
        }
        Element options = this.elementFactory.newElement("Options");
        root.appendChild(options);
        Element settings = this.elementFactory.newElement("Settings");
        this.saveGeneralSettings(this.getSettings(), settings);
        root.appendChild(settings);
        Element variables = this.elementFactory.newElement("Variables");
        Element defaults = this.elementFactory.newElement("Default");
        this.saveSpecificSettings(-1, this.getSettings().getDefaultFieldSettings(), defaults);
        variables.appendChild(defaults);
        for (int c = 0; c < this.dataFrame.getColumnCount(); ++c) {
            MutableInterval interval;
            MutableColorMap predefinedColorMap;
            String pattern;
            WrappedDataFrame.Column column;
            Element variableElement = this.elementFactory.newElement("Variable");
            variableElement.addAttribute(this.elementFactory.newAttribute("index", Integer.toString(c)));
            variableElement.addAttribute(this.elementFactory.newAttribute("name", this.dataFrame.getColumnName((Object)((String)this.dataFrame.getColumnKey(c)))));
            System.out.println(Integer.toString(c) + ": " + (String)this.dataFrame.getColumnKey(c) + ", " + this.dataFrame.getColumnName((Object)((String)this.dataFrame.getColumnKey(c))));
            if (this.dataFrame instanceof WrappedDataFrame && (column = ((WrappedDataFrame)this.dataFrame).getCalculatedColumnAt(c)) instanceof ExpressionCalculatedColumn) {
                ExpressionCalculatedColumn expressionCalculatedColumn = (ExpressionCalculatedColumn)column;
                variableElement.addAttribute(this.elementFactory.newAttribute("expression", expressionCalculatedColumn.getExpressionString()));
            }
            if ((pattern = this.getFormatPattern(c)) != null) {
                variableElement.addAttribute(this.elementFactory.newAttribute("pattern", pattern));
            }
            variableElement.addAttribute(this.elementFactory.newAttribute("showPopup", Boolean.toString(this.getSettings().getShowPopup(this.model.getTreeMapField(c)))));
            TreeMapField treeMapField = this.model.getTreeMapField(c);
            if (this.model.isNumericType(treeMapField) && treeMapField != null && (predefinedColorMap = this.model.getPredefinedColorMap((Object)((String)this.model.getTreeMapField(c).getIndex()))) != null && (interval = predefinedColorMap.getInterval()) != null) {
                variableElement.addAttribute(this.elementFactory.newAttribute("colorMin", Double.toString(interval.getStart())));
                variableElement.addAttribute(this.elementFactory.newAttribute("colorMax", Double.toString(interval.getEnd())));
            }
            this.saveSpecificSettings(c, this.getSettings().getFieldSettings(this.model.getTreeMapField(c)), variableElement);
            variables.appendChild(variableElement);
        }
        root.appendChild(variables);
        this.getSettings().save(this.dataFrame, this.elementFactory, root);
        try {
            Element treePlot = this.elementFactory.newElement("TreePlot");
            TreeMapField xVariable = (TreeMapField)this.getTreePlotModel().getXVariable().getSelected();
            TreeMapField yVariable = (TreeMapField)this.getTreePlotModel().getYVariable().getSelected();
            if (xVariable != null && yVariable != null) {
                if (xVariable.isValid()) {
                    String x = (String)xVariable.getIndex();
                    treePlot.addAttribute(this.elementFactory.newAttribute("xIndex", Integer.toString(this.dataFrame.getColumnAddress((Object)x))));
                    treePlot.addAttribute(this.elementFactory.newAttribute("xName", this.dataFrame.getColumnName((Object)x)));
                }
                if (yVariable.isValid()) {
                    String y = (String)yVariable.getIndex();
                    treePlot.addAttribute(this.elementFactory.newAttribute("yIndex", Integer.toString(this.dataFrame.getColumnAddress((Object)y))));
                    treePlot.addAttribute(this.elementFactory.newAttribute("yName", this.dataFrame.getColumnName((Object)y)));
                }
            }
            treePlot.addAttribute(this.elementFactory.newAttribute("background", this.colorFactory.getHTMLColor(this.getTreePlotModel().getSettings().getBackground())));
            treePlot.addAttribute(this.elementFactory.newAttribute("gridColor", this.colorFactory.getHTMLColor(this.getTreePlotModel().getSettings().getGridColor())));
            treePlot.addAttribute(this.elementFactory.newAttribute("gridThickness", Double.toString(this.getTreePlotModel().getSettings().getGridThickness())));
            treePlot.addAttribute(this.elementFactory.newAttribute("groupBy", Boolean.toString(this.getTreePlotModel().getSettings().getGroupBy())));
            treePlot.addAttribute(this.elementFactory.newAttribute("bubbleSize", Double.toString(this.getTreePlotModel().getSettings().getBubbleSizeInterval().getEnd())));
            root.appendChild(treePlot);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void saveGeneralSettings(TreeMapSettings settings, Element root) {
        String[] keys;
        for (String key : keys = new String[]{"depth", "rendering", "background", "tooltipBackground", "probingColor", "selectionColor", "hideSearchResults", "hideFilterResults", "dimensionFixed", "dimension", "lightSourceHeight", "lightSourceAmbient", "lightSourceX", "lightSourceY", "lightSourceZ", "progressive"}) {
            Object value = settings.getValue(key);
            if (value == null) continue;
            Object stringValue = null;
            if (value instanceof String) {
                stringValue = (String)value;
            } else if (value instanceof Boolean) {
                stringValue = Boolean.toString((Boolean)value);
            } else if (value instanceof Integer) {
                stringValue = Integer.toString((Integer)value);
            } else if (value instanceof Float) {
                stringValue = Float.toString(((Float)value).floatValue());
            } else if (value instanceof Double) {
                stringValue = Double.toString((Double)value);
            } else if (value instanceof CPColor) {
                stringValue = ((CPColor)value).toHTMLColor();
            } else if (value instanceof CPFont) {
                stringValue = value.toString();
            } else if (value instanceof Dimension) {
                Dimension dimension = (Dimension)value;
                stringValue = dimension.width + "; " + dimension.height;
            } else {
                stringValue = value.toString();
            }
            if (stringValue == null) continue;
            root.addAttribute(this.elementFactory.newAttribute(key, (String)stringValue));
        }
    }

    private void saveSpecificSettings(int column, TreeMapFieldSettings<Color, Font> settings, Element root) {
        TreeMapFieldSettings.PropertyType[] keys;
        for (TreeMapFieldSettings.PropertyType key : keys = new TreeMapFieldSettings.PropertyType[]{TreeMapFieldSettings.PropertyType.algorithm, TreeMapFieldSettings.PropertyType.aggregation, TreeMapFieldSettings.PropertyType.scale, TreeMapFieldSettings.PropertyType.nesting, TreeMapFieldSettings.PropertyType.ordering, TreeMapFieldSettings.PropertyType.orderingDirection, TreeMapFieldSettings.PropertyType.orderingHorizontalVanishingPoint, TreeMapFieldSettings.PropertyType.orderingVerticalVanishingPoint, TreeMapFieldSettings.PropertyType.labeling, TreeMapFieldSettings.PropertyType.labelingForeground, TreeMapFieldSettings.PropertyType.labelingEffectColor, TreeMapFieldSettings.PropertyType.labelingFont, TreeMapFieldSettings.PropertyType.labelingEffect, TreeMapFieldSettings.PropertyType.labelingHorizontalAlignment, TreeMapFieldSettings.PropertyType.labelingVerticalAlignment, TreeMapFieldSettings.PropertyType.labelingRendering, TreeMapFieldSettings.PropertyType.labelingMinimumCharactersToDisplay, TreeMapFieldSettings.PropertyType.labelingEffectOpacity, TreeMapFieldSettings.PropertyType.labelingShrinkTextToFitShape, TreeMapFieldSettings.PropertyType.labelingResizeTextToFitShape, TreeMapFieldSettings.PropertyType.labelingFloat, TreeMapFieldSettings.PropertyType.labelingContrastEnhancement, TreeMapFieldSettings.PropertyType.nestingAmount, TreeMapFieldSettings.PropertyType.nestingBackground, TreeMapFieldSettings.PropertyType.headerForeground, TreeMapFieldSettings.PropertyType.headerEffectColor, TreeMapFieldSettings.PropertyType.headerBackground, TreeMapFieldSettings.PropertyType.headerFont, TreeMapFieldSettings.PropertyType.headerEffect, TreeMapFieldSettings.PropertyType.headerHorizontalAlignment, TreeMapFieldSettings.PropertyType.headerVerticalAlignment, TreeMapFieldSettings.PropertyType.headerRendering, TreeMapFieldSettings.PropertyType.headerMinimumCharactersToDisplay, TreeMapFieldSettings.PropertyType.headerEffectOpacity, TreeMapFieldSettings.PropertyType.tooltipForeground, TreeMapFieldSettings.PropertyType.tooltipFont, TreeMapFieldSettings.PropertyType.tooltipRendering, TreeMapFieldSettings.PropertyType.borderColor, TreeMapFieldSettings.PropertyType.borderThickness, TreeMapFieldSettings.PropertyType.format, TreeMapFieldSettings.PropertyType.showLabel, TreeMapFieldSettings.PropertyType.colormap}) {
            Object value = settings.getPropertyOverride(key);
            if (value == null) continue;
            String stringValue = null;
            if (value instanceof String) {
                stringValue = (String)value;
            } else if (value instanceof Boolean) {
                stringValue = Boolean.toString((Boolean)value);
            } else if (value instanceof Integer) {
                stringValue = Integer.toString((Integer)value);
            } else if (value instanceof Float) {
                stringValue = Float.toString(((Float)value).floatValue());
            } else if (value instanceof Double) {
                stringValue = Double.toString((Double)value);
            } else if (value instanceof CPColor) {
                stringValue = ((CPColor)value).toHTMLColor();
            } else if (value instanceof CPColor) {
                stringValue = ((CPColor)value).toHTMLColor();
            } else if (value instanceof CPFont) {
                stringValue = value.toString();
            } else if (!(value instanceof CPFormat)) {
                if (value instanceof ColorMap) {
                    if (column >= 0) {
                        Double max;
                        Double min;
                        ColorMap colorMap = (ColorMap)value;
                        if (colorMap == this.model.getPredefinedColorMap((Object)((String)this.dataFrame.getColumnKey(column)))) {
                            stringValue = "predefined";
                            root.appendChild(this.colorMapState.savePredefinedColorMap((ColorMap)this.model.getPredefinedColorMap((Object)((String)this.dataFrame.getColumnKey(column)))));
                            min = this.model.getNumericMin(this.model.getTreeMapField(column));
                            max = this.model.getNumericMax(this.model.getTreeMapField(column));
                            root.appendChild(this.colorMapState.saveCustomColorMap(min, max, (ColorMap)this.model.getCustomColorMap((Object)((String)this.dataFrame.getColumnKey(column)))));
                        } else if (colorMap == this.model.getCustomColorMap((Object)((String)this.dataFrame.getColumnKey(column)))) {
                            stringValue = "custom";
                            root.appendChild(this.colorMapState.savePredefinedColorMap((ColorMap)this.model.getPredefinedColorMap((Object)((String)this.dataFrame.getColumnKey(column)))));
                            min = this.model.getNumericMin(this.model.getTreeMapField(column));
                            max = this.model.getNumericMax(this.model.getTreeMapField(column));
                            root.appendChild(this.colorMapState.saveCustomColorMap(min, max, (ColorMap)this.model.getCustomColorMap((Object)((String)this.dataFrame.getColumnKey(column)))));
                        } else if (colorMap == this.model.getCategoricalColorMap((Object)((String)this.dataFrame.getColumnKey(column)))) {
                            stringValue = "categorical";
                            root.appendChild(this.colorMapState.saveCategoricalColorMap((ColorMap)this.model.getCategoricalColorMap((Object)((String)this.dataFrame.getColumnKey(column)))));
                        }
                    }
                } else {
                    stringValue = value instanceof Enum ? ((Enum)value).name() : value.toString();
                }
            }
            if (stringValue == null) continue;
            root.addAttribute(this.elementFactory.newAttribute(key.toString(), stringValue));
        }
    }

    protected TreeMapField<?, String> locateVariable(int index, String name) {
        if (index >= 0 && index < this.dataFrame.getColumnCount()) {
            if (name.equals(this.dataFrame.getColumnName((Object)((String)this.dataFrame.getColumnKey(index))))) {
                return this.model.getTreeMapField(index);
            }
            if (name != null) {
                int c;
                for (c = 0; c < this.dataFrame.getColumnCount(); ++c) {
                    if (!name.equals(this.dataFrame.getColumnName((Object)((String)this.dataFrame.getColumnKey(c))))) continue;
                    return this.model.getTreeMapField(c);
                }
                for (c = 0; c < this.dataFrame.getColumnCount(); ++c) {
                    if (!name.equalsIgnoreCase(this.dataFrame.getColumnName((Object)((String)this.dataFrame.getColumnKey(c))))) continue;
                    return this.model.getTreeMapField(c);
                }
            }
            return new NoTreeMapField();
        }
        if (name != null) {
            int c;
            for (c = 0; c < this.dataFrame.getColumnCount(); ++c) {
                if (!name.equals(this.dataFrame.getColumnName((Object)((String)this.dataFrame.getColumnKey(c))))) continue;
                return this.model.getTreeMapField(c);
            }
            for (c = 0; c < this.dataFrame.getColumnCount(); ++c) {
                if (!name.equalsIgnoreCase(this.dataFrame.getColumnName((Object)((String)this.dataFrame.getColumnKey(c))))) continue;
                return this.model.getTreeMapField(c);
            }
        }
        return new NoTreeMapField();
    }

    protected int convertIndex(String index) {
        if (index != null) {
            return Integer.parseInt(index);
        }
        return -1;
    }

    public String getFormatPattern(int columnIndex) {
        CPFormat format = this.getSettings().getFieldSettings(this.model.getTreeMapField(columnIndex)).getFormat();
        if (format != null) {
            return format.getPattern();
        }
        return null;
    }

    public void setFormatPattern(String columnIndex, String pattern) {
        TreeMapField field = this.model.getTreeMapField((Object)columnIndex);
        if (this.model.isNumericType(field)) {
            this.model.getSettings().getFieldSettings(field).setFormat(this.formatFactory.createNumberFormat(pattern));
        } else if (this.model.isTemporalType(field)) {
            this.model.getSettings().getFieldSettings(field).setFormat(this.formatFactory.createDateFormat(pattern));
        }
    }
}

