/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.list.array;

import gnu.trove.TIntCollection;
import gnu.trove.func.TIntFunction;
import gnu.trove.impl.HashFunctions;
import gnu.trove.iterator.TIntIterator;
import gnu.trove.list.TIntList;
import gnu.trove.procedure.TIntProcedure;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class TIntArrayList
implements TIntList {
    protected int[] _data;
    protected int _pos;
    protected static final int DEFAULT_CAPACITY = 10;
    protected int no_entry_value;

    public TIntArrayList() {
        this(10, 0);
    }

    /*
     * WARNING - void declaration
     */
    public TIntArrayList(int capacity) {
        this((int)var1_1, 0);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public TIntArrayList(int capacity, int no_entry_value) {
        void var2_2;
        void var1_1;
        this._data = new int[var1_1];
        this._pos = 0;
        this.no_entry_value = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public TIntArrayList(TIntCollection collection) {
        this(collection.size());
        void var1_1;
        this.addAll((TIntCollection)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public TIntArrayList(int[] values) {
        this(values.length);
        void var1_1;
        this.add((int[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected TIntArrayList(int[] values, int no_entry_value, boolean wrap) {
        void var2_2;
        void var1_1;
        void var3_3;
        if (var3_3 == false) {
            throw new IllegalStateException("Wrong call");
        }
        if (values == null) {
            throw new IllegalArgumentException("values can not be null");
        }
        this._data = values;
        this._pos = ((void)var1_1).length;
        this.no_entry_value = var2_2;
    }

    public static TIntArrayList wrap(int[] values) {
        return TIntArrayList.wrap(values, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static TIntArrayList wrap(int[] values, int no_entry_value) {
        void var1_1;
        int[] nArray;
        return new TIntArrayList(nArray, (int)var1_1, true){

            @Override
            public final void ensureCapacity(int capacity) {
                if (capacity > this._data.length) {
                    throw new IllegalStateException("Can not grow ArrayList wrapped external array");
                }
            }
        };
    }

    @Override
    public int getNoEntryValue() {
        return this.no_entry_value;
    }

    public void ensureCapacity(int capacity) {
        if (capacity > this._data.length) {
            int n2;
            n2 = Math.max(this._data.length << 1, n2);
            int[] nArray = new int[n2];
            System.arraycopy(this._data, 0, nArray, 0, this._data.length);
            this._data = nArray;
        }
    }

    @Override
    public int size() {
        return this._pos;
    }

    @Override
    public boolean isEmpty() {
        return this._pos == 0;
    }

    public void trimToSize() {
        if (this._data.length > this.size()) {
            int[] nArray = new int[this.size()];
            this.toArray(nArray, 0, nArray.length);
            this._data = nArray;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean add(int val) {
        void var1_1;
        TIntArrayList tIntArrayList = this;
        tIntArrayList.ensureCapacity(tIntArrayList._pos + 1);
        this._data[this._pos++] = var1_1;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void add(int[] vals) {
        void var1_1;
        this.add(vals, 0, ((void)var1_1).length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void add(int[] vals, int offset, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        TIntArrayList tIntArrayList = this;
        tIntArrayList.ensureCapacity(tIntArrayList._pos + length);
        System.arraycopy(var1_1, (int)var2_2, this._data, this._pos, length);
        this._pos += var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void insert(int offset, int value) {
        void var2_2;
        if (offset == this._pos) {
            this.add(value);
            return;
        }
        TIntArrayList tIntArrayList = this;
        tIntArrayList.ensureCapacity(tIntArrayList._pos + 1);
        System.arraycopy(this._data, offset, this._data, offset + 1, this._pos - offset);
        this._data[var1_1] = var2_2;
        ++this._pos;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void insert(int offset, int[] values) {
        void var2_2;
        void var1_1;
        this.insert((int)var1_1, values, 0, ((void)var2_2).length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void insert(int offset, int[] values, int valOffset, int len) {
        void var1_1;
        void var3_3;
        void var2_2;
        if (offset == this._pos) {
            this.add(values, valOffset, len);
            return;
        }
        TIntArrayList tIntArrayList = this;
        tIntArrayList.ensureCapacity(tIntArrayList._pos + len);
        System.arraycopy(this._data, offset, this._data, offset + len, this._pos - offset);
        System.arraycopy(var2_2, (int)var3_3, this._data, (int)var1_1, len);
        this._pos += len;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int get(int offset) {
        void var1_1;
        if (offset >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        return this._data[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    public int getQuick(int offset) {
        void var1_1;
        return this._data[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int set(int offset, int val) {
        void var2_2;
        if (offset >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        int n2 = this._data[offset];
        this._data[var1_1] = var2_2;
        return n2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int replace(int offset, int val) {
        void var2_2;
        if (offset >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        int n2 = this._data[offset];
        this._data[var1_1] = var2_2;
        return n2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void set(int offset, int[] values) {
        void var2_2;
        void var1_1;
        this.set((int)var1_1, values, 0, ((void)var2_2).length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void set(int offset, int[] values, int valOffset, int length) {
        void var1_1;
        void var3_3;
        void var2_2;
        if (offset < 0 || offset + length > this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        System.arraycopy(var2_2, (int)var3_3, this._data, (int)var1_1, length);
    }

    /*
     * WARNING - void declaration
     */
    public void setQuick(int offset, int val) {
        void var2_2;
        this._data[var1_1] = var2_2;
    }

    @Override
    public void clear() {
        this.clear(10);
    }

    /*
     * WARNING - void declaration
     */
    public void clear(int capacity) {
        void var1_1;
        this._data = new int[var1_1];
        this._pos = 0;
    }

    public void reset() {
        this._pos = 0;
        Arrays.fill(this._data, this.no_entry_value);
    }

    public void resetQuick() {
        this._pos = 0;
    }

    @Override
    public boolean remove(int value) {
        for (int i2 = 0; i2 < this._pos; ++i2) {
            if (value != this._data[i2]) continue;
            this.remove(i2, 1);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int removeAt(int offset) {
        void var1_1;
        int n2 = this.get(offset);
        this.remove((int)var1_1, 1);
        return n2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void remove(int offset, int length) {
        void var2_2;
        if (length == 0) {
            return;
        }
        if (offset < 0 || offset >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        if (offset == 0) {
            System.arraycopy(this._data, length, this._data, 0, this._pos - length);
        } else if (this._pos - length != offset) {
            void var1_1;
            System.arraycopy(this._data, offset + length, this._data, offset, this._pos - (var1_1 + length));
        }
        this._pos -= var2_2;
    }

    @Override
    public TIntIterator iterator() {
        return new a(this, 0);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object obj : collection) {
            if (obj instanceof Integer) {
                int n2 = (Integer)obj;
                if (this.contains(n2)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(TIntCollection collection) {
        TIntIterator tIntIterator;
        if (this == collection) {
            return true;
        }
        tIntIterator = tIntIterator.iterator();
        while (tIntIterator.hasNext()) {
            int n2 = tIntIterator.next();
            if (this.contains(n2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(int[] array) {
        int n2 = array.length;
        while (n2-- > 0) {
            if (this.contains(array[n2])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Integer> collection) {
        Iterator iterator;
        boolean bl = false;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Integer n2 = (Integer)iterator.next();
            int n3 = n2;
            if (!this.add(n3)) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean addAll(TIntCollection collection) {
        TIntIterator tIntIterator;
        boolean bl = false;
        tIntIterator = tIntIterator.iterator();
        while (tIntIterator.hasNext()) {
            int n2 = tIntIterator.next();
            if (!this.add(n2)) continue;
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean addAll(int[] array) {
        void var1_1;
        boolean bl = false;
        for (void var5_5 : var1_1) {
            if (!this.add((int)var5_5)) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean bl = false;
        TIntIterator tIntIterator = this.iterator();
        while (tIntIterator.hasNext()) {
            if (collection.contains(tIntIterator.next())) continue;
            tIntIterator.remove();
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean retainAll(TIntCollection collection) {
        if (this == collection) {
            return false;
        }
        boolean bl = false;
        TIntIterator tIntIterator = this.iterator();
        while (tIntIterator.hasNext()) {
            if (collection.contains(tIntIterator.next())) continue;
            tIntIterator.remove();
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean retainAll(int[] array) {
        boolean bl = false;
        Arrays.sort(array);
        int[] nArray = this._data;
        int n2 = this._pos;
        while (n2-- > 0) {
            if (Arrays.binarySearch(array, nArray[n2]) >= 0) continue;
            this.remove(n2, 1);
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        Iterator iterator;
        boolean bl = false;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            int n2;
            Object e2 = iterator.next();
            if (!(e2 instanceof Integer) || !this.remove(n2 = ((Integer)e2).intValue())) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean removeAll(TIntCollection collection) {
        TIntIterator tIntIterator;
        if (collection == this) {
            this.clear();
            return true;
        }
        boolean bl = false;
        tIntIterator = tIntIterator.iterator();
        while (tIntIterator.hasNext()) {
            int n2 = tIntIterator.next();
            if (!this.remove(n2)) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean removeAll(int[] array) {
        boolean bl = false;
        int n2 = array.length;
        while (n2-- > 0) {
            if (!this.remove(array[n2])) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public void transformValues(TIntFunction func) {
        int n2 = this._pos;
        while (n2-- > 0) {
            this._data[n2] = func.execute(this._data[n2]);
        }
    }

    @Override
    public void reverse() {
        this.reverse(0, this._pos);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void reverse(int from, int to) {
        void var1_1;
        void var2_2;
        if (from == to) {
            return;
        }
        if (from > to) {
            throw new IllegalArgumentException("from cannot be greater than to");
        }
        --var2_2;
        while (var1_1 < var2_2) {
            void var5_5 = var2_2--;
            void var4_4 = var1_1++;
            TIntArrayList tIntArrayList = this;
            int n2 = tIntArrayList._data[var4_4];
            tIntArrayList._data[var4_4] = tIntArrayList._data[var5_5];
            tIntArrayList._data[var5_5] = n2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public TIntList subList(int begin, int end) {
        void var1_1;
        if (end < begin) {
            throw new IllegalArgumentException("end index " + end + " greater than begin index " + begin);
        }
        if (begin < 0) {
            throw new IndexOutOfBoundsException("begin index can not be < 0");
        }
        if (end > this._data.length) {
            throw new IndexOutOfBoundsException("end index < " + this._data.length);
        }
        TIntArrayList tIntArrayList = new TIntArrayList(end - begin);
        while (var1_1 < end) {
            tIntArrayList.add(this._data[var1_1]);
            ++var1_1;
        }
        return tIntArrayList;
    }

    @Override
    public int[] toArray() {
        return this.toArray(0, this._pos);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int[] toArray(int offset, int len) {
        void var2_2;
        void var1_1;
        int[] nArray = new int[len];
        this.toArray(nArray, (int)var1_1, (int)var2_2);
        return nArray;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int[] toArray(int[] dest) {
        void var1_1;
        int n2 = dest.length;
        if (dest.length > this._pos) {
            n2 = this._pos;
            dest[n2] = this.no_entry_value;
        }
        this.toArray(dest, 0, n2);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int[] toArray(int[] dest, int offset, int len) {
        void var1_1;
        void var3_3;
        void var2_2;
        if (len == 0) {
            return dest;
        }
        if (offset < 0 || offset >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        System.arraycopy(this._data, (int)var2_2, dest, 0, (int)var3_3);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int[] toArray(int[] dest, int source_pos, int dest_pos, int len) {
        void var1_1;
        void var3_3;
        void var2_2;
        if (len == 0) {
            return dest;
        }
        if (source_pos < 0 || source_pos >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(source_pos);
        }
        System.arraycopy(this._data, (int)var2_2, dest, (int)var3_3, len);
        return var1_1;
    }

    @Override
    public boolean equals(Object other) {
        TIntList tIntList;
        if (other == this) {
            return true;
        }
        if (!(other instanceof TIntList)) {
            return false;
        }
        if (other instanceof TIntArrayList) {
            tIntList = (TIntArrayList)other;
            if (((TIntArrayList)tIntList).size() != this.size()) {
                return false;
            }
            int n2 = this._pos;
            while (n2-- > 0) {
                if (this._data[n2] == ((TIntArrayList)tIntList)._data[n2]) continue;
                return false;
            }
            return true;
        }
        if ((tIntList = (TIntList)tIntList).size() != this.size()) {
            return false;
        }
        for (int i2 = 0; i2 < this._pos; ++i2) {
            if (this._data[i2] == tIntList.get(i2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n2 = 0;
        int n3 = this._pos;
        while (n3-- > 0) {
            n2 += HashFunctions.hash(this._data[n3]);
        }
        return n2;
    }

    @Override
    public boolean forEach(TIntProcedure procedure) {
        for (int i2 = 0; i2 < this._pos; ++i2) {
            if (procedure.execute(this._data[i2])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean forEachDescending(TIntProcedure procedure) {
        int n2 = this._pos;
        while (n2-- > 0) {
            if (procedure.execute(this._data[n2])) continue;
            return false;
        }
        return true;
    }

    @Override
    public void sort() {
        Arrays.sort(this._data, 0, this._pos);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void sort(int fromIndex, int toIndex) {
        void var2_2;
        void var1_1;
        Arrays.sort(this._data, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fill(int val) {
        void var1_1;
        Arrays.fill(this._data, 0, this._pos, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fill(int fromIndex, int toIndex, int val) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (toIndex > this._pos) {
            this.ensureCapacity(toIndex);
            this._pos = toIndex;
        }
        Arrays.fill(this._data, (int)var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int binarySearch(int value) {
        void var1_1;
        return this.binarySearch((int)var1_1, 0, this._pos);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int binarySearch(int value, int fromIndex, int toIndex) {
        void var2_2;
        void var3_3;
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        if (toIndex > this._pos) {
            throw new ArrayIndexOutOfBoundsException(toIndex);
        }
        --var3_3;
        while (var2_2 <= var3_3) {
            void var4_4 = var2_2 + var3_3 >>> 1;
            int n2 = this._data[var4_4];
            if (n2 < value) {
                var2_2 = var4_4 + true;
                continue;
            }
            if (n2 > value) {
                var3_3 = var4_4 - true;
                continue;
            }
            return (int)var4_4;
        }
        return (int)(-(var2_2 + true));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int indexOf(int value) {
        void var1_1;
        return this.indexOf(0, (int)var1_1);
    }

    @Override
    public int indexOf(int offset, int value) {
        for (int i2 = offset; i2 < this._pos; ++i2) {
            if (this._data[i2] != value) continue;
            return i2;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int lastIndexOf(int value) {
        void var1_1;
        TIntArrayList tIntArrayList = this;
        return tIntArrayList.lastIndexOf(tIntArrayList._pos, (int)var1_1);
    }

    @Override
    public int lastIndexOf(int offset, int value) {
        int n2 = offset;
        while (n2-- > 0) {
            if (this._data[n2] != value) continue;
            return n2;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean contains(int value) {
        void var1_1;
        return this.lastIndexOf((int)var1_1) >= 0;
    }

    @Override
    public TIntList grep(TIntProcedure condition) {
        TIntArrayList tIntArrayList = new TIntArrayList();
        for (int i2 = 0; i2 < this._pos; ++i2) {
            if (!condition.execute(this._data[i2])) continue;
            tIntArrayList.add(this._data[i2]);
        }
        return tIntArrayList;
    }

    @Override
    public TIntList inverseGrep(TIntProcedure condition) {
        TIntArrayList tIntArrayList = new TIntArrayList();
        for (int i2 = 0; i2 < this._pos; ++i2) {
            if (condition.execute(this._data[i2])) continue;
            tIntArrayList.add(this._data[i2]);
        }
        return tIntArrayList;
    }

    @Override
    public int max() {
        if (this.size() == 0) {
            throw new IllegalStateException("cannot find maximum of an empty list");
        }
        int n2 = Integer.MIN_VALUE;
        for (int i2 = 0; i2 < this._pos; ++i2) {
            if (this._data[i2] <= n2) continue;
            n2 = this._data[i2];
        }
        return n2;
    }

    @Override
    public int min() {
        if (this.size() == 0) {
            throw new IllegalStateException("cannot find minimum of an empty list");
        }
        int n2 = Integer.MAX_VALUE;
        for (int i2 = 0; i2 < this._pos; ++i2) {
            if (this._data[i2] >= n2) continue;
            n2 = this._data[i2];
        }
        return n2;
    }

    @Override
    public int sum() {
        int n2 = 0;
        for (int i2 = 0; i2 < this._pos; ++i2) {
            n2 += this._data[i2];
        }
        return n2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("{");
        int n2 = this._pos - 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append(this._data[i2]);
            stringBuilder.append(", ");
        }
        if (this.size() > 0) {
            stringBuilder.append(this._data[this._pos - 1]);
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    final class a
    implements TIntIterator {
        private int a = 0;
        private int b = -1;
        private /* synthetic */ TIntArrayList c;

        a(TIntArrayList tIntArrayList, int n2) {
            this.c = tIntArrayList;
        }

        @Override
        public final boolean hasNext() {
            return this.a < this.c.size();
        }

        @Override
        public final int next() {
            try {
                int n2 = this.c.get(this.a);
                this.b = this.a++;
                return n2;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public final void remove() {
            if (this.b == -1) {
                throw new IllegalStateException();
            }
            try {
                this.c.remove(this.b, 1);
                if (this.b < this.a) {
                    --this.a;
                }
                this.b = -1;
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

