/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data;

import com.macrofocus.data.AbstractDataModel;
import com.macrofocus.data.DataModel;

public class CombinedDataModel
extends AbstractDataModel {
    private DataModel dataModel1;
    private DataModel dataModel2;

    public CombinedDataModel(DataModel dataModel1, DataModel dataModel2) {
        this.dataModel1 = dataModel1;
        this.dataModel2 = dataModel2;
    }

    @Override
    public boolean isAvailable(int row, int column) {
        if (column < this.dataModel1.getColumnCount()) {
            return this.dataModel1.isAvailable(row, column);
        }
        return this.dataModel2.isAvailable(row, column - this.dataModel1.getColumnCount());
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (column < this.dataModel1.getColumnCount()) {
            return this.dataModel1.getValueAt(row, column);
        }
        return this.dataModel2.getValueAt(row, column - this.dataModel1.getColumnCount());
    }

    @Override
    public Object getColumnName(int column) {
        if (column < this.dataModel1.getColumnCount()) {
            return this.dataModel1.getColumnName(column);
        }
        return this.dataModel2.getColumnName(column - this.dataModel1.getColumnCount());
    }

    @Override
    public int getColumnIndex(Object name) {
        int index = this.dataModel1.getColumnIndex(name);
        if (index >= 0) {
            return index;
        }
        return this.dataModel2.getColumnIndex(name) + this.dataModel1.getColumnCount();
    }

    @Override
    public Class getColumnClass(int column) {
        if (column < this.dataModel1.getColumnCount()) {
            return this.dataModel1.getColumnClass(column);
        }
        return this.dataModel2.getColumnClass(column - this.dataModel1.getColumnCount());
    }

    @Override
    public int getRowCount() {
        return Math.min(this.dataModel1.getRowCount(), this.dataModel2.getRowCount());
    }

    @Override
    public int getColumnCount() {
        return this.dataModel1.getColumnCount() + this.dataModel2.getColumnCount();
    }
}

