/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data;

import com.macrofocus.data.AbstractDataModel;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class SheetDataModel
extends AbstractDataModel {
    private Sheet sheet;
    private int columnCount;
    private int rowCount;
    private Class[] classes;

    public SheetDataModel(Sheet sheet) {
        this.sheet = sheet;
        this.columnCount = 0;
        this.rowCount = 0;
        for (int r = sheet.getFirstRowNum(); r <= sheet.getLastRowNum(); ++r) {
            Row row = sheet.getRow(r);
            if (this.columnCount < row.getLastCellNum() - row.getFirstCellNum()) {
                this.columnCount = row.getLastCellNum() - row.getFirstCellNum();
            }
            boolean empty = true;
            for (int c = row.getFirstCellNum(); c < row.getLastCellNum() - row.getFirstCellNum(); ++c) {
                Cell cell = row.getCell((int)((short)c));
                if (cell == null || cell.getCellType() == CellType.BLANK) continue;
                empty = false;
            }
            if (empty) continue;
            ++this.rowCount;
        }
        this.classes = new Class[this.columnCount];
        for (int i = 0; i < this.classes.length; ++i) {
            this.classes[i] = String.class;
        }
    }

    @Override
    public boolean isAvailable(int row, int column) {
        return column < this.columnCount && this.getValueAt(row, column) != null;
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (column < this.columnCount) {
            Row r = this.sheet.getRow(row + 1);
            if (r != null) {
                Cell cell = r.getCell((int)((short)(column - r.getFirstCellNum())));
                if (cell != null) {
                    if (cell.getCellType() == CellType.BLANK) {
                        return null;
                    }
                    if (cell.getCellType() == CellType.BOOLEAN) {
                        return Boolean.toString(cell.getBooleanCellValue());
                    }
                    if (cell.getCellType() == CellType.ERROR) {
                        return null;
                    }
                    if (cell.getCellType() == CellType.FORMULA) {
                        double icl = cell.getNumericCellValue();
                        if (!Double.isNaN(icl)) {
                            return Double.toString(icl);
                        }
                        RichTextString rich = cell.getRichStringCellValue();
                        if (rich != null) {
                            return rich.getString();
                        }
                        return null;
                    }
                    if (cell.getCellType() == CellType.NUMERIC) {
                        double d = cell.getNumericCellValue();
                        if (!Double.isInfinite(d)) {
                            return Double.toString(d);
                        }
                        System.err.println(String.valueOf(cell) + " " + cell.getNumericCellValue());
                        return null;
                    }
                    if (cell.getCellType() == CellType.STRING) {
                        String string = cell.getRichStringCellValue().getString();
                        if (string != null) {
                            return string.trim();
                        }
                        return null;
                    }
                    return null;
                }
                return null;
            }
            return null;
        }
        return null;
    }

    @Override
    public Object getColumnName(int column) {
        Row row = this.sheet.getRow(0);
        Cell cell = row.getCell((int)((short)(column - row.getFirstCellNum())));
        if (cell != null) {
            if (cell.getCellType() == CellType.BLANK) {
                return "Column " + column;
            }
            if (cell.getCellType() == CellType.BOOLEAN) {
                return Boolean.toString(cell.getBooleanCellValue());
            }
            if (cell.getCellType() == CellType.ERROR) {
                return "Column " + column;
            }
            if (cell.getCellType() == CellType.FORMULA) {
                return "Column " + column;
            }
            if (cell.getCellType() == CellType.NUMERIC) {
                return Double.toString(cell.getNumericCellValue());
            }
            if (cell.getCellType() == CellType.STRING) {
                String string = cell.getRichStringCellValue().getString();
                return string.trim();
            }
            return "Column " + column;
        }
        return null;
    }

    @Override
    public Class getColumnClass(int column) {
        return this.classes[column];
    }

    @Override
    public int getRowCount() {
        return this.rowCount - 1;
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }
}

