/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.column;

import com.macrofocus.data.column.ColumnModel;
import java.util.Vector;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class ColumnTreeModelAdapter
implements TreeModel {
    private ColumnModel columnModel;
    private Vector listeners;

    public ColumnTreeModelAdapter(ColumnModel columnModel) {
        this.columnModel = columnModel;
        this.listeners = new Vector();
    }

    @Override
    public Object getRoot() {
        return new ColumnObjectModel(this.columnModel, -1);
    }

    @Override
    public Object getChild(Object parent, int index) {
        return new ColumnObjectModel(this.columnModel, index);
    }

    @Override
    public int getChildCount(Object parent) {
        return this.columnModel.getRowCount();
    }

    @Override
    public boolean isLeaf(Object node) {
        ColumnObjectModel columnObjectModel = (ColumnObjectModel)node;
        return columnObjectModel.getIndex() >= 0;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        if (this.columnModel.isEditable()) {
            ColumnObjectModel columnObjectModel = (ColumnObjectModel)path.getLastPathComponent();
            this.columnModel.setObject(columnObjectModel.getIndex(), newValue);
            this.treeModelChanged(new TreeModelEvent((Object)this, path));
        }
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (child != null) {
            ColumnObjectModel columnObjectModel = (ColumnObjectModel)child;
            return columnObjectModel.getIndex();
        }
        return -1;
    }

    @Override
    public void addTreeModelListener(TreeModelListener listener) {
        this.listeners.addElement(listener);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener listener) {
        this.listeners.removeElement(listener);
    }

    private void treeModelChanged(TreeModelEvent event) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            TreeModelListener listener = (TreeModelListener)this.listeners.elementAt(i);
            listener.treeNodesChanged(event);
        }
    }

    private class ColumnObjectModel {
        private ColumnModel columnModel;
        private int index;

        public ColumnObjectModel(ColumnModel columnModel, int index) {
            this.columnModel = columnModel;
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public String toString() {
            if (this.index >= 0) {
                return this.columnModel.getObject(this.index).toString();
            }
            return this.columnModel.getName().toString();
        }
    }
}

