/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.db;

import com.macrofocus.data.db.JDBCDatabaseDriver;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

public class JTDSSQLServerDatabaseDriver
extends JDBCDatabaseDriver {
    private static final String className = "net.sourceforge.jtds.jdbc.Driver";

    public static boolean exist() {
        return JTDSSQLServerDatabaseDriver.exist(className);
    }

    @Override
    public String getClassName() {
        return className;
    }

    @Override
    public String getPrefix() {
        return "jtds:sqlserver";
    }

    @Override
    public Iterable<String> getDatabases(String host, String username, String password) throws SQLException {
        Connection conn = this.getConnection(this.getURL(host, null, username, password), username, password);
        ArrayList<String> databases = new ArrayList<String>();
        ResultSet schemas = conn.getMetaData().getCatalogs();
        while (schemas.next()) {
            databases.add(schemas.getString(1));
        }
        return databases;
    }

    @Override
    public Iterable<String> getTables(String url, String database, String username, String password) throws SQLException {
        Connection conn = this.getConnection(url, username, password);
        ArrayList<String> tables = new ArrayList<String>();
        DatabaseMetaData meta = conn.getMetaData();
        ResultSet result = meta.getTables(null, null, "%", new String[]{"TABLE"});
        while (result.next()) {
            Object tableName = result.getString("TABLE_NAME");
            String schemaName = result.getString("TABLE_SCHEM");
            if (schemaName != null) {
                tableName = schemaName + "." + (String)tableName;
            }
            tables.add((String)tableName);
        }
        return tables;
    }

    public String toString() {
        return "Microsoft SQL Server (jTDS)";
    }

    @Override
    public String getURL(String host, String schema, String username, String password) {
        String url = "jdbc:" + this.getPrefix() + ":";
        if (host != null) {
            url = url + "//" + host;
        }
        if (schema != null) {
            url = url + "/" + schema;
        }
        return url;
    }
}

