/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.matrix.vector;

import com.macrofocus.data.matrix.vector.AbstractVectorModel;
import com.macrofocus.data.matrix.vector.VectorModel;

public class SimpleVectorModel
extends AbstractVectorModel {
    private final double[] values;
    private final boolean[] isAvailable;
    private final Object name;

    public SimpleVectorModel(VectorModel vectorModel) {
        this.name = vectorModel.getName();
        this.values = new double[vectorModel.getRowCount()];
        this.isAvailable = new boolean[vectorModel.getRowCount()];
        for (int row = 0; row < vectorModel.getRowCount(); ++row) {
            this.isAvailable[row] = vectorModel.isAvailable(row);
            if (!this.isAvailable[row]) continue;
            this.values[row] = vectorModel.getDouble(row);
        }
    }

    public SimpleVectorModel(int size) {
        this(size, 0.0);
    }

    public SimpleVectorModel(int size, double value) {
        this(null, size, value);
    }

    public SimpleVectorModel(Object name, int size, double value) {
        this.name = name;
        this.values = new double[size];
        this.isAvailable = new boolean[size];
        for (int i = 0; i < size; ++i) {
            this.values[i] = value;
            this.isAvailable[i] = true;
        }
    }

    public SimpleVectorModel(double[] values) {
        this(null, values);
    }

    public SimpleVectorModel(Object name, double[] values) {
        this.name = name;
        this.values = values;
        this.isAvailable = new boolean[values.length];
        for (int i = 0; i < values.length; ++i) {
            this.isAvailable[i] = true;
        }
    }

    @Override
    public boolean isAvailable(int index) {
        return this.isAvailable[index];
    }

    @Override
    public double getDouble(int index) {
        return this.values[index];
    }

    @Override
    public Object getName() {
        return this.name;
    }

    @Override
    public Class getMembership() {
        return Double.class;
    }

    @Override
    public int getRowCount() {
        return this.values.length;
    }
}

