/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.source;

import com.google.gdata.client.spreadsheet.SpreadsheetService;
import com.google.gdata.data.spreadsheet.SpreadsheetEntry;
import com.google.gdata.data.spreadsheet.SpreadsheetFeed;
import com.google.gdata.data.spreadsheet.WorksheetEntry;
import com.google.gdata.util.AuthenticationException;
import com.google.gdata.util.ServiceException;
import com.macrofocus.application.ApplicationModel;
import com.macrofocus.data.source.AbstractDataSource;
import com.macrofocus.data.table.SpreadsheetServiceTableModel;
import com.macrofocus.persistence.Element;
import com.macrofocus.persistence.ElementFactory;
import com.macrofocus.util.logging.SwingLogging;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.TableModel;
import nu.xom.Document;

public class GoogleSpreadsheetDataSource
extends AbstractDataSource {
    static final String type = "GoogleSpreadsheet";
    private final String username;
    private final String password;
    private final String spreadsheet;

    public GoogleSpreadsheetDataSource(String username, String password, String spreadsheet) {
        this.username = username;
        this.password = password;
        this.spreadsheet = spreadsheet;
    }

    public String getType() {
        return type;
    }

    public GoogleSpreadsheetDataSource(nu.xom.Element root) {
        this.username = root.getAttributeValue("username");
        this.password = root.getAttributeValue("password");
        this.spreadsheet = root.getAttributeValue("spreadsheet");
    }

    @Override
    public Element save(File file, ElementFactory factory) {
        Element dataSource = factory.newElement("DataSource");
        dataSource.addAttribute(factory.newAttribute("type", this.getType()));
        dataSource.addAttribute(factory.newAttribute("username", this.username));
        dataSource.addAttribute(factory.newAttribute("password", this.password));
        dataSource.addAttribute(factory.newAttribute("spreadsheet", this.spreadsheet));
        return dataSource;
    }

    @Override
    public TableModel loadTableModel(Component contentPane) throws IOException, SQLException {
        SpreadsheetService service = new SpreadsheetService("macrofocus-data");
        try {
            service.setUserCredentials(this.username, this.password);
            URL metafeedUrl = new URL("http://spreadsheets.google.com/feeds/spreadsheets/private/full");
            SpreadsheetFeed feed = (SpreadsheetFeed)service.getFeed(metafeedUrl, SpreadsheetFeed.class);
            List spreadsheets = feed.getEntries();
            for (int i = 0; i < spreadsheets.size(); ++i) {
                SpreadsheetEntry entry = (SpreadsheetEntry)spreadsheets.get(i);
                if (!entry.getTitle().getPlainText().equals(this.spreadsheet)) continue;
                WorksheetEntry worksheetEntry = entry.getDefaultWorksheet();
                URL cellFeedUrl = worksheetEntry.getCellFeedUrl();
                SpreadsheetServiceTableModel tableModel = new SpreadsheetServiceTableModel(service, cellFeedUrl);
                return tableModel;
            }
        }
        catch (AuthenticationException e) {
            SwingLogging.getInstance().process(contentPane, (Throwable)e);
        }
        catch (ServiceException e) {
            SwingLogging.getInstance().process(contentPane, (Throwable)e);
        }
        return null;
    }

    public static List<String> listSpreadsheets(String username, String password) throws ServiceException, IOException {
        ArrayList<String> list = new ArrayList<String>();
        SpreadsheetService service = new SpreadsheetService("macrofocus-data");
        service.setUserCredentials(username, password);
        URL metafeedUrl = new URL("http://spreadsheets.google.com/feeds/spreadsheets/private/full");
        SpreadsheetFeed feed = (SpreadsheetFeed)service.getFeed(metafeedUrl, SpreadsheetFeed.class);
        List spreadsheets = feed.getEntries();
        for (int i = 0; i < spreadsheets.size(); ++i) {
            SpreadsheetEntry entry = (SpreadsheetEntry)spreadsheets.get(i);
            list.add(entry.getTitle().getPlainText());
        }
        return list;
    }

    @Override
    public Document getDocument(ApplicationModel applicationModel) {
        return null;
    }
}

