/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.source;

import com.macrofocus.application.ApplicationModel;
import com.macrofocus.data.DataModel;
import com.macrofocus.data.reader.PerfectDataReader;
import com.macrofocus.data.reader.TokenizerFactory;
import com.macrofocus.data.serial.MacrofocusObjectInputStream;
import com.macrofocus.data.source.DataSourceFactory;
import com.macrofocus.data.source.FileURLDataSource;
import com.macrofocus.data.source.InfoScopeObjectInputStream;
import com.macrofocus.data.source.SimpleInfoModel;
import com.macrofocus.data.table.DataModelTableModel;
import com.macrofocus.data.table.RowMajorTableModel;
import com.macrofocus.util.file.CharsetToolkit;
import com.macrofocus.util.logging.SwingLogging;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URL;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.table.TableModel;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.ParsingException;

public class InfoScopeDataSource
extends FileURLDataSource {
    static final String type = "InfoScope";
    private TableModel tableModel;
    private Document doc;

    public InfoScopeDataSource(File file) {
        super(file);
    }

    public InfoScopeDataSource(URL url) {
        super(url);
    }

    @Override
    public String getType() {
        return type;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public TableModel loadTableModel(Component contentPane) throws IOException, SQLException {
        BufferedInputStream bis;
        block30: {
            block28: {
                byte[] magic4;
                byte[] xmlmagic;
                block29: {
                    bis = this.getInputStream(this.checkContentPane(contentPane));
                    bis.mark(4);
                    byte[] zipmagic = new byte[]{80, 75, 3, 4};
                    byte[] gzipmagic = new byte[]{31, -117, 8};
                    xmlmagic = new byte[]{60, 63, 120, 109};
                    magic4 = new byte[4];
                    bis.read(magic4);
                    byte[] magic3 = new byte[3];
                    System.arraycopy(magic4, 0, magic3, 0, magic3.length);
                    bis.reset();
                    if (Arrays.equals(zipmagic, magic4)) break block28;
                    if (!Arrays.equals(gzipmagic, magic3)) break block29;
                    MacrofocusObjectInputStream oin = new MacrofocusObjectInputStream(new GZIPInputStream(bis));
                    Object object = null;
                    try {
                        object = oin.readObject();
                    }
                    catch (ClassNotFoundException e) {
                        SwingLogging.getInstance().process(contentPane, (Throwable)e);
                    }
                    this.tableModel = object instanceof DataModel ? new DataModelTableModel((DataModel)object) : (object instanceof TableModel ? (TableModel)object : null);
                    break block30;
                }
                if (Arrays.equals(xmlmagic, magic4)) {
                    Builder builder = new Builder(false);
                    Document treemap = null;
                    try {
                        treemap = builder.build((InputStream)bis);
                    }
                    catch (ParsingException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    assert (treemap != null);
                    Element root = treemap.getRootElement();
                    try {
                        this.tableModel = DataSourceFactory.getDataSource(this.file != null ? this.file.getParentFile() : null, root, type).load(null);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                    this.doc = treemap;
                    break block30;
                } else {
                    PerfectDataReader dataReader = new PerfectDataReader(new CharsetToolkit(bis).getReader(), TokenizerFactory.getTabDelimitedInstance(), true, false, "String");
                    dataReader.setFileLoader(this.getFileLoader());
                    this.tableModel = new RowMajorTableModel(dataReader);
                    bis.close();
                }
                break block30;
            }
            ZipInputStream zin = new ZipInputStream(bis);
            Builder builder = new Builder(false);
            Document infoscope = null;
            try {
                ZipEntry entry;
                while ((entry = zin.getNextEntry()) != null) {
                    Object object;
                    ObjectInputStream oin;
                    if ("datasource.ser".equals(entry.getName())) {
                        oin = new MacrofocusObjectInputStream(zin);
                        object = null;
                        try {
                            object = oin.readObject();
                        }
                        catch (ClassNotFoundException e) {
                            SwingLogging.getInstance().process(contentPane, (Throwable)e);
                        }
                        if (object instanceof DataModel) {
                            this.tableModel = new DataModelTableModel((DataModel)object);
                            continue;
                        }
                        if (object instanceof TableModel) {
                            this.tableModel = (TableModel)object;
                            continue;
                        }
                        this.tableModel = null;
                        continue;
                    }
                    if ("infoscope.xml".equals(entry.getName())) {
                        try {
                            infoscope = builder.build((InputStream)zin);
                            break;
                        }
                        catch (ParsingException e) {
                            e.printStackTrace();
                            continue;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            continue;
                        }
                    }
                    if ("InfoModel.ser".equals(entry.getName())) {
                        oin = new InfoScopeObjectInputStream(zin);
                        object = null;
                        try {
                            object = oin.readObject();
                            if (object instanceof SimpleInfoModel) {
                                this.tableModel = new DataModelTableModel(((SimpleInfoModel)object).getRawDataModel());
                                continue;
                            }
                            this.tableModel = null;
                            continue;
                        }
                        catch (ClassNotFoundException e) {
                            SwingLogging.getInstance().process(contentPane, (Throwable)e);
                            continue;
                        }
                    }
                    zin.closeEntry();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.doc = infoscope;
        }
        bis.close();
        return this.tableModel;
    }

    @Override
    public Document getDocument(ApplicationModel applicationModel) {
        return this.doc;
    }
}

