/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.type.convert;

import com.macrofocus.common.convert.TypeConverter;
import com.macrofocus.data.type.convert.AbstractTypeConverter;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class ToDateTypeConverter
extends AbstractTypeConverter {
    final DateFormat[] dateFormats = new DateFormat[]{new StrictSimpleDateFormat("MM/dd/yyyy"), new StrictSimpleDateFormat("MM/dd/yy"), new StrictSimpleDateFormat("M/d/yyyy"), new StrictSimpleDateFormat("yyyy-MM-dd"), new StrictSimpleDateFormat("yyyy/MM/dd"), new StrictSimpleDateFormat("dd.MM.yyyy HH:mm:ss"), new StrictSimpleDateFormat("dd.MM.yyyy HH:mm"), new StrictSimpleDateFormat("yyyy-MM-dd HH:mm:ss"), new StrictSimpleDateFormat("dd.MM.yyyy"), new StrictSimpleDateFormat("d.M.yyyy"), new StrictSimpleDateFormat("M/d/yy H:mm")};
    private DateFormat dateFormat;

    public boolean isConvertable(TypeConverter.Input input) {
        if (input.getType() != Date.class) {
            for (DateFormat format : this.dateFormats) {
                if (!this.isConvertableToDate(input, format)) continue;
                this.dateFormat = format;
                return true;
            }
        }
        this.dateFormat = null;
        return false;
    }

    public Class convert(TypeConverter.Input input, TypeConverter.Output output) {
        for (int row = 0; row < input.size(); ++row) {
            Object v = input.get(row);
            if (v == null) continue;
            if (v instanceof String) {
                String s = ((String)v).trim();
                if (!s.equals("")) {
                    boolean parsed = false;
                    try {
                        output.set(row, ToDateTypeConverter.parse(this.dateFormat, s));
                        parsed = true;
                    }
                    catch (ParseException e1) {
                        e1.printStackTrace();
                    }
                    if (parsed) continue;
                    output.set(row, null);
                    continue;
                }
                output.set(row, null);
                continue;
            }
            if (v instanceof Date) continue;
            output.set(row, null);
        }
        return Date.class;
    }

    private boolean isConvertableToDate(TypeConverter.Input input, DateFormat format) {
        boolean allNull = true;
        for (int row = 0; row < input.size(); ++row) {
            Object v = input.get(row);
            if (v == null) continue;
            if (v instanceof String) {
                String s = ((String)v).trim();
                if (s.equals("")) continue;
                allNull = false;
                boolean parsed = false;
                try {
                    ToDateTypeConverter.parse(format, s);
                    parsed = true;
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                if (parsed) continue;
                return false;
            }
            if (v instanceof Date) continue;
            return false;
        }
        return !allNull;
    }

    public Class getType() {
        return Date.class;
    }

    public static class StrictSimpleDateFormat
    extends SimpleDateFormat {
        protected boolean strict = true;

        public StrictSimpleDateFormat() {
            this.setStrict(true);
        }

        public StrictSimpleDateFormat(String pattern) {
            super(pattern);
            this.setStrict(true);
        }

        public StrictSimpleDateFormat(String pattern, DateFormatSymbols formatSymbols) {
            super(pattern, formatSymbols);
            this.setStrict(true);
        }

        public StrictSimpleDateFormat(String pattern, Locale locale) {
            super(pattern, locale);
            this.setStrict(true);
        }

        public void setStrict(boolean strict) {
            this.strict = strict;
            if (strict) {
                this.setLenient(false);
            }
        }

        public boolean getStrict() {
            return this.strict;
        }

        @Override
        public Date parse(String text, ParsePosition pos) {
            String format;
            int posIndex = pos.getIndex();
            Date d = super.parse(text, pos);
            if (this.strict && d != null && (posIndex + (format = this.format(d)).length() != text.length() || !text.endsWith(format))) {
                d = null;
            }
            return d;
        }

        public String toString() {
            return "StrictSimpleDateFormat{strict=" + this.strict + ",pattern=" + this.toPattern() + "}";
        }
    }
}

