/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.type.series;

import com.macrofocus.data.type.series.Series;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class OrderedSeries<T>
implements Series<T> {
    private final List<T> ordered;
    private final Class<? extends T> type;

    public OrderedSeries(Series<T> series) {
        this.type = series.getType();
        this.ordered = new ArrayList<T>(series.getItemCount());
        for (int i = 0; i < series.getItemCount(); ++i) {
            this.ordered.add(series.getValue(i));
        }
        Collections.sort(this.ordered);
    }

    @Override
    public Class<? extends T> getType() {
        return this.type;
    }

    @Override
    public T getValue(int index) {
        return this.ordered.get(index);
    }

    @Override
    public int getItemCount() {
        return this.ordered.size();
    }
}

