/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.action;

import com.jidesoft.grid.TreeTable;
import com.macrofocus.resources.ResourcesModel;
import com.macrofocus.resources.properties.PropertiesEvent;
import com.macrofocus.resources.properties.PropertiesListener;
import com.macrofocus.resources.properties.PropertiesModel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.net.URL;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.KeyStroke;

public class PrintTreeTableAction
extends AbstractAction {
    private TreeTable treeTable;

    public PrintTreeTableAction(ResourcesModel resourcesModel) {
        URL url = resourcesModel.getUrl("Print16.gif");
        if (url != null) {
            this.putValue("SmallIcon", new ImageIcon(url));
        }
        final PropertiesModel propertiesModel = resourcesModel.getPropertiesModel();
        this.updateProperties(propertiesModel);
        if (propertiesModel != null) {
            propertiesModel.addPropertiesListener(new PropertiesListener(){

                public void propertiesChanged(PropertiesEvent e) {
                    PrintTreeTableAction.this.updateProperties(propertiesModel);
                }
            });
        }
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(80, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.putValue("MnemonicKey", 80);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.treeTable != null) {
            try {
                PrinterJob job = PrinterJob.getPrinterJob();
                PageFormat defaultPf = job.defaultPage();
                defaultPf.setOrientation(0);
                PageFormat pf = job.pageDialog(defaultPf);
                if (!pf.equals(defaultPf)) {
                    job.setPrintable(this.getPrintable(), pf);
                } else {
                    job.setPrintable(this.getPrintable());
                }
                boolean printAccepted = job.printDialog();
                if (printAccepted) {
                    job.print();
                }
            }
            catch (PrinterException e1) {
                e1.printStackTrace();
            }
        }
    }

    public void setComponent(TreeTable treeTable) {
        this.treeTable = treeTable;
        this.setEnabled(treeTable != null);
    }

    private void updateProperties(PropertiesModel propertiesModel) {
        Object name = "Print...";
        if (propertiesModel != null && propertiesModel.isAvailable("action.print.label")) {
            name = String.valueOf(propertiesModel.getValue("action.print.label")) + "...";
        }
        this.putValue("Name", name);
    }

    public Printable getPrintable() {
        Printable printable = this.treeTable.getPrintable(JTable.PrintMode.FIT_WIDTH, null, new MessageFormat("Page - {0}"));
        return printable;
    }
}

