/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.configuration;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.macrofocus.combobox.MainJYComboBox;
import com.macrofocus.common.selection.SelectionEvent;
import com.macrofocus.common.selection.SelectionListener;
import com.macrofocus.crossplatform.swing.MJPanel;
import com.treemap.AlgorithmFactory;
import com.treemap.NoTreeMapField;
import com.treemap.TreeMapField;
import com.treemap.TreeMapModel;
import com.treemap.app.swing.configuration.GroupBySettingsPanel;
import com.treemap.app.swing.presentation.implementation.AttributeCellRenderer;
import de.javasoft.taskpane.JYTaskPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JButton;
import javax.swing.ListCellRenderer;
import org.apache.commons.lang3.text.StrMatcher;
import org.apache.commons.lang3.text.StrTokenizer;
import org.jdesktop.swingx.JXCollapsiblePane;

public class GroupByPanel<N, Row, Column>
extends MJPanel {
    private final AlgorithmFactory algorithmFactory;
    private TreeMapModel<N, Row, Column, Color, Font> tmm;
    private final List<MainJYComboBox> comboBoxes = new ArrayList<MainJYComboBox>();
    private final List<JButton> expandButtons = new ArrayList<JButton>();
    private final GroupByItemListener groupByItemListener = new GroupByItemListener();
    final SelectionListener<TreeMapField> selectionListener = new SelectionListener<TreeMapField>(){

        public void selectionChanged(SelectionEvent<TreeMapField> event) {
            GroupByPanel.this.createComboBoxes();
        }
    };

    public GroupByPanel(AlgorithmFactory algorithmFactory) {
        this.algorithmFactory = algorithmFactory;
    }

    public void setModel(TreeMapModel<N, Row, Column, Color, Font> tmm) {
        if (this.tmm != null) {
            tmm.getSettings().getGroupByVariablesSelection().removeSelectionListener(this.selectionListener);
        }
        this.tmm = tmm;
        tmm.getSettings().getGroupByVariablesSelection().addSelectionListener(this.selectionListener);
        this.createComboBoxes();
    }

    private void createComboBoxes() {
        for (MainJYComboBox comboBox : this.comboBoxes) {
            comboBox.removeItemListener((ItemListener)this.groupByItemListener);
        }
        this.removeAll();
        this.comboBoxes.clear();
        this.expandButtons.clear();
        TreeMapField[] groupByTreeMapFields = this.tmm.getSettings().getGroupByTreeMapFields();
        int count = groupByTreeMapFields != null ? groupByTreeMapFields.length : 0;
        this.setLayout((LayoutManager)new GridLayoutManager(count * 2 + 1, 2, new Insets(0, 0, 0, 0), -1, -1));
        if (groupByTreeMapFields != null) {
            for (int i = 0; i < count; ++i) {
                TreeMapField variable = groupByTreeMapFields[i];
                MainJYComboBox groupByComboBox = new MainJYComboBox();
                groupByComboBox.setStretchToFit(true);
                groupByComboBox.setEditable(false);
                groupByComboBox.setRenderer((ListCellRenderer)((Object)new AttributeCellRenderer()));
                this.fill(groupByComboBox, variable);
                JButton expandButton = this.createExpandButton();
                this.expandButtons.add(expandButton);
                this.add(expandButton, new GridConstraints(i * 2, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
                this.add((Component)groupByComboBox, new GridConstraints(i * 2, 1, 1, 1, 8, 1, 2, 0, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
                JXCollapsiblePane pane = new JXCollapsiblePane();
                pane.setLayout((LayoutManager)new BorderLayout());
                pane.add((Component)new GroupBySettingsPanel(this.tmm, variable, this.algorithmFactory).getMainPanel());
                this.configureExpandButton(expandButton, pane);
                this.add((Component)pane, new GridConstraints(i * 2 + 1, 0, 1, 2, 0, 3, 3, 3, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
                this.comboBoxes.add(groupByComboBox);
            }
        }
        MainJYComboBox groupByComboBox = new MainJYComboBox();
        groupByComboBox.setStretchToFit(true);
        groupByComboBox.setRenderer((ListCellRenderer)((Object)new AttributeCellRenderer()));
        groupByComboBox.setEditable(false);
        this.fill(groupByComboBox, null);
        this.add((Component)groupByComboBox, new GridConstraints(count * 2, 1, 1, 1, 8, 1, 2, 0, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        this.comboBoxes.add(groupByComboBox);
        for (MainJYComboBox comboBox : this.comboBoxes) {
            comboBox.addItemListener((ItemListener)this.groupByItemListener);
        }
        this.invalidate();
        if (this.getParent() != null) {
            if (this.getParent().getParent() != null) {
                if (this.getParent().getParent().getParent() != null) {
                    this.getParent().getParent().getParent().validate();
                }
            } else {
                this.validate();
            }
        } else {
            this.validate();
        }
    }

    void fill(MainJYComboBox choice, TreeMapField defaultVariable) {
        choice.addItem((Object)new NoTreeMapField());
        for (int i = 0; i < this.tmm.getDataFrame().getColumnCount(); ++i) {
            TreeMapField variable = this.tmm.getTreeMapField(i);
            if (variable.isEveryValueUnique() && !variable.getType().isArray()) continue;
            choice.addItem((Object)variable);
            if (!variable.equals((Object)defaultVariable)) continue;
            choice.setSelectedIndex(choice.getModel().getSize() - 1);
        }
    }

    void setGroupBy(String groupBy) {
        StrTokenizer st = new StrTokenizer(groupBy, StrMatcher.commaMatcher(), StrMatcher.quoteMatcher());
        Object[] indices = new TreeMapField[st.size()];
        for (int j = 0; j < indices.length; ++j) {
            String item = st.nextToken();
            for (int i = 0; i < this.tmm.getDataFrame().getColumnCount(); ++i) {
                if (!item.equals(this.tmm.getDataFrame().getColumnName(this.tmm.getDataFrame().getColumnKey(i)))) continue;
                indices[j] = this.tmm.getTreeMapField(i);
            }
        }
        this.tmm.getSettings().getGroupByVariablesSelection().setSelectedElements(indices);
    }

    private JButton createExpandButton() {
        JYTaskPane taskPane = new JYTaskPane();
        taskPane.setCollapsed(true);
        Container child = (Container)taskPane.getComponent(0);
        JButton button = (JButton)child.getComponent(2);
        return button;
    }

    private void configureExpandButton(JButton button, JXCollapsiblePane pane) {
        button.setAction(pane.getActionMap().get("toggle"));
        button.setText(null);
        pane.setCollapsed(true);
    }

    public void expand() {
        for (JButton expandButton : this.expandButtons) {
            expandButton.getAction().actionPerformed(new ActionEvent((Object)this, 0, null));
        }
    }

    private class GroupByItemListener
    implements ItemListener {
        private GroupByItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            MainJYComboBox comboBox;
            TreeMapField item;
            Object groupBy = "";
            HashSet<String> selected = new HashSet<String>();
            for (int i = 0; i < GroupByPanel.this.comboBoxes.size() && (item = (TreeMapField)(comboBox = GroupByPanel.this.comboBoxes.get(i)).getSelectedItem()).isValid() && !selected.contains(item.getName()); ++i) {
                selected.add(item.getName());
                groupBy = (String)groupBy + "\"" + item.getName() + "\"";
                if (e.getSource() == comboBox) break;
                if (i >= GroupByPanel.this.comboBoxes.size() - 1) continue;
                groupBy = (String)groupBy + ",";
            }
            GroupByPanel.this.setGroupBy((String)groupBy);
        }
    }
}

