/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.configuration;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jidesoft.converter.ObjectConverter;
import com.macrofocus.combobox.MJYComboBox;
import com.macrofocus.combobox.SmallColorJYComboBox;
import com.macrofocus.common.properties.PropertiesListener;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.crossplatform.swing.ColorComboBoxModel;
import com.macrofocus.crossplatform.swing.FontComboBoxModel;
import com.macrofocus.crossplatform.swing.MJPanel;
import com.macrofocus.crossplatform.swing.MJSpinner;
import com.macrofocus.crossplatform.swing.PropertySpinnerNumberModel;
import com.macrofocus.helper.WeakActionListeners;
import com.macrofocus.labeling.EnhancedLabel;
import com.macrofocus.selection.swing.SingleSelectionButtonModel;
import com.macrofocus.selection.swing.SingleSelectionComboBoxModel;
import com.treemap.TreeMapField;
import com.treemap.TreeMapFieldSettings;
import com.treemap.TreeMapModel;
import com.treemap.app.swing.configuration.ConverterListCellRenderer;
import com.treemap.app.swing.configuration.LayoutSettingsPanel;
import de.javasoft.combobox.JYComboBox;
import de.javasoft.combobox.controls.FontComboBoxEditor;
import de.javasoft.combobox.controls.FontComboBoxRenderer;
import de.javasoft.combobox.controls.FontPopupPanel;
import de.javasoft.switchbutton.JYSwitchButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LabelSettingsPanel {
    private JPanel mainPanel;
    private JCheckBox overrideCommonSettings;
    private MJYComboBox fontComboBox;
    private SmallColorJYComboBox effectComboBox;
    private SmallColorJYComboBox foregroundComboBox;
    private JSpinner minimumNumberOfCharactersSpinner;
    private MJYComboBox overflowComboBox;
    private MJYComboBox verticalAlgnmentComboBox;
    private MJYComboBox horizontalAlignmentComboBox;
    private JCheckBox expandTextToFitShapeCheckBox;
    private JCheckBox floatCheckBox;
    private MJYComboBox contrastEnhancementComboBox;
    private JButton resetButton;
    private JCheckBox shrinkTextToFitShapeCheckBox;
    final TreeMapModel treeMapModel;
    private TreeMapFieldSettings<Color, Font> settings;
    private PropertiesListener propertyChangeListener = new PropertiesListener<TreeMapFieldSettings.PropertyType>(){

        public void propertyChanged(TreeMapFieldSettings.PropertyType name, PropertyEvent event) {
            if (TreeMapFieldSettings.PropertyType.overrideDefaults == name) {
                LabelSettingsPanel.this.overrideCommonSettings.setSelected(LabelSettingsPanel.this.settings.isOverrideDefaults());
            }
        }
    };
    private ChangeListener changeListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            if (LabelSettingsPanel.this.settings != null) {
                try {
                    LabelSettingsPanel.this.settings.setOverrideDefaults(LabelSettingsPanel.this.overrideCommonSettings.isSelected());
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
            }
        }
    };
    private final WeakActionListeners actionListeners = new WeakActionListeners();

    public LabelSettingsPanel(TreeMapModel treeMapModel) {
        this.treeMapModel = treeMapModel;
        this.$$$setupUI$$$();
        this.overrideCommonSettings.addChangeListener(this.changeListener);
        this.fontComboBox.setRenderer((ListCellRenderer)new FontComboBoxRenderer(this.fontComboBox.getRenderer()));
        this.fontComboBox.setEditor((ComboBoxEditor)new FontComboBoxEditor(this.fontComboBox.getEditor(), null, false));
        this.fontComboBox.setPopupComponent((JComponent)new FontPopupPanel((JYComboBox)this.fontComboBox));
        this.effectComboBox.setAcceptNullValue(true);
        this.resetButton.putClientProperty("JButton.sizeVariant", "small");
        this.mainPanel.setBorder(new TitledBorder(""));
        this.verticalAlgnmentComboBox.setRenderer(new ConverterListCellRenderer(this.verticalAlgnmentComboBox.getRenderer(), (ObjectConverter)LayoutSettingsPanel.verticalAlignmentConverter));
        this.horizontalAlignmentComboBox.setRenderer(new ConverterListCellRenderer(this.horizontalAlignmentComboBox.getRenderer(), (ObjectConverter)LayoutSettingsPanel.horitzonalAlignmentConverter));
        this.setField(null);
        this.resetButton.addActionListener(this.actionListeners.create(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LabelSettingsPanel.this.settings.reset();
            }
        }, (Object)this.resetButton));
    }

    public void setField(TreeMapField field) {
        this.overrideCommonSettings.setVisible(field != null);
        this.resetButton.setVisible(field != null);
        if (field != null) {
            this.bindUI(this.treeMapModel.getSettings().getFieldSettings(field));
        } else {
            this.bindUI(this.treeMapModel.getSettings().getDefaultFieldSettings());
        }
    }

    private void bindUI(TreeMapFieldSettings settings) {
        if (this.settings != null) {
            this.settings.getProperties().removePropertiesListener(this.propertyChangeListener);
        }
        this.settings = settings;
        if (settings != null) {
            settings.getProperties().addPropertiesListener(this.propertyChangeListener);
            this.overrideCommonSettings.setSelected(settings.isOverrideDefaults());
        }
        this.overrideCommonSettings.setEnabled(settings != null);
        this.minimumNumberOfCharactersSpinner.setModel((SpinnerModel)new PropertySpinnerNumberModel(settings.getLabelingMinimumCharactersToDisplayProperty()));
        this.horizontalAlignmentComboBox.setModel((ComboBoxModel)new SingleSelectionComboBoxModel(settings.getLabelingHorizontalAlignmentProperty(), (Object[])new Integer[]{2, 0, 4}));
        this.overflowComboBox.setModel((ComboBoxModel)new SingleSelectionComboBoxModel(settings.getLabelingRenderingProperty(), (Object[])EnhancedLabel.Rendering.values()));
        this.verticalAlgnmentComboBox.setModel((ComboBoxModel)new SingleSelectionComboBoxModel(settings.getLabelingVerticalAlignmentProperty(), (Object[])new Integer[]{1, 0, 3}));
        this.effectComboBox.setModel(new ColorComboBoxModel(settings.getLabelingEffectColorProperty()));
        this.fontComboBox.setModel((ComboBoxModel)new FontComboBoxModel(settings.getLabelingFontProperty()));
        this.foregroundComboBox.setModel(new ColorComboBoxModel(settings.getLabelingForegroundProperty()));
        this.shrinkTextToFitShapeCheckBox.setModel((ButtonModel)new SingleSelectionButtonModel(settings.getLabelingShrinkTextToFitShapeProperty()));
        this.expandTextToFitShapeCheckBox.setModel((ButtonModel)new SingleSelectionButtonModel(settings.getLabelingResizeTextToFitShapeProperty()));
        this.floatCheckBox.setModel((ButtonModel)new SingleSelectionButtonModel(settings.getLabelingFloatProperty()));
        this.contrastEnhancementComboBox.setModel((ComboBoxModel)new SingleSelectionComboBoxModel(settings.getLabelingContrastEnhancementProperty(), (Object[])EnhancedLabel.ContrastEnhancement.values()));
    }

    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    private void createUIComponents() {
        this.mainPanel = new MJPanel();
        this.overrideCommonSettings = new JYSwitchButton();
        this.fontComboBox = new MJYComboBox();
        this.effectComboBox = new SmallColorJYComboBox();
        this.foregroundComboBox = new SmallColorJYComboBox();
        this.minimumNumberOfCharactersSpinner = new MJSpinner();
        this.overflowComboBox = new MJYComboBox();
        this.verticalAlgnmentComboBox = new MJYComboBox();
        this.horizontalAlignmentComboBox = new MJYComboBox();
        this.expandTextToFitShapeCheckBox = new JYSwitchButton();
        this.contrastEnhancementComboBox = new MJYComboBox();
        this.shrinkTextToFitShapeCheckBox = new JYSwitchButton();
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.mainPanel.setLayout((LayoutManager)new GridLayoutManager(9, 2, new Insets(0, 0, 0, 0), -1, 2));
        Spacer spacer1 = new Spacer();
        this.mainPanel.add((Component)spacer1, new GridConstraints(8, 0, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
        JLabel label1 = new JLabel();
        label1.setText("Alignment:");
        this.mainPanel.add((Component)label1, new GridConstraints(3, 0, 1, 1, 8, 0, 1, 0, null, null, null, 0, false));
        JLabel label2 = new JLabel();
        label2.setText("Overflow:");
        this.mainPanel.add((Component)label2, new GridConstraints(4, 0, 1, 1, 8, 0, 1, 0, null, null, null, 0, false));
        JLabel label3 = new JLabel();
        label3.setText("Expand text to fit shape:");
        this.mainPanel.add((Component)label3, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, new Dimension(0, -1), null, null, 0, false));
        this.expandTextToFitShapeCheckBox.setText("");
        this.mainPanel.add((Component)this.expandTextToFitShapeCheckBox, new GridConstraints(6, 1, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        JLabel label4 = new JLabel();
        label4.setText("Float:");
        label4.setVisible(false);
        this.mainPanel.add((Component)label4, new GridConstraints(7, 0, 1, 1, 8, 0, 0, 0, new Dimension(0, -1), null, null, 0, false));
        this.floatCheckBox = new JCheckBox();
        this.floatCheckBox.setText("");
        this.floatCheckBox.setVisible(false);
        this.mainPanel.add((Component)this.floatCheckBox, new GridConstraints(7, 1, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        JLabel label5 = new JLabel();
        label5.setText("Contrast Enhancement:");
        this.mainPanel.add((Component)label5, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.mainPanel.add((Component)this.contrastEnhancementComboBox, new GridConstraints(2, 1, 1, 1, 8, 1, 5, 0, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1));
        this.mainPanel.add((Component)panel1, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, false));
        JLabel label6 = new JLabel();
        label6.setIcon(new ImageIcon(this.getClass().getResource("/com/treemap/app/swing/configuration/font24.png")));
        label6.setText("");
        label6.setToolTipText("Font");
        panel1.add((Component)label6, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1, false));
        panel1.add((Component)this.fontComboBox, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        panel1.add((Component)this.foregroundComboBox, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 3, null, new Dimension(20, -1), null, 0, false));
        panel1.add((Component)this.effectComboBox, new GridConstraints(0, 3, 1, 1, 0, 1, 0, 3, null, new Dimension(20, -1), null, 0, false));
        JPanel panel2 = new JPanel();
        panel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.mainPanel.add((Component)panel2, new GridConstraints(3, 1, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        panel2.add((Component)this.horizontalAlignmentComboBox, new GridConstraints(0, 0, 1, 1, 8, 1, 5, 0, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        panel2.add((Component)this.verticalAlgnmentComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 5, 0, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        JPanel panel3 = new JPanel();
        panel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.mainPanel.add((Component)panel3, new GridConstraints(4, 1, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        panel3.add((Component)this.overflowComboBox, new GridConstraints(0, 0, 1, 1, 8, 1, 5, 0, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        this.minimumNumberOfCharactersSpinner.setToolTipText("Min number of characters to display");
        panel3.add((Component)this.minimumNumberOfCharactersSpinner, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        JPanel panel4 = new JPanel();
        panel4.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.mainPanel.add((Component)panel4, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, false));
        this.overrideCommonSettings.setText("Override Defaults");
        panel4.add((Component)this.overrideCommonSettings, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        Spacer spacer2 = new Spacer();
        panel4.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        this.resetButton = new JButton();
        this.resetButton.setEnabled(true);
        this.resetButton.setText("Reset");
        panel4.add((Component)this.resetButton, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        JLabel label7 = new JLabel();
        label7.setText("Shrink text to fit shape: ");
        this.mainPanel.add((Component)label7, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.shrinkTextToFitShapeCheckBox.setText("");
        this.mainPanel.add((Component)this.shrinkTextToFitShapeCheckBox, new GridConstraints(5, 1, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
    }

    public JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }
}

