/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.configuration;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.macrofocus.common.properties.PropertiesListener;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.crossplatform.swing.MJPanel;
import com.macrofocus.helper.WeakActionListeners;
import com.macrofocus.selection.swing.SingleSelectionComboBoxModel;
import com.treemap.ScaleFactory;
import com.treemap.TreeMapField;
import com.treemap.TreeMapFieldSettings;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapSettings;
import com.treemap.app.swing.v4.settings.aggregation.MAggregationFactory;
import de.javasoft.switchbutton.JYSwitchButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SizeSettingsPanel {
    private JComboBox aggregationComboBox;
    private JComboBox scaleComboBox;
    private JPanel mainPanel;
    private JCheckBox overrideCommonSettings;
    private JLabel aggregationLabel;
    private JButton resetButton;
    private TreeMapFieldSettings<Color, Font> settings;
    private PropertiesListener propertyChangeListener = new PropertiesListener(){

        public void propertyChanged(Object name, PropertyEvent event) {
            if (TreeMapFieldSettings.PropertyType.overrideDefaults == name) {
                SizeSettingsPanel.this.overrideCommonSettings.setSelected(!SizeSettingsPanel.this.settings.isDefaults() && SizeSettingsPanel.this.settings.isOverrideDefaults());
            }
        }
    };
    private ChangeListener changeListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            if (SizeSettingsPanel.this.settings != null) {
                SizeSettingsPanel.this.settings.setOverrideDefaults(SizeSettingsPanel.this.overrideCommonSettings.isSelected());
            }
        }
    };
    private final WeakActionListeners actionListeners = new WeakActionListeners();

    public SizeSettingsPanel(final TreeMapModel treeMapModel) {
        this.$$$setupUI$$$();
        this.overrideCommonSettings.addChangeListener(this.changeListener);
        treeMapModel.getSettings().getProperties().addPropertiesListener(new PropertiesListener(){

            public void propertyChanged(Object name, PropertyEvent event) {
                if ("sizeField".equals(name)) {
                    SizeSettingsPanel.this.updateField(treeMapModel);
                }
            }
        });
        this.updateField(treeMapModel);
        this.mainPanel.setBorder(new TitledBorder(""));
        treeMapModel.getSettings().getProperties().addPropertiesListener(new PropertiesListener(){

            public void propertyChanged(Object name, PropertyEvent event) {
                if ("groupByField".equals(name)) {
                    SizeSettingsPanel.this.updateAggregation(treeMapModel.getSettings());
                }
            }
        });
        this.updateAggregation(treeMapModel.getSettings());
        this.resetButton.addActionListener(this.actionListeners.create(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SizeSettingsPanel.this.settings.reset();
            }
        }, (Object)this.resetButton));
    }

    private void updateField(TreeMapModel treeMapModel) {
        TreeMapField field = treeMapModel.getSettings().getSizeTreeMapField();
        TreeMapFieldSettings settings = treeMapModel.getSettings().getFieldSettings(field);
        this.bindUI(settings);
    }

    private void bindUI(TreeMapFieldSettings settings) {
        if (this.settings != null) {
            this.settings.getProperties().removePropertiesListener(this.propertyChangeListener);
        }
        this.settings = settings;
        if (settings != null) {
            settings.getProperties().addPropertiesListener(this.propertyChangeListener);
            this.overrideCommonSettings.setVisible(!settings.isDefaults());
            this.resetButton.setVisible(!settings.isDefaults());
            this.overrideCommonSettings.setSelected(!settings.isDefaults() && settings.isOverrideDefaults());
        }
        this.aggregationComboBox.setModel(new SingleSelectionComboBoxModel(settings.getAggregationProperty(), (Iterable)MAggregationFactory.getInstance().getAggregations()));
        this.scaleComboBox.setModel(new SingleSelectionComboBoxModel(settings.getScaleProperty(), (Iterable)ScaleFactory.getInstance().getScales()));
    }

    private void updateAggregation(TreeMapSettings settings) {
        TreeMapField[] groupByTreeMapFields = settings.getGroupByTreeMapFields();
        boolean enabled = groupByTreeMapFields != null && groupByTreeMapFields.length > 0 && groupByTreeMapFields[0].isValid();
        this.aggregationLabel.setEnabled(enabled);
        this.aggregationComboBox.setEnabled(enabled);
    }

    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    private void createUIComponents() {
        this.mainPanel = new MJPanel();
        this.overrideCommonSettings = new JYSwitchButton();
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.mainPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, 2));
        this.aggregationLabel = new JLabel();
        this.aggregationLabel.setText("Aggregation:");
        this.mainPanel.add((Component)this.aggregationLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        this.mainPanel.add((Component)spacer1, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
        this.aggregationComboBox = new JComboBox();
        this.mainPanel.add((Component)this.aggregationComboBox, new GridConstraints(1, 1, 1, 1, 8, 1, 5, 0, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        JLabel label1 = new JLabel();
        label1.setText("Scale:");
        this.mainPanel.add((Component)label1, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.scaleComboBox = new JComboBox();
        this.mainPanel.add((Component)this.scaleComboBox, new GridConstraints(2, 1, 1, 1, 8, 1, 5, 0, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.mainPanel.add((Component)panel1, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, false));
        this.overrideCommonSettings.setSelected(false);
        this.overrideCommonSettings.setText("Override Defaults");
        panel1.add((Component)this.overrideCommonSettings, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null, 1, false));
        Spacer spacer2 = new Spacer();
        panel1.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        this.resetButton = new JButton();
        this.resetButton.setEnabled(true);
        this.resetButton.setText("Reset");
        panel1.add((Component)this.resetButton, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null, 1, false));
    }

    public JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }
}

