/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.configuration;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ObjectConverter;
import com.macrofocus.combobox.MJYComboBox;
import com.macrofocus.combobox.SmallColorJYComboBox;
import com.macrofocus.common.properties.PropertiesListener;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.crossplatform.swing.ColorComboBoxModel;
import com.macrofocus.crossplatform.swing.FontComboBoxModel;
import com.macrofocus.crossplatform.swing.MJPanel;
import com.macrofocus.format.CPFormat;
import com.macrofocus.format.swing.SwingFormatFactory;
import com.macrofocus.helper.WeakActionListeners;
import com.macrofocus.labeling.EnhancedLabel;
import com.macrofocus.selection.swing.SingleSelectionButtonModel;
import com.macrofocus.selection.swing.SingleSelectionComboBoxModel;
import com.macrofocus.utils.TypeUtils;
import com.treemap.TreeMapField;
import com.treemap.TreeMapFieldSettings;
import com.treemap.TreeMapModel;
import com.treemap.app.swing.configuration.ConverterComboBoxEditor;
import com.treemap.app.swing.configuration.ConverterListCellRenderer;
import com.treemap.app.swing.v4.settings.aggregation.MAggregationFactory;
import de.javasoft.combobox.JYComboBox;
import de.javasoft.combobox.controls.FontComboBoxEditor;
import de.javasoft.combobox.controls.FontComboBoxRenderer;
import de.javasoft.combobox.controls.FontPopupPanel;
import de.javasoft.switchbutton.JYSwitchButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ToolTipSettingsPanel {
    public static final CPFormat[] dateFormats = new CPFormat[]{SwingFormatFactory.getInstance().createDateFormat("yyyy.MM.dd G 'at' HH:mm:ss z"), SwingFormatFactory.getInstance().createDateFormat("EEE, MMM d, ''yy"), SwingFormatFactory.getInstance().createDateFormat("h:mm a"), SwingFormatFactory.getInstance().createDateFormat("hh 'o''clock' a, zzzz"), SwingFormatFactory.getInstance().createDateFormat("K:mm a, z"), SwingFormatFactory.getInstance().createDateFormat("yyyyy.MMMMM.dd GGG hh:mm aaa"), SwingFormatFactory.getInstance().createDateFormat("EEE, d MMM yyyy HH:mm:ss Z"), SwingFormatFactory.getInstance().createDateFormat("yyMMddHHmmssZ"), SwingFormatFactory.getInstance().createDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ")};
    private final CPFormat[] decimalFormats = new CPFormat[]{SwingFormatFactory.getInstance().createNumberFormat("#"), SwingFormatFactory.getInstance().createNumberFormat("#.##########"), SwingFormatFactory.getInstance().createNumberFormat("###0.00"), SwingFormatFactory.getInstance().createNumberFormat("#%"), SwingFormatFactory.getInstance().createNumberFormat("$#.##")};
    private JPanel mainPanel;
    private JCheckBox overrideCommonSettings;
    private MJYComboBox fontComboBox;
    private SmallColorJYComboBox foregroundComboBox;
    private MJYComboBox overflowComboBox;
    private JComboBox formatComboBox;
    private JCheckBox labelCheckBox;
    private MJYComboBox aggregationComboBox;
    private JButton resetButton;
    final TreeMapModel treeMapModel;
    private TreeMapFieldSettings<Color, Font> settings;
    ListCellRenderer formatRenderer;
    ComboBoxEditor formatEditor;
    private PropertiesListener<TreeMapFieldSettings.PropertyType> propertyChangeListener = new PropertiesListener<TreeMapFieldSettings.PropertyType>(){

        public void propertyChanged(TreeMapFieldSettings.PropertyType name, PropertyEvent event) {
            if (TreeMapFieldSettings.PropertyType.overrideDefaults == name) {
                ToolTipSettingsPanel.this.overrideCommonSettings.setSelected(ToolTipSettingsPanel.this.settings.isOverrideDefaults());
            }
        }
    };
    private ChangeListener changeListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            if (ToolTipSettingsPanel.this.settings != null) {
                try {
                    ToolTipSettingsPanel.this.settings.setOverrideDefaults(ToolTipSettingsPanel.this.overrideCommonSettings.isSelected());
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
            }
        }
    };
    private final WeakActionListeners actionListeners = new WeakActionListeners();

    public ToolTipSettingsPanel(TreeMapModel treeMapModel) {
        this.treeMapModel = treeMapModel;
        this.$$$setupUI$$$();
        this.overrideCommonSettings.addChangeListener(this.changeListener);
        this.formatComboBox.setEnabled(false);
        this.formatComboBox.setEditable(true);
        this.fontComboBox.setRenderer((ListCellRenderer)new FontComboBoxRenderer(this.fontComboBox.getRenderer()));
        this.fontComboBox.setEditor((ComboBoxEditor)new FontComboBoxEditor(this.fontComboBox.getEditor(), null, false));
        this.fontComboBox.setPopupComponent((JComponent)new FontPopupPanel((JYComboBox)this.fontComboBox));
        this.formatRenderer = this.formatComboBox.getRenderer();
        this.formatEditor = this.formatComboBox.getEditor();
        this.mainPanel.setBorder(new TitledBorder(""));
        this.setField(null);
        this.resetButton.addActionListener(this.actionListeners.create(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolTipSettingsPanel.this.settings.reset();
            }
        }, (Object)this.resetButton));
    }

    public void setField(TreeMapField field) {
        this.overrideCommonSettings.setVisible(field != null);
        this.resetButton.setVisible(field != null);
        if (field != null) {
            this.bindUI(field.getType(), this.treeMapModel.getSettings().getFieldSettings(field));
        } else {
            this.bindUI(String.class, this.treeMapModel.getSettings().getDefaultFieldSettings());
        }
    }

    private void bindUI(Class type, TreeMapFieldSettings settings) {
        if (this.settings != null) {
            this.settings.getProperties().removePropertiesListener(this.propertyChangeListener);
        }
        this.settings = settings;
        if (settings != null) {
            settings.getProperties().addPropertiesListener(this.propertyChangeListener);
            this.overrideCommonSettings.setSelected(settings.isOverrideDefaults());
        }
        this.overrideCommonSettings.setEnabled(settings != null);
        this.fontComboBox.setModel((ComboBoxModel)new FontComboBoxModel(settings.getTooltipFontProperty()));
        this.overflowComboBox.setModel((ComboBoxModel)new SingleSelectionComboBoxModel(settings.getTooltipRenderingProperty(), (Object[])EnhancedLabel.Rendering.values()));
        this.fontComboBox.setModel((ComboBoxModel)new FontComboBoxModel(settings.getTooltipFontProperty()));
        this.foregroundComboBox.setModel(new ColorComboBoxModel(settings.getTooltipForegroundProperty()));
        this.aggregationComboBox.setModel((ComboBoxModel)new SingleSelectionComboBoxModel(settings.getAggregationProperty(), (Iterable)MAggregationFactory.getInstance().getAggregations()));
        if (TypeUtils.isNumericType((Class)type)) {
            DecimalObjectConverter converter = new DecimalObjectConverter();
            this.formatComboBox.setRenderer(new ConverterListCellRenderer(this.formatRenderer, converter));
            this.formatComboBox.setEditor(new ConverterComboBoxEditor(this.formatEditor, converter));
            this.formatComboBox.setModel(new SingleSelectionComboBoxModel(settings.getFormatProperty(), (Object[])this.decimalFormats));
            this.formatComboBox.setEnabled(true);
        } else if (TypeUtils.isTemporalType((Class)type)) {
            this.formatComboBox.setEnabled(true);
            DateObjectConverter converter = new DateObjectConverter();
            this.formatComboBox.setRenderer(new ConverterListCellRenderer(this.formatRenderer, converter));
            this.formatComboBox.setEditor(new ConverterComboBoxEditor(this.formatEditor, converter));
            this.formatComboBox.setModel(new SingleSelectionComboBoxModel(settings.getFormatProperty(), (Object[])dateFormats));
            this.formatComboBox.setEnabled(true);
        } else {
            this.formatComboBox.setEnabled(false);
        }
        this.labelCheckBox.setModel((ButtonModel)new SingleSelectionButtonModel(settings.getProperties().getProperty((Object)TreeMapFieldSettings.PropertyType.showLabel)));
    }

    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    private void createUIComponents() {
        this.mainPanel = new MJPanel();
        this.overrideCommonSettings = new JYSwitchButton();
        this.labelCheckBox = new JYSwitchButton();
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.mainPanel.setLayout((LayoutManager)new GridLayoutManager(7, 2, new Insets(0, 0, 0, 0), -1, 2));
        Spacer spacer1 = new Spacer();
        this.mainPanel.add((Component)spacer1, new GridConstraints(6, 0, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
        JLabel label1 = new JLabel();
        label1.setText("Overflow:");
        this.mainPanel.add((Component)label1, new GridConstraints(2, 0, 1, 1, 8, 0, 1, 0, null, null, null, 0, false));
        this.overflowComboBox = new MJYComboBox();
        this.mainPanel.add((Component)this.overflowComboBox, new GridConstraints(2, 1, 1, 1, 8, 1, 5, 0, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        JLabel label2 = new JLabel();
        label2.setText("Format:");
        this.mainPanel.add((Component)label2, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.formatComboBox = new JComboBox();
        this.mainPanel.add((Component)this.formatComboBox, new GridConstraints(4, 1, 1, 1, 8, 1, 5, 0, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        JLabel label3 = new JLabel();
        label3.setText("Show variable name:");
        this.mainPanel.add((Component)label3, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.labelCheckBox.setText("");
        this.mainPanel.add((Component)this.labelCheckBox, new GridConstraints(5, 1, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        JLabel label4 = new JLabel();
        label4.setText("Aggregation:");
        this.mainPanel.add((Component)label4, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.aggregationComboBox = new MJYComboBox();
        this.mainPanel.add((Component)this.aggregationComboBox, new GridConstraints(3, 1, 1, 1, 8, 1, 5, 0, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.mainPanel.add((Component)panel1, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, false));
        this.fontComboBox = new MJYComboBox();
        panel1.add((Component)this.fontComboBox, new GridConstraints(0, 1, 1, 1, 0, 1, 5, 3, new Dimension(0, -1), null, null, 0, false));
        this.foregroundComboBox = new SmallColorJYComboBox();
        panel1.add((Component)this.foregroundComboBox, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 3, null, new Dimension(20, -1), null, 0, false));
        JLabel label5 = new JLabel();
        label5.setIcon(new ImageIcon(this.getClass().getResource("/com/treemap/app/swing/configuration/font24.png")));
        label5.setText("");
        label5.setToolTipText("Font");
        panel1.add((Component)label5, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 2, false));
        JPanel panel2 = new JPanel();
        panel2.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.mainPanel.add((Component)panel2, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, false));
        this.overrideCommonSettings.setText("Override Defaults");
        panel2.add((Component)this.overrideCommonSettings, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null, 1, false));
        Spacer spacer2 = new Spacer();
        panel2.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        this.resetButton = new JButton();
        this.resetButton.setEnabled(true);
        this.resetButton.setText("Reset");
        panel2.add((Component)this.resetButton, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null, 1, false));
    }

    public JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    private static class DecimalObjectConverter
    implements ObjectConverter {
        private DecimalObjectConverter() {
        }

        public String toString(Object format, ConverterContext context) {
            if (format != null) {
                if (format instanceof CPFormat) {
                    return ((CPFormat)format).getPattern();
                }
                return null;
            }
            return null;
        }

        public boolean supportToString(Object object, ConverterContext context) {
            return true;
        }

        public Object fromString(String pattern, ConverterContext context) {
            return pattern != null ? SwingFormatFactory.getInstance().createNumberFormat(pattern) : null;
        }

        public boolean supportFromString(String string, ConverterContext context) {
            return true;
        }
    }

    private static class DateObjectConverter
    implements ObjectConverter {
        private DateObjectConverter() {
        }

        public String toString(Object format, ConverterContext context) {
            if (format != null) {
                if (format instanceof CPFormat) {
                    return ((CPFormat)format).getPattern();
                }
                return null;
            }
            return null;
        }

        public boolean supportToString(Object object, ConverterContext context) {
            return true;
        }

        public Object fromString(String pattern, ConverterContext context) {
            return pattern != null ? SwingFormatFactory.getInstance().createDateFormat(pattern) : null;
        }

        public boolean supportFromString(String string, ConverterContext context) {
            return true;
        }
    }
}

