/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.configuration.action;

import com.macrofocus.molap.dataframe.WrappedDataFrame;
import com.macrofocus.molap.expression.ExpressionCalculatedColumn;
import com.macrofocus.resources.properties.PropertiesEvent;
import com.macrofocus.resources.properties.PropertiesListener;
import com.macrofocus.resources.properties.PropertiesModel;
import com.treemap.app.swing.configuration.action.AddVariableDialog;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class EditVariableAction
extends AbstractAction {
    private final WrappedDataFrame model;
    private final ListSelectionModel selectionModel;
    private final Component parentComponent;

    public EditVariableAction(WrappedDataFrame model, ListSelectionModel selectionModel, Component parentComponent, final PropertiesModel propertiesModel) {
        this.model = model;
        this.selectionModel = selectionModel;
        this.parentComponent = parentComponent;
        selectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                EditVariableAction.this.updateState();
            }
        });
        this.updateState();
        this.updateProperties(propertiesModel);
        if (propertiesModel != null) {
            propertiesModel.addPropertiesListener(new PropertiesListener(){

                public void propertiesChanged(PropertiesEvent e) {
                    EditVariableAction.this.updateProperties(propertiesModel);
                }
            });
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ArrayList<ExpressionCalculatedColumn> toEdit = new ArrayList<ExpressionCalculatedColumn>();
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            WrappedDataFrame.Column calculatedColumn;
            if (!this.selectionModel.isSelectedIndex(i) || !((calculatedColumn = this.model.getCalculatedColumnAt(i)) instanceof ExpressionCalculatedColumn)) continue;
            toEdit.add((ExpressionCalculatedColumn)calculatedColumn);
        }
        if (toEdit.size() == 1) {
            ExpressionCalculatedColumn variable = (ExpressionCalculatedColumn)toEdit.get(0);
            AddVariableDialog dialog = new AddVariableDialog(this.model, variable);
            dialog.setLocationRelativeTo(this.parentComponent);
            dialog.setModal(true);
            dialog.pack();
            dialog.setVisible(true);
        }
    }

    private void updateState() {
        if (!this.selectionModel.isSelectionEmpty()) {
            ArrayList<WrappedDataFrame.Column> toEdit = new ArrayList<WrappedDataFrame.Column>();
            for (int i = 0; i < this.model.getColumnCount(); ++i) {
                WrappedDataFrame.Column calculatedColumn;
                if (!this.selectionModel.isSelectedIndex(i) || !((calculatedColumn = this.model.getCalculatedColumnAt(i)) instanceof ExpressionCalculatedColumn)) continue;
                toEdit.add(calculatedColumn);
            }
            this.setEnabled(toEdit.size() == 1);
        } else {
            this.setEnabled(false);
        }
    }

    private void updateProperties(PropertiesModel propertiesModel) {
        Object name = "Edit";
        name = (String)name + "...";
        this.putValue("Name", name);
    }
}

