/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.document.export;

import com.macrofocus.resources.properties.PropertiesEvent;
import com.macrofocus.resources.properties.PropertiesListener;
import com.macrofocus.resources.properties.PropertiesModel;
import com.macrofocus.util.file.FileHelper;
import com.macrofocus.util.file.filter.AbstractFileFilter;
import com.macrofocus.util.logging.SwingLogging;
import com.macrofocus.util.swing.FileChooserFactory;
import com.macrofocus.util.swing.export.ExportDialog;
import com.macrofocus.util.swing.export.format.ContentProvider;
import com.macrofocus.util.swing.export.format.ExportFormat;
import com.macrofocus.util.swing.export.format.FileProvider;
import com.treemap.app.document.TreeMapDocument;
import com.treemap.app.swing.document.export.VRML97ExportFormat;
import com.treemap.app.swing.document.export.X3DExportFormat;
import com.treemap.app.swing.document.export.X3DOMExportFormat;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public class Export3DModelAction
extends AbstractAction {
    private Type type = Type.JFileChooserWithAccessory;
    private final JComponent rootPane;
    private ContentProvider<TreeMapDocument> contentProvider;
    private FileProvider<File> fileProvider;
    private ExportDialog exportDialog;
    private final ExportFormat<TreeMapDocument>[] exportFormats;
    private FileChooserFactory fileChooserFactory = new FileChooserFactory(){

        public JFileChooser getFileChooser() {
            JFileChooser fileChooser = super.getFileChooser();
            if (fileChooser.getSelectedFile() == null) {
                File file = (File)Export3DModelAction.this.fileProvider.getFile();
                FileFilter fileFilter = fileChooser.getFileFilter();
                if (fileFilter instanceof AbstractFileFilter) {
                    file = FileHelper.replaceSuffix((File)file, (String)((AbstractFileFilter)fileFilter).getDefaultExtension());
                }
                fileChooser.setSelectedFile(file);
            }
            return fileChooser;
        }

        protected JFileChooser createFileChooser() {
            final JFileChooser fileChooser = super.createFileChooser();
            fileChooser.setDialogTitle("Export 3D Model");
            fileChooser.setMultiSelectionEnabled(false);
            fileChooser.setFileSelectionMode(0);
            fileChooser.setAcceptAllFileFilterUsed(false);
            if (Export3DModelAction.this.type == Type.JFileChooserWithAccessory) {
                fileChooser.addPropertyChangeListener("fileFilterChanged", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        FileFilter fileFilter = fileChooser.getFileFilter();
                        JComponent settings = null;
                        for (ExportFormat<TreeMapDocument> exportFormat : Export3DModelAction.this.exportFormats) {
                            if (!exportFormat.isValid() || exportFormat.getFileFilter() != fileFilter) continue;
                            settings = (JComponent)exportFormat.getSettingsPanel();
                        }
                        fileChooser.setAccessory(settings);
                        fileChooser.validate();
                    }
                });
            }
            ExportFormat<TreeMapDocument> first = null;
            for (ExportFormat<TreeMapDocument> exportFormat : Export3DModelAction.this.exportFormats) {
                if (!exportFormat.isValid()) continue;
                if (first == null) {
                    first = exportFormat;
                }
                fileChooser.addChoosableFileFilter((FileFilter)exportFormat.getFileFilter());
            }
            if (first != null) {
                fileChooser.setFileFilter((FileFilter)first.getFileFilter());
            }
            return fileChooser;
        }
    };

    public Export3DModelAction(JComponent rootPane, final PropertiesModel propertiesModel, boolean expertMode) {
        this.rootPane = rootPane;
        this.exportFormats = Export3DModelAction.getExportFormats(expertMode);
        this.updateProperties(propertiesModel);
        if (propertiesModel != null) {
            propertiesModel.addPropertiesListener(new PropertiesListener(){

                public void propertiesChanged(PropertiesEvent e) {
                    Export3DModelAction.this.updateProperties(propertiesModel);
                }
            });
        }
    }

    public static ExportFormat<TreeMapDocument>[] getExportFormats(boolean expert) {
        ArrayList<X3DExportFormat> list = new ArrayList<X3DExportFormat>();
        try {
            list.add(new X3DExportFormat());
        }
        catch (NoClassDefFoundError e) {
            e.printStackTrace();
        }
        try {
            list.add(new VRML97ExportFormat());
        }
        catch (NoClassDefFoundError e) {
            e.printStackTrace();
        }
        try {
            list.add(new X3DOMExportFormat());
        }
        catch (NoClassDefFoundError e) {
            e.printStackTrace();
        }
        return list.toArray(new ExportFormat[list.size()]);
    }

    public void setContent(ContentProvider<TreeMapDocument> component, FileProvider<File> fileProvider) {
        this.contentProvider = component;
        this.fileProvider = fileProvider;
        this.setEnabled(this.contentProvider != null);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        try {
            if (this.exportDialog == null) {
                this.exportDialog = this.createExportDialog(this.rootPane);
            }
            if (this.type == Type.ExportDialog) {
                this.exportDialog.setContent(this.contentProvider);
                this.exportDialog.pack();
                this.exportDialog.setLocationRelativeTo((Component)this.rootPane);
                this.exportDialog.setVisible(true);
            } else {
                JFileChooser fileChooser = this.fileChooserFactory.getFileChooser();
                fileChooser.rescanCurrentDirectory();
                int returnVal = fileChooser.showSaveDialog(this.rootPane);
                File file = fileChooser.getSelectedFile();
                FileFilter fileFilter = fileChooser.getFileFilter();
                if (returnVal == 0) {
                    int input;
                    if (!fileFilter.accept(file) && fileFilter instanceof AbstractFileFilter) {
                        file = FileHelper.replaceSuffix((File)file, (String)((AbstractFileFilter)fileFilter).getDefaultExtension());
                    }
                    if (file.exists() && (input = JOptionPane.showConfirmDialog(this.rootPane, "File " + file.getName() + " already exist! Overwrite?", "File already exist", 0, 2)) == 1) {
                        return;
                    }
                    for (ExportFormat<TreeMapDocument> exportFormat : this.exportFormats) {
                        if (!exportFormat.isValid() || exportFormat.getFileFilter() == null || !exportFormat.getFileFilter().equals((Object)fileFilter)) continue;
                        try {
                            exportFormat.save(this.contentProvider, file);
                        }
                        catch (IOException e) {
                            SwingLogging.getInstance().process((Component)this.rootPane, (Throwable)e);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            SwingLogging.getInstance().process((Component)this.rootPane, (Throwable)e);
        }
    }

    protected ExportDialog createExportDialog(Component parent) throws HeadlessException {
        Window window = SwingUtilities.getWindowAncestor(parent);
        return new ExportDialog(window, this.exportFormats);
    }

    private void updateProperties(PropertiesModel propertiesModel) {
        Object name = "Export 3D Model";
        if (propertiesModel != null && propertiesModel.isAvailable("action.export3dmodel.label")) {
            name = (String)propertiesModel.getValue("action.export3dmodel.label");
        }
        name = (String)name + "...";
        this.putValue("Name", name);
    }

    public static enum Type {
        JFileChooser,
        JFileChooserWithAccessory,
        ExportDialog;

    }
}

