/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.importer;

import com.macrofocus.colormap.ColorMapFactory;
import com.macrofocus.colormap.swing.SwingColorMapFactory;
import com.macrofocus.common.file.FileType;
import com.macrofocus.common.file.TreeMapFileType;
import com.macrofocus.common.geom.Dimension;
import com.macrofocus.crossplatform.CPFactory;
import com.macrofocus.crossplatform.swing.SwingFactory;
import com.macrofocus.data.reader.CharMatcher;
import com.macrofocus.data.reader.DataReader;
import com.macrofocus.data.reader.PerfectDataReader;
import com.macrofocus.data.reader.TokenizerFactory;
import com.macrofocus.data.table.RowMajorTableModel;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.igraphics.CPFont;
import com.macrofocus.igraphics.CPImageFactory;
import com.macrofocus.igraphics.swing.SwingColor;
import com.macrofocus.igraphics.swing.SwingFont;
import com.macrofocus.igraphics.swing.SwingImageFactory;
import com.macrofocus.labeling.EnhancedLabel;
import com.macrofocus.molap.aggregates.AggregateDataFrame;
import com.macrofocus.molap.aggregates.aggregation.Aggregation;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.dataframe.MutableDataFrame;
import com.macrofocus.molap.dataframe.SingleSortKey;
import com.macrofocus.molap.dataframe.SortKey;
import com.macrofocus.molap.dataframe.SortOrder;
import com.macrofocus.molap.dataframe.swing.SwingDataFrameFactory;
import com.macrofocus.molap.exporter.java.SwingDataFrameExporter;
import com.macrofocus.util.file.CharsetToolkit;
import com.macrofocus.util.swing.export.format.ContentProvider;
import com.macrofocus.util.swing.export.format.DefaultContentProvider;
import com.macrofocus.util.swing.export.format.ExportFormat;
import com.macrofocus.util.swing.export.format.PNGExportFormat;
import com.macrofocus.util.swing.export.format.XMLGraphicsPDFExportFormat;
import com.treemap.Algorithm;
import com.treemap.AlgorithmFactory;
import com.treemap.BarAlgorithm;
import com.treemap.DefaultTreeMapModel;
import com.treemap.Labeling;
import com.treemap.LabelingFactory;
import com.treemap.OrderingFactory;
import com.treemap.TreeMapField;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapSettings;
import com.treemap.app.document.TreeMapDocument;
import com.treemap.app.swing.document.SwingTreeMapApplication;
import com.treemap.swing.SwingAlgorithmFactory;
import com.treemap.swing.SwingTreeMap;
import java.awt.Color;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JComponent;
import javax.swing.table.TableModel;

public class Refugees {
    Color background = Color.lightGray;
    final String localStore = "/Users/luc/macrofocus/dataset/treemap/Refugees";

    public Refugees() throws IOException {
        File dir = new File("/Users/luc/macrofocus/dataset/treemap/Refugees");
        if (!dir.exists()) {
            dir.mkdir();
        }
        this.download(dir);
        File target = new File(dir, "2013.json");
        if (!target.exists()) {
            URL url = new URL("http://data.unhcr.org/api/stats/time_series.json?year=2013&population_type_code=RF");
            Files.copy(url.openStream(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        MutableDataFrame dataFrame = SwingDataFrameFactory.getInstance().fromJSON(target.toURI().toURL());
        AggregateDataFrame aggregateDataFrame = dataFrame.aggregate(new Aggregation[]{dataFrame.getSum((Object)"value")}).drillDown(new Object[]{"country_of_origin"});
        SwingDataFrameExporter.exportCSV((DataFrame)aggregateDataFrame, (File)new File(dir, "2013byOrigin.csv"));
        aggregateDataFrame = dataFrame.aggregate(new Aggregation[]{dataFrame.getSum((Object)"value")}).drillDown(new Object[]{"country_of_residence"});
        SwingDataFrameExporter.exportCSV((DataFrame)aggregateDataFrame, (File)new File(dir, "2013byResidence.csv"));
        this.createInTreeMap(dir);
        this.createOutTreeMap(dir);
        this.createTemporalTreeMap(dir);
        this.createInVoronoiTreeMap(dir);
        System.exit(0);
    }

    private void createInVoronoiTreeMap(File dir) throws IOException {
        ExportFormat[] exportFormat;
        MutableDataFrame dataFrame = SwingDataFrameFactory.fromCSV((URL)new File(dir, "2013.csv").toURI().toURL());
        SwingTreeMap treeMap = new SwingTreeMap((TreeMapModel)new DefaultTreeMapModel((DataFrame)dataFrame, (CPFactory)SwingFactory.getInstance(), (ColorMapFactory)SwingColorMapFactory.getInstance(), (CPImageFactory)SwingImageFactory.getInstance()));
        ((JComponent)treeMap.getView().getNativeComponent()).setBackground(this.background);
        TreeMapSettings settings = treeMap.getModel().getSettings();
        settings.setGroupByByNames(new String[]{"Country or territory of origin"});
        settings.setSizeByName("Refugees<sup>*</sup>");
        settings.setColorByName("Country or territory of origin");
        settings.setLightSourceAmbient(0.75);
        settings = treeMap.getModel().getSettings().getDefaultFieldSettings();
        settings.setAlgorithm(SwingAlgorithmFactory.VORONOI);
        settings.setLabeling((Labeling)LabelingFactory.SURROUND);
        settings.setHeaderFont((CPFont)new SwingFont("Helvetica", 1, 92));
        settings.setHeaderBackground((CPColor)new SwingColor(this.background));
        settings.setNestingBackground((CPColor)new SwingColor(this.background));
        settings.setHeaderHorizontalAlignment(Integer.valueOf(0));
        settings.setHeaderVerticalAlignment(Integer.valueOf(0));
        settings.setLabelingFont((CPFont)new SwingFont("Palatino", 2, 16));
        settings.setLabelingResizeTextToFitShape(Boolean.valueOf(true));
        settings.setLabelingShrinkTextToFitShape(Boolean.valueOf(true));
        settings.setLabelingHorizontalAlignment(0);
        settings.setLabelingVerticalAlignment(0);
        settings.setLabelingMinimumCharactersToDisplay(0);
        treeMap.getModel().getSettings().setDimensionFixed(Boolean.valueOf(true));
        treeMap.getModel().getSettings().setDimension(new Dimension(1050, 1485));
        Dimension dimension = treeMap.getModel().getSettings().getDimension();
        ((JComponent)treeMap.getView().getNativeComponent()).setSize(dimension.width, dimension.height);
        ((JComponent)treeMap.getNativeComponent()).setVisible(true);
        treeMap.getView().waitUntilReady();
        String localStore = "/Users/luc/macrofocus/dataset/treemap/RefugeesInVoronoi";
        File file = new File(localStore + ".mtm");
        TreeMapDocument document = new TreeMapDocument("RefugeesInVoronoi", file.toURI().toURL().toExternalForm(), (DataFrame)dataFrame, null, (CPFactory)SwingFactory.getInstance(), (ColorMapFactory)SwingColorMapFactory.getInstance(), (CPImageFactory)SwingImageFactory.getInstance());
        SwingTreeMapApplication.saveDocument(document, file, (FileType)TreeMapFileType.getInstance());
        PNGExportFormat pngExportFormat = new PNGExportFormat();
        pngExportFormat.setOutputDPI(300.0f);
        for (ExportFormat format : exportFormat = new ExportFormat[]{pngExportFormat, new XMLGraphicsPDFExportFormat()}) {
            format.save((ContentProvider)new DefaultContentProvider((Object)((Component)treeMap.getView().getNativeComponent())), new File(dir, "RefugeesInVoronoi." + format.getFileFilter().getDefaultExtension()));
        }
    }

    private void createInTreeMap(File dir) throws IOException {
        ExportFormat[] exportFormat;
        MutableDataFrame dataFrame = SwingDataFrameFactory.fromCSV((URL)new File(dir, "2013.csv").toURI().toURL());
        SwingTreeMap treeMap = new SwingTreeMap((TreeMapModel)new DefaultTreeMapModel((DataFrame)dataFrame, (CPFactory)SwingFactory.getInstance(), (ColorMapFactory)SwingColorMapFactory.getInstance(), (CPImageFactory)SwingImageFactory.getInstance()));
        ((JComponent)treeMap.getView().getNativeComponent()).setBackground(this.background);
        TreeMapSettings settings = treeMap.getModel().getSettings();
        settings.setGroupByByNames(new String[]{"Country or territory of origin"});
        settings.setSizeByName("Refugees<sup>*</sup>");
        settings.setColorByName("Country or territory of origin");
        settings.setLightSourceAmbient(0.75);
        settings = treeMap.getModel().getSettings().getDefaultFieldSettings();
        settings.setOrderingHorizontalVanishingPoint(Integer.valueOf(0));
        settings.setOrderingVerticalVanishingPoint(Integer.valueOf(0));
        settings.setLabeling((Labeling)LabelingFactory.SURROUND);
        settings.setHeaderFont((CPFont)new SwingFont("Helvetica", 1, 92));
        settings.setHeaderBackground((CPColor)new SwingColor(this.background));
        settings.setNestingBackground((CPColor)new SwingColor(this.background));
        settings.setLabelingResizeTextToFitShape(Boolean.valueOf(true));
        settings.setLabelingShrinkTextToFitShape(Boolean.valueOf(true));
        settings.setLabelingVerticalAlignment(0);
        settings.setLabelingMinimumCharactersToDisplay(0);
        treeMap.getModel().getSettings().setDimensionFixed(Boolean.valueOf(true));
        treeMap.getModel().getSettings().setDimension(new Dimension(2101, 2971));
        Dimension dimension = treeMap.getModel().getSettings().getDimension();
        ((JComponent)treeMap.getView().getNativeComponent()).setSize(dimension.width, dimension.height);
        ((JComponent)treeMap.getNativeComponent()).setVisible(true);
        treeMap.getView().waitUntilReady();
        String localStore = "/Users/luc/macrofocus/dataset/treemap/RefugeesIn";
        File file = new File(localStore + ".mtm");
        TreeMapDocument document = new TreeMapDocument("RefugeesIn", file.toURI().toURL().toExternalForm(), (DataFrame)dataFrame, null, (CPFactory)SwingFactory.getInstance(), (ColorMapFactory)SwingColorMapFactory.getInstance(), (CPImageFactory)SwingImageFactory.getInstance());
        SwingTreeMapApplication.saveDocument(document, file, (FileType)TreeMapFileType.getInstance());
        PNGExportFormat pngExportFormat = new PNGExportFormat();
        pngExportFormat.setOutputDPI(300.0f);
        for (ExportFormat format : exportFormat = new ExportFormat[]{pngExportFormat, new XMLGraphicsPDFExportFormat()}) {
            format.save((ContentProvider)new DefaultContentProvider((Object)((Component)treeMap.getView().getNativeComponent())), new File(dir, "RefugeesIn." + format.getFileFilter().getDefaultExtension()));
        }
    }

    private void createOutTreeMap(File dir) throws IOException {
        ExportFormat[] exportFormat;
        MutableDataFrame dataFrame = SwingDataFrameFactory.fromCSV((URL)new File(dir, "2013.csv").toURI().toURL());
        SwingTreeMap treeMap = new SwingTreeMap((TreeMapModel)new DefaultTreeMapModel((DataFrame)dataFrame, (CPFactory)SwingFactory.getInstance(), (ColorMapFactory)SwingColorMapFactory.getInstance(), (CPImageFactory)SwingImageFactory.getInstance()));
        ((JComponent)treeMap.getView().getNativeComponent()).setBackground(this.background);
        TreeMapSettings settings = treeMap.getModel().getSettings();
        settings.setGroupByByNames(new String[]{"Country or territory of asylum or residence"});
        settings.setSizeByName("Refugees<sup>*</sup>");
        settings.setColorByName("Country or territory of asylum or residence");
        settings.setLabelsByNames(new String[]{"Country or territory of origin"});
        settings.setLightSourceAmbient(0.75);
        settings = treeMap.getModel().getSettings().getDefaultFieldSettings();
        settings.setOrderingHorizontalVanishingPoint(Integer.valueOf(0));
        settings.setOrderingVerticalVanishingPoint(Integer.valueOf(0));
        settings.setLabeling((Labeling)LabelingFactory.SURROUND);
        settings.setHeaderFont((CPFont)new SwingFont("Helvetica", 1, 92));
        settings.setHeaderBackground((CPColor)new SwingColor(this.background));
        settings.setNestingBackground((CPColor)new SwingColor(this.background));
        settings.setLabelingResizeTextToFitShape(Boolean.valueOf(true));
        settings.setLabelingShrinkTextToFitShape(Boolean.valueOf(true));
        settings.setLabelingVerticalAlignment(0);
        settings.setLabelingMinimumCharactersToDisplay(0);
        treeMap.getModel().getSettings().setDimensionFixed(Boolean.valueOf(true));
        treeMap.getModel().getSettings().setDimension(new Dimension(2101, 2971));
        Dimension dimension = treeMap.getModel().getSettings().getDimension();
        ((JComponent)treeMap.getView().getNativeComponent()).setSize(dimension.width, dimension.height);
        ((JComponent)treeMap.getNativeComponent()).setVisible(true);
        treeMap.getView().waitUntilReady();
        String localStore = "/Users/luc/macrofocus/dataset/treemap/RefugeesOut";
        File file = new File(localStore + ".mtm");
        TreeMapDocument document = new TreeMapDocument("RefugeesOut", file.toURI().toURL().toExternalForm(), (DataFrame)dataFrame, null, (CPFactory)SwingFactory.getInstance(), (ColorMapFactory)SwingColorMapFactory.getInstance(), (CPImageFactory)SwingImageFactory.getInstance());
        SwingTreeMapApplication.saveDocument(document, file, (FileType)TreeMapFileType.getInstance());
        PNGExportFormat pngExportFormat = new PNGExportFormat();
        pngExportFormat.setOutputDPI(300.0f);
        for (ExportFormat format : exportFormat = new ExportFormat[]{pngExportFormat, new XMLGraphicsPDFExportFormat()}) {
            format.save((ContentProvider)new DefaultContentProvider((Object)((Component)treeMap.getView().getNativeComponent())), new File(dir, "RefugeesOut." + format.getFileFilter().getDefaultExtension()));
        }
    }

    private void createTemporalTreeMap(File dir) throws IOException {
        ExportFormat[] exportFormat;
        MutableDataFrame dataFrame = SwingDataFrameFactory.fromCSV((URL)new File(dir, "Refugees.csv").toURI().toURL());
        AggregateDataFrame aggregateDataFrame = dataFrame.aggregate(new Aggregation[]{dataFrame.getSum((Object)"Refugees<sup>*</sup>").as("Refugees<sup>*</sup>")}).drillDown(new Object[]{"Year", "Country or territory of origin"});
        SwingTreeMap treeMap = new SwingTreeMap((TreeMapModel)new DefaultTreeMapModel((DataFrame)aggregateDataFrame, (CPFactory)SwingFactory.getInstance(), (ColorMapFactory)SwingColorMapFactory.getInstance(), (CPImageFactory)SwingImageFactory.getInstance()));
        ((JComponent)treeMap.getView().getNativeComponent()).setBackground(Color.black);
        TreeMapSettings settings = treeMap.getModel().getSettings();
        settings.setGroupByByNames(new String[]{"Year"});
        settings.setSizeByName("Refugees<sup>*</sup>");
        settings.setColorByName("Country or territory of origin");
        settings.setLightSourceAmbient(0.75);
        settings = treeMap.getModel().getSettings().getDefaultFieldSettings();
        BarAlgorithm barAlgorithm = new BarAlgorithm(0.05, BarAlgorithm.Orientation.Vertical);
        settings.setAlgorithm((Algorithm)barAlgorithm);
        settings.setOrdering(OrderingFactory.ORIGINAL);
        settings.setLabeling(LabelingFactory.EXPAND);
        settings.setHeaderHorizontalAlignment(Integer.valueOf(4));
        settings.setLabelingResizeTextToFitShape(Boolean.valueOf(true));
        settings.setLabelingShrinkTextToFitShape(Boolean.valueOf(true));
        settings.setLabelingVerticalAlignment(0);
        settings.setLabelingHorizontalAlignment(0);
        settings.setLabelingMinimumCharactersToDisplay(0);
        settings.setLabelingRendering(EnhancedLabel.Rendering.WordWrap);
        settings = treeMap.getModel().getSettings().getFieldSettings(treeMap.getModel().getTreeMapField((Object)"Year"));
        settings.setAlgorithm(AlgorithmFactory.SQUARIFIED);
        settings.setOrdering(OrderingFactory.SIZE);
        TreeMapField colorTreeMapField = treeMap.getModel().getSettings().getColorTreeMapField();
        treeMap.getModel().getColorMap(colorTreeMapField).setColor((Object)"Various", (CPColor)new SwingColor(Color.gray));
        treeMap.getModel().getColorMap(colorTreeMapField).setColor((Object)"Burundi", (CPColor)new SwingColor(Color.green));
        treeMap.getModel().getSettings().setDimensionFixed(Boolean.valueOf(true));
        treeMap.getModel().getSettings().setDimension(new Dimension(2101, 2971));
        Dimension dimension = treeMap.getModel().getSettings().getDimension();
        ((JComponent)treeMap.getView().getNativeComponent()).setSize(dimension.width, dimension.height);
        ((JComponent)treeMap.getNativeComponent()).setVisible(true);
        treeMap.getView().waitUntilReady();
        String localStore = "/Users/luc/macrofocus/dataset/treemap/Refugees";
        File file = new File(localStore + ".mtm");
        TreeMapDocument document = new TreeMapDocument("Refugees", file.toURI().toURL().toExternalForm(), (DataFrame)dataFrame, null, (CPFactory)SwingFactory.getInstance(), (ColorMapFactory)SwingColorMapFactory.getInstance(), (CPImageFactory)SwingImageFactory.getInstance());
        SwingTreeMapApplication.saveDocument(document, file, (FileType)TreeMapFileType.getInstance());
        PNGExportFormat pngExportFormat = new PNGExportFormat();
        pngExportFormat.setOutputDPI(300.0f);
        for (ExportFormat format : exportFormat = new ExportFormat[]{pngExportFormat, new XMLGraphicsPDFExportFormat()}) {
            format.save((ContentProvider)new DefaultContentProvider((Object)((Component)treeMap.getView().getNativeComponent())), new File(dir, "Refugees." + format.getFileFilter().getDefaultExtension()));
        }
    }

    private void download(File dir) throws IOException {
        if (!new File(dir, "Refugees.csv").exists()) {
            DataFrame refugees = null;
            for (int year = 1975; year <= 2013; ++year) {
                File dest = new File(dir, year + ".csv");
                if (!dest.exists()) {
                    File target = new File(dir, year + ".zip");
                    if (!target.exists()) {
                        URL url = new URL("http://data.un.org/Handlers/DownloadHandler.ashx?DataFilter=indID:Type-Ref;yr:" + year + "&DataMartId=UNHCR&Format=csv&c=0,1,2,3,4,5,6&s=yr:desc,asyEngName:asc,oriEngName:asc");
                        Files.copy(url.openStream(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    }
                    ZipInputStream zip = new ZipInputStream(new FileInputStream(target));
                    ZipEntry entry = zip.getNextEntry();
                    BufferedInputStream bis = new BufferedInputStream(zip);
                    PerfectDataReader dataReader = new PerfectDataReader((Reader)new CharsetToolkit(bis, Charset.forName("UTF-8")).getReader(), new TokenizerFactory(CharMatcher.getDoubleQuoteMatcher(), "", TokenizerFactory.commaMatchers), true, false, "String", 0, Integer.MAX_VALUE);
                    RowMajorTableModel tableModel = new RowMajorTableModel((DataReader)dataReader, true);
                    bis.close();
                    MutableDataFrame dataFrame = SwingDataFrameFactory.fromTableModel((TableModel)tableModel);
                    for (Object c : dataFrame.columns()) {
                        for (Object r : dataFrame.rows()) {
                            if (!"*".equals(dataFrame.getValueAt(r, c))) continue;
                            dataFrame.setValueAt(r, c, null);
                        }
                    }
                    SwingDataFrameExporter.exportCSV((DataFrame)dataFrame, (File)dest);
                }
                MutableDataFrame dataFrame = SwingDataFrameFactory.fromCSV((URL)dest.toURI().toURL());
                DataFrame indexed = dataFrame.reindexRowsUsingColumns((Object[])new String[]{"Country or territory of asylum or residence", "Country or territory of origin", "Year"});
                refugees = refugees == null ? indexed : refugees.append(indexed);
            }
            SwingDataFrameExporter.exportCSV((DataFrame)refugees.orderRows(new SortKey[]{new SingleSortKey((Object)"Year", SortOrder.ASCENDING), new SingleSortKey((Object)"Country or territory of asylum or residence", SortOrder.ASCENDING), new SingleSortKey((Object)"Country or territory of origin", SortOrder.ASCENDING)}), (File)new File(dir, "Refugees.csv"));
        }
    }

    public static void main(String[] args) {
        try {
            new Refugees();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        System.setProperty("java.awt.headless", "true");
    }
}

