/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.presentation.implementation;

import com.jidesoft.utils.TypeUtils;
import com.macrofocus.crossplatform.swing.MDefaultListCellRenderer;
import com.macrofocus.data.type.HierarchyElement;
import com.macrofocus.data.type.series.Series;
import com.treemap.NoTreeMapField;
import com.treemap.TreeMapField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.util.Date;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;

public class AttributeCellRenderer
extends MDefaultListCellRenderer {
    private static final Icon auto = new ImageIcon(AttributeCellRenderer.class.getResource("auto.png"));
    private static final Icon textIcon = new ImageIcon(AttributeCellRenderer.class.getResource("stock_form-text-box-16.png"));
    private static final Icon num = new ImageIcon(AttributeCellRenderer.class.getResource("stock_form-numerical-field-16.png"));
    private static final Icon time = new ImageIcon(AttributeCellRenderer.class.getResource("stock_form-date-field-16.png"));
    private static final Icon color = new ImageIcon(AttributeCellRenderer.class.getResource("stock_filters-pop-art-16.png"));
    private static final Icon chart = new ImageIcon(AttributeCellRenderer.class.getResource("stock_chart-toggle-title-16.png"));
    private static final Icon icon = new ImageIcon(AttributeCellRenderer.class.getResource("stock_help-chat.png"));
    private static final Icon hierarchy = new ImageIcon(AttributeCellRenderer.class.getResource("sc_dbreportopen.png"));

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        boolean multipleValuesSelected = false;
        if (value instanceof Object[]) {
            Object[] values = (Object[])value;
            if (values.length > 0) {
                multipleValuesSelected = values.length > 1;
                value = values[0];
            } else {
                value = new NoTreeMapField();
            }
        }
        if (value instanceof TreeMapField) {
            TreeMapField variable = (TreeMapField)value;
            Component comp = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            JLabel label = (JLabel)comp;
            Object text = "";
            if (variable instanceof NoTreeMapField) {
                text = " ";
                label.setIcon(auto);
            } else if (TypeUtils.isNumericType((Class)variable.getType())) {
                label.setIcon(num);
                text = variable.getName();
            } else if (Color.class.isAssignableFrom(variable.getType())) {
                label.setIcon(color);
                text = variable.getName();
            } else if (Date.class.isAssignableFrom(variable.getType())) {
                label.setIcon(time);
                text = variable.getName();
            } else if (Series.class.isAssignableFrom(variable.getType())) {
                label.setIcon(chart);
                text = variable.getName();
            } else if (Icon.class.isAssignableFrom(variable.getType()) || Image.class.isAssignableFrom(variable.getType())) {
                label.setIcon(icon);
                text = variable.getName();
            } else if (HierarchyElement.class.isAssignableFrom(variable.getType())) {
                label.setIcon(hierarchy);
                label.setText(variable.getName());
            } else {
                label.setIcon(textIcon);
                text = variable.getName();
            }
            if (multipleValuesSelected) {
                text = (String)text + ", ...";
            }
            label.setText((String)text);
            return comp;
        }
        return new JLabel();
    }
}

