/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.v4.settings.algorithm.tagcloud;

import com.treemap.app.swing.v4.settings.algorithm.tagcloud.MarchingCubesStrategy;
import com.treemap.swing.voronoi.Path;
import com.treemap.swing.voronoi.smoothing.Direction;
import java.awt.Polygon;
import java.util.ArrayList;

public class MarchingSquares {
    private final int width;
    private final int height;
    private final MarchingCubesStrategy strategy;

    public MarchingSquares(MarchingCubesStrategy strategy) {
        this.strategy = strategy;
        this.width = strategy.getWidth();
        this.height = strategy.getHeight();
    }

    public Polygon run() {
        Path path = this.identifyPerimeter();
        if (path != null) {
            Polygon polygon = new Polygon();
            int x = path.getOriginX();
            int y = path.getOriginY();
            polygon.addPoint(x, y);
            for (Direction direction : path.getDirections()) {
                polygon.addPoint(x += direction.screenX, y += direction.screenY);
            }
            return polygon;
        }
        return null;
    }

    public Path identifyPerimeter(int initialX, int initialY) {
        Direction direction;
        int initialValue;
        if (initialX < 0) {
            initialX = 0;
        }
        if (initialX > this.width) {
            initialX = this.width;
        }
        if (initialY < 0) {
            initialY = 0;
        }
        if (initialY > this.height) {
            initialY = this.height;
        }
        if ((initialValue = this.value(initialX, initialY)) == 0 || initialValue == 15) {
            throw new IllegalArgumentException(String.format("Supplied initial coordinates (%d, %d) do not lie on a perimeter.", initialX, initialY));
        }
        ArrayList<Direction> directions = new ArrayList<Direction>();
        int x = initialX;
        int y = initialY;
        Direction previous = null;
        do {
            switch (this.value(x, y)) {
                case 1: {
                    direction = Direction.N;
                    break;
                }
                case 2: {
                    direction = Direction.E;
                    break;
                }
                case 3: {
                    direction = Direction.E;
                    break;
                }
                case 4: {
                    direction = Direction.W;
                    break;
                }
                case 5: {
                    direction = Direction.N;
                    break;
                }
                case 6: {
                    direction = previous == Direction.N ? Direction.W : Direction.E;
                    break;
                }
                case 7: {
                    direction = Direction.E;
                    break;
                }
                case 8: {
                    direction = Direction.S;
                    break;
                }
                case 9: {
                    direction = previous == Direction.E ? Direction.N : Direction.S;
                    break;
                }
                case 10: {
                    direction = Direction.S;
                    break;
                }
                case 11: {
                    direction = Direction.S;
                    break;
                }
                case 12: {
                    direction = Direction.W;
                    break;
                }
                case 13: {
                    direction = Direction.N;
                    break;
                }
                case 14: {
                    direction = Direction.W;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            directions.add(direction);
            previous = direction;
        } while ((x += direction.screenX) != initialX || (y += direction.screenY) != initialY);
        return new Path(initialX, initialY, directions);
    }

    public Path identifyPerimeter() {
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                if (!this.strategy.pixelIsPart(x, y)) continue;
                return this.identifyPerimeter(x, y);
            }
        }
        return null;
    }

    private int value(int x, int y) {
        int sum = 0;
        if (this.isSet(x, y)) {
            sum |= 1;
        }
        if (this.isSet(x + 1, y)) {
            sum |= 2;
        }
        if (this.isSet(x, y + 1)) {
            sum |= 4;
        }
        if (this.isSet(x + 1, y + 1)) {
            sum |= 8;
        }
        return sum;
    }

    private boolean isSet(int x, int y) {
        boolean insideBounds;
        boolean bl = insideBounds = x > 0 && x <= this.width && y > 0 && y <= this.height;
        if (!insideBounds) {
            return false;
        }
        return this.strategy.pixelIsPart(x - 1, y - 1);
    }
}

