/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.docking.controls;

import de.javasoft.docking.controls.ActiveDockableTracker;
import de.javasoft.docking.controls.Dockbar;
import de.javasoft.docking.controls.DockbarDeactivator;
import de.javasoft.docking.controls.DockbarEvent;
import de.javasoft.docking.controls.DockbarLabel;
import de.javasoft.docking.controls.DockbarLayout;
import de.javasoft.docking.controls.DockbarSlidePanel;
import de.javasoft.docking.controls.DockbarTracker;
import de.javasoft.docking.controls.DockingManager;
import de.javasoft.docking.controls.DockingPath;
import de.javasoft.docking.controls.DockingState;
import de.javasoft.docking.controls.DockingUtility;
import de.javasoft.docking.controls.FloatingDialog;
import de.javasoft.docking.controls.FloatingDockingPort;
import de.javasoft.docking.controls.FloatingFrame;
import de.javasoft.docking.controls.IDockable;
import de.javasoft.docking.controls.IDockbarEventListener;
import de.javasoft.docking.controls.Perspective;
import de.javasoft.docking.controls.RestorationManager;
import de.javasoft.docking.controls.RootWindow;
import de.javasoft.docking.controls.SlidePanelAnimation;
import de.javasoft.docking.controls.StatusDockbar;
import de.javasoft.docking.controls.StatusDockbarManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;

class DockbarManager {
    public static final Integer DOCKBAR_LAYER = JLayeredPane.PALETTE_LAYER - 5;
    public static final int DEFAULT_PLACEMENT = 2;
    private static WeakHashMap<RootWindow, DockbarManager> managers = new WeakHashMap();
    private static String dockbarManagerClassName;
    private static DockbarManager currentManager;
    protected WeakReference<RootWindow> windowRef;
    protected Dockbar leftBar;
    protected Dockbar rightBar;
    protected Dockbar bottomBar;
    protected DockbarSlidePanel slidePanel;
    protected DockbarLayout dockbarLayout;
    private List<IDockbarEventListener> dockbarListeners = new ArrayList<IDockbarEventListener>();
    private DockbarDeactivator dockbarDeactivator;
    private HashMap<String, Integer> dockables;
    private int activePlacement = -1;
    private String activeDockableId;
    private boolean animating;
    private boolean dragging;
    private PropertyChangeListener dockablePropertyHandler = new DockablePropertyChangeHandler();

    static {
        DockbarTracker.register();
    }

    protected DockbarManager(RootWindow window) {
        this.dockbarLayout = new DockbarLayout(this);
        this.dockbarDeactivator = new DockbarDeactivator(this);
        this.leftBar = new Dockbar(this, 2);
        this.rightBar = new Dockbar(this, 4);
        this.bottomBar = new StatusDockbar(this, 3);
        this.slidePanel = new DockbarSlidePanel(this);
        this.windowRef = new WeakReference<RootWindow>(window);
        this.dockables = new HashMap();
        this.addDockbarListener(new IDockbarEventListener(){

            @Override
            public void dockableExpanded(DockbarEvent evt) {
            }

            @Override
            public void dockableLocked(DockbarEvent evt) {
                IDockable d = (IDockable)evt.getSource();
                ActiveDockableTracker.requestDockableActivation(d.getComponent(), false);
            }

            @Override
            public void dockableCollapsed(DockbarEvent evt) {
            }

            @Override
            public void minimizeStarted(DockbarEvent evt) {
            }

            @Override
            public void minimizeCompleted(DockbarEvent evt) {
            }
        });
    }

    static DockbarManager getInstance(Component c) {
        RootWindow rw = RootWindow.getRootWindow(c);
        return DockbarManager.getInstance(rw);
    }

    static void removeDockbarManager(RootWindow w) {
        DockbarManager m = managers.get(w);
        managers.remove(w);
        if (currentManager == m) {
            currentManager = null;
        }
        if (m != null) {
            if (m.slidePanel != null) {
                w.getLayeredPane().remove(m.slidePanel);
            }
            m.dockables.clear();
        }
    }

    static void removeDockbarManager(DockbarManager manager) {
        for (Map.Entry<RootWindow, DockbarManager> entry : managers.entrySet()) {
            RootWindow w = entry.getKey();
            DockbarManager m = entry.getValue();
            if (w == null || m != manager) continue;
            DockbarManager.removeDockbarManager(w);
            break;
        }
    }

    private static DockbarManager getInstance(RootWindow rw) {
        boolean minInOwner;
        Window root = rw.getWindow();
        boolean isFloating = root instanceof FloatingDialog || root instanceof FloatingFrame;
        boolean bl = minInOwner = DockingManager.getMinimizeManager().getWindow(root) != root;
        if (isFloating && minInOwner) {
            root = root instanceof FloatingFrame ? ((FloatingFrame)root).getOwner() : root.getOwner();
            return DockbarManager.getInstance(root);
        }
        DockbarManager mgr = managers.get(rw);
        if (mgr == null) {
            mgr = DockbarManager.createDockbarManager(rw);
            managers.put(rw, mgr);
            mgr.install();
        }
        if (currentManager == null) {
            currentManager = mgr;
        }
        return mgr;
    }

    private static DockbarManager createDockbarManager(RootWindow window) {
        if (dockbarManagerClassName == null) {
            return new StatusDockbarManager(window);
        }
        DockbarManager mgr = null;
        try {
            Class<?> clazz = Class.forName(dockbarManagerClassName);
            Constructor<?> constructor = clazz.getConstructor(RootWindow.class);
            mgr = (DockbarManager)constructor.newInstance(window);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return mgr;
    }

    public static void setDockbarManager(String className) {
        dockbarManagerClassName = className;
    }

    public static DockbarManager getCurrent() {
        return currentManager;
    }

    public static DockbarManager getCurrent(IDockable dockable) {
        for (Map.Entry<RootWindow, DockbarManager> entry : managers.entrySet()) {
            RootWindow rootWindow = entry.getKey();
            DockbarManager mgr = entry.getValue();
            if (!mgr.isOwner(dockable) || !rootWindow.isAlive()) continue;
            return mgr;
        }
        return null;
    }

    protected void install() {
        RootWindow window = this.getRootWindow();
        if (window == null) {
            return;
        }
        JLayeredPane layerPane = window.getLayeredPane();
        boolean changed = this.install(this.leftBar, layerPane);
        changed |= this.install(this.rightBar, layerPane);
        changed |= this.install(this.bottomBar, layerPane);
        if (changed |= this.install(this.slidePanel, layerPane)) {
            layerPane.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent evt) {
                    if (evt.getSource() instanceof JLayeredPane) {
                        DockbarManager.this.revalidate();
                    }
                }
            });
        }
        this.revalidate();
    }

    private boolean install(Component c, JLayeredPane layerPane) {
        if (c.getParent() != layerPane) {
            if (c.getParent() != null) {
                c.getParent().remove(c);
            }
            layerPane.add(c, DOCKBAR_LAYER);
            return true;
        }
        return false;
    }

    public static void windowChanged(Component newWindow) {
        currentManager = DockbarManager.getInstance(newWindow);
    }

    public static void activate(String dockableID, boolean locked) {
        IDockable dockable = DockingManager.getDockable(dockableID);
        DockbarManager.activate(dockable, locked);
    }

    public static void activate(IDockable dockable, boolean locked) {
        if (dockable == null) {
            return;
        }
        DockbarManager mgr = DockbarManager.getCurrent(dockable);
        if (mgr == null || !mgr.contains(dockable)) {
            return;
        }
        mgr.setActiveDockable(dockable);
        if (locked) {
            mgr.lockSlidePanel();
        }
    }

    public void lockSlidePanel() {
        this.getSlidePanel().setLocked(true);
        IDockable dockable = this.getActiveDockable();
        DockbarEvent evt = new DockbarEvent(dockable, 1, this.getActivePlacement());
        this.dispatchEvent(evt);
    }

    public boolean isSlidePanelLocked() {
        return this.getSlidePanel().isLocked();
    }

    DockbarLayout getDockbarLayout() {
        return this.dockbarLayout;
    }

    public RootWindow getRootWindow() {
        return (RootWindow)this.windowRef.get();
    }

    public Dockbar getBottomBar() {
        return this.bottomBar;
    }

    public Dockbar getLeftBar() {
        return this.leftBar;
    }

    public Dockbar getRightBar() {
        return this.rightBar;
    }

    public DockbarSlidePanel getSlidePanel() {
        return this.slidePanel;
    }

    public void revalidate() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DockbarManager.this.validate();
            }
        });
    }

    public void validate() {
        this.toggleDockbars();
        this.dockbarLayout.layout();
        this.slidePanel.revalidate();
        this.slidePanel.repaint();
    }

    private void toggleDockbars() {
        this.leftBar.setVisible(this.leftBar.getComponentCount() != 0);
        this.rightBar.setVisible(this.rightBar.getComponentCount() != 0);
        this.bottomBar.setVisible(this.bottomBar.getComponentCount() != 0);
    }

    private int findDockbarPlacement(IDockable dockable) {
        RootWindow window = RootWindow.getRootWindow(dockable.getComponent());
        if (window == null) {
            return 2;
        }
        JComponent cmp = dockable.getComponent();
        Container contentPane = window.getContentPane();
        Rectangle contentRect = new Rectangle(0, 0, contentPane.getWidth(), contentPane.getHeight());
        Rectangle dockRect = SwingUtilities.convertRectangle(cmp.getParent(), cmp.getBounds(), contentPane);
        Point dockCenter = new Point(dockRect.x + dockRect.width / 2, dockRect.y + dockRect.height / 2);
        Point leftCenter = new Point(0, contentRect.height / 2);
        Point bottomCenter = new Point(contentRect.width / 2, contentRect.height);
        Point rightCenter = new Point(contentRect.width, contentRect.height / 2);
        double min = Math.abs(dockCenter.distance(leftCenter));
        int placement = 2;
        double delta = Math.abs(dockCenter.distance(rightCenter));
        if (delta < min) {
            min = delta;
            placement = 4;
        }
        if ((delta = Math.abs(dockCenter.distance(bottomCenter))) < min) {
            min = delta;
            placement = 3;
        }
        return placement;
    }

    public int getPlacement(String dockableID) {
        IDockable dockable = DockingManager.getDockable(dockableID);
        return this.getPlacement(dockable);
    }

    public int getPlacement(IDockable dockable) {
        Dockbar dockbar = this.getDockbar(dockable);
        if (dockbar == this.leftBar) {
            return 2;
        }
        if (dockbar == this.rightBar) {
            return 4;
        }
        if (dockbar == this.bottomBar) {
            return 3;
        }
        return -1;
    }

    public Dockbar getDockbar(IDockable dockable) {
        if (dockable == null) {
            return null;
        }
        if (this.leftBar.contains(dockable)) {
            return this.leftBar;
        }
        if (this.rightBar.contains(dockable)) {
            return this.rightBar;
        }
        if (this.bottomBar.contains(dockable)) {
            return this.bottomBar;
        }
        return null;
    }

    public Dockbar getDockbar(int placement) {
        switch (placement) {
            case 4: {
                return this.rightBar;
            }
            case 3: {
                return this.bottomBar;
            }
        }
        return this.leftBar;
    }

    void minimize(IDockable dockable, Perspective perspective) {
        if (dockable == null) {
            return;
        }
        int placement = 2;
        if (this.getRootWindow() != null && DockingManager.isDocked(dockable)) {
            placement = this.findDockbarPlacement(dockable);
        }
        this.minimize(dockable, perspective, placement);
    }

    void minimize(IDockable dockable, Perspective perspective, int placement) {
        if (dockable == null) {
            return;
        }
        if (this.isDockingCancelled(dockable, placement)) {
            return;
        }
        this.install(dockable, perspective, placement);
        this.dockables.put(dockable.getID(), placement);
        dockable.getComponent().addPropertyChangeListener(this.dockablePropertyHandler);
        DockingState state = DockingManager.getPerspectiveManager().getCurrentPerspective().getDockingState(dockable, false);
        DockingPath path = state.getPath();
        if (DockingManager.getFloatingMode() == DockingManager.FloatingMode.MIN_MAX_OWNER && path.getRootDockingPort() instanceof FloatingDockingPort) {
            state.setPath((DockingPath)state.getFloatingRestorePath().clone());
        }
        DockbarEvent evt = new DockbarEvent(dockable, 11, placement);
        this.dispatchEvent(evt);
    }

    void reAdd(IDockable dockable, Perspective perspective) {
        if (dockable == null || this.contains(dockable)) {
            return;
        }
        Integer placement = this.dockables.get(dockable.getID());
        if (placement != null) {
            this.install(dockable, perspective, placement);
        }
    }

    List<IDockable> getDockables(int placement) {
        ArrayList<IDockable> dockableList = new ArrayList<IDockable>();
        for (Map.Entry<String, Integer> entry : this.dockables.entrySet()) {
            if (entry.getValue() != placement) continue;
            dockableList.add(DockingManager.getDockable(entry.getKey()));
        }
        return dockableList;
    }

    List<IDockable> getDockables() {
        ArrayList<IDockable> dockableList = new ArrayList<IDockable>();
        for (Map.Entry<String, Integer> entry : this.dockables.entrySet()) {
            dockableList.add(DockingManager.getDockable(entry.getKey()));
        }
        return dockableList;
    }

    private void install(IDockable dockable, Perspective perspective, int placement) {
        Dockbar dockbar = this.getDockbar(placement);
        DockingManager.undock(dockable);
        dockbar.dock(dockable);
        dockable.setDockingEnabled(false);
        DockingState state = perspective.getDockingState(dockable, false);
        state.setPlacement(placement);
        this.revalidate();
    }

    private boolean isDockingCancelled(IDockable dockable, int placement) {
        DockbarEvent evt = new DockbarEvent(dockable, 10, placement);
        this.dispatchEvent(evt);
        return evt.isConsumed();
    }

    void restore(IDockable dockable, Perspective perspective) {
        boolean success = RestorationManager.getInstance().restore(dockable, perspective);
        if (success) {
            this.remove(dockable);
            this.dockables.remove(dockable.getID());
            dockable.getComponent().removePropertyChangeListener(this.dockablePropertyHandler);
        }
    }

    public boolean remove(IDockable dockable) {
        Dockbar dockbar;
        if (dockable == null) {
            return false;
        }
        if (this.getActiveDockable() == dockable) {
            this.setActiveDockable((IDockable)null);
        }
        if ((dockbar = this.getDockbar(dockable)) == null) {
            return false;
        }
        dockbar.undock(dockable);
        dockable.setDockingEnabled(true);
        this.revalidate();
        dockbar.repaint();
        return true;
    }

    public int getActivePlacement() {
        return this.activePlacement;
    }

    private void setActivePlacement(int placement) {
        this.activePlacement = placement;
    }

    String getActiveDockableId() {
        return this.activeDockableId;
    }

    private void setActiveDockableId(String id) {
        this.activeDockableId = id;
    }

    public IDockable getActiveDockable() {
        String dockingId = this.getActiveDockableId();
        IDockable dockable = DockingManager.getDockable(dockingId);
        return dockable;
    }

    public Cursor getResizeCursor() {
        return this.slidePanel.getResizeCursor();
    }

    public boolean isActive() {
        return this.getActiveDockable() != null;
    }

    public boolean isDockbarActive() {
        return this.isActive() && !this.isAnimating() && !this.isDragging();
    }

    public void setActiveDockable(String dockableID) {
        IDockable dockable = DockingManager.getDockable(dockableID);
        this.setActiveDockable(dockable);
    }

    public void setActiveDockable(IDockable dockable) {
        int newPlacement = this.getPlacement(dockable);
        if (newPlacement == -1) {
            dockable = null;
        }
        IDockable oldDockable = this.getActiveDockable();
        String newDockableId = dockable == null ? null : dockable.getID();
        String currentlyActiveId = this.getActiveDockableId();
        boolean changed = DockingUtility.isChanged(currentlyActiveId, newDockableId);
        if (changed |= newPlacement != this.getActivePlacement()) {
            this.slidePanel.setLocked(false);
            this.setActivePlacement(newPlacement);
            this.setActiveDockableId(newDockableId);
            this.startAnimation(oldDockable, dockable, newDockableId, newPlacement);
        }
    }

    private void dispatchEvent(IDockable oldDockable, IDockable newDockable) {
        int evtType = 0;
        if (newDockable == null && oldDockable != null) {
            newDockable = oldDockable;
            evtType = 2;
        }
        if (newDockable != null) {
            DockbarEvent evt = new DockbarEvent(newDockable, evtType, this.getActivePlacement());
            this.dispatchEvent(evt);
        }
    }

    private void startAnimation(final IDockable oldDockable, final IDockable newDockable, final String newDockableId, final int newPlacement) {
        SlidePanelAnimation deactivation = oldDockable == null ? null : new SlidePanelAnimation(this, true);
        Runnable updater1 = new Runnable(){

            @Override
            public void run() {
                DockbarManager.this.setActivePlacement(newPlacement);
                DockbarManager.this.setActiveDockableId(newDockableId);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        (this).DockbarManager.this.slidePanel.updatePlacement();
                        (this).DockbarManager.this.slidePanel.updateContents();
                    }
                });
            }
        };
        SlidePanelAnimation activation = newDockableId == null ? null : new SlidePanelAnimation(this, false);
        Runnable updater2 = new Runnable(){

            @Override
            public void run() {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        (this).DockbarManager.this.slidePanel.setPrefSize(-1);
                        (this).DockbarManager.this.slidePanel.updatePlacement();
                        (this).DockbarManager.this.slidePanel.updateContents();
                        DockbarManager.this.dispatchEvent(oldDockable, newDockable);
                    }
                });
            }
        };
        ActivationQueue queue = new ActivationQueue(deactivation, updater1, activation, updater2);
        queue.start();
    }

    public int getPreferredViewpaneSize() {
        return this.dockbarLayout.getDesiredViewpaneSize();
    }

    public boolean isAnimating() {
        return this.animating;
    }

    public void setAnimating(boolean animating) {
        this.animating = animating;
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public void setDragging(boolean dragging) {
        this.dragging = dragging;
    }

    DockbarDeactivator getDockbarDeactivator() {
        return this.dockbarDeactivator;
    }

    public boolean contains(IDockable dockable) {
        return this.getDockbar(dockable) != null;
    }

    private boolean isOwner(IDockable dockable) {
        return dockable == null ? false : this.dockables.containsKey(dockable.getID());
    }

    DockbarLayout getLayout() {
        return this.dockbarLayout;
    }

    public void addDockbarListener(IDockbarEventListener listener) {
        this.dockbarListeners.add(listener);
    }

    public List<IDockbarEventListener> getDockbarListeners() {
        return this.dockbarListeners;
    }

    public void removeDockbarListener(IDockbarEventListener listener) {
        this.dockbarListeners.remove(listener);
    }

    private void dispatchEvent(DockbarEvent evt) {
        for (IDockbarEventListener l : this.getDockbarListeners()) {
            switch (evt.getEventType()) {
                case 0: {
                    l.dockableExpanded(evt);
                    break;
                }
                case 1: {
                    l.dockableLocked(evt);
                    break;
                }
                case 2: {
                    l.dockableCollapsed(evt);
                    break;
                }
                case 10: {
                    l.minimizeStarted(evt);
                    break;
                }
                case 11: {
                    l.minimizeCompleted(evt);
                }
            }
        }
    }

    private static class ActivationQueue
    extends Thread {
        private SlidePanelAnimation deactivation;
        private Runnable postDeactivate;
        private SlidePanelAnimation activation;
        private Runnable postActivate;

        public ActivationQueue(SlidePanelAnimation deactivation, Runnable r1, SlidePanelAnimation activation, Runnable r2) {
            this.deactivation = deactivation;
            this.postDeactivate = r1;
            this.activation = activation;
            this.postActivate = r2;
        }

        @Override
        public void run() {
            if (this.deactivation != null) {
                this.deactivation.run();
            }
            this.postDeactivate.run();
            if (this.activation != null) {
                this.activation.run();
            }
            this.postActivate.run();
        }
    }

    private static class DockablePropertyChangeHandler
    implements PropertyChangeListener {
        private DockablePropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            DockbarLabel label;
            IDockable dockable = (IDockable)evt.getSource();
            DockbarManager m = DockbarManager.getCurrent();
            if (m == null || !DockingManager.isMinimized(dockable, DockingManager.getPerspectiveManager().getCurrentPerspective())) {
                return;
            }
            Dockbar dockbar = m.getDockbar(dockable);
            DockbarLabel dockbarLabel = label = dockbar == null ? null : dockbar.getLabel(dockable);
            if (label == null) {
                return;
            }
            String name = evt.getPropertyName();
            if ("dockbarIcon".equals(name)) {
                label.setIcon(dockable.getDockbarIcon());
            } else if ("tabText".equals(name)) {
                label.setText(dockable.getTabText());
            }
        }
    }
}

